/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import smsqmulator.Monitor;
import smsqmulator.Screen;
import smsqmulator.cpu.MC68000Cpu;

public class Screen32
extends Screen {
    private static final int nbrOfBytesPerPixel = 2;
    private final int[] clut = new int[65536];
    private int QLmode;

    public Screen32(int n, int n2, int n3, boolean bl, Monitor monitor, boolean bl2) {
        super(n, n2, monitor, bl2);
        this.mode = 32;
        int n4 = n % 8;
        if (n4 != 0) {
            n = (n / 8 + 1) * 8;
        }
        this.stopAddress = n * n2 * 2;
        this.nbrOfBytesPerLine = n * 2;
        this.startAddress = n3;
        this.stopAddress += this.startAddress - 2;
        this.vibrantColours = bl;
        this.makeClutColours(bl);
    }

    @Override
    public void writeByteToScreen(int n, int n2, int n3) {
    }

    @Override
    public void writeWordToScreen(int n, int n2) {
        int n3 = (n -= this.startAddress) / this.nbrOfBytesPerLine;
        int n4 = n - n3 * this.nbrOfBytesPerLine;
        n4 /= 2;
        int n5 = this.clut[n2 & 0xFFFF];
        if (this.dataBuffer.getElem(n4 += n3 * this.xsize) != n5) {
            this.dataBuffer.setElem(n4, n5);
            this.isDirty = true;
        }
    }

    @Override
    public void writeLongToScreen(int n, int n2) {
        if (n > this.stopAddress - 3) {
            return;
        }
        int n3 = n2 >>> 16;
        n2 &= 0xFFFF;
        int n4 = (n -= this.startAddress) / this.nbrOfBytesPerLine;
        int n5 = n - n4 * this.nbrOfBytesPerLine;
        n5 /= 2;
        int n6 = this.clut[n3];
        if (this.dataBuffer.getElem(n5 += n4 * this.xsize) != n6) {
            this.dataBuffer.setElem(n5, n6);
            this.isDirty = true;
        }
        n6 = this.clut[n2];
        if (this.dataBuffer.getElem(++n5) != n6) {
            this.dataBuffer.setElem(n5, n6);
            this.isDirty = true;
        }
    }

    @Override
    public void clearScreen() {
        int[] nArray = new int[this.xsize * this.ysize];
        this.raster.setDataElements(0, 0, this.xsize, this.ysize, nArray);
        this.isDirty = true;
    }

    private void getColoursFromStipple(int[] nArray) {
        int n = nArray[0] & 3;
        int n2 = nArray[1];
        int n3 = n2 & 0xFFFF;
        int n4 = n2 >>> 16;
        nArray[0] = n2;
        switch (n) {
            case 0: {
                nArray[1] = nArray[1] & 0xFFFF0000;
                nArray[1] = nArray[1] | n4;
                break;
            }
            case 1: {
                nArray[0] = n4 << 16 | n4;
                nArray[1] = n3 << 16 | n3;
                break;
            }
            case 3: {
                nArray[0] = n3 << 16 | n4;
            }
        }
    }

    @Override
    public void fillBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        if (mC68000Cpu.data_regs[1] == 0) {
            return;
        }
        int n = mC68000Cpu.data_regs[2] >>> 16;
        int n2 = mC68000Cpu.data_regs[2] & 0xFFFF;
        int n3 = mC68000Cpu.data_regs[1] >>> 16;
        int n4 = mC68000Cpu.data_regs[1] & 0xFFFF;
        int n5 = mC68000Cpu.addr_regs[1];
        boolean bl2 = n5 >= this.startAddress && n5 <= this.stopAddress;
        int[] nArray = new int[]{mC68000Cpu.data_regs[6], mC68000Cpu.data_regs[7]};
        if (bl) {
            this.getColoursFromStipple(nArray);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if ((n & 1) != 0) {
            bl3 = true;
            --n3;
        }
        if ((n3 & 1) != 0) {
            bl4 = true;
            --n3;
        }
        int n6 = n3 / 2;
        boolean bl5 = (n2 & 1) == 0;
        short s = (short)(nArray[0] >>> 16);
        int n7 = this.clut[s & 0xFFFF];
        short s2 = (short)(nArray[0] & 0xFFFF);
        int n8 = this.clut[s2 & 0xFFFF];
        short s3 = (short)(nArray[1] >>> 16);
        int n9 = this.clut[s3 & 0xFFFF];
        short s4 = (short)(nArray[1] & 0xFFFF);
        int n10 = this.clut[s4 & 0xFFFF];
        int n11 = mC68000Cpu.addr_regs[2];
        n5 += n2 * n11;
        n5 += n * 2;
        n5 /= 2;
        n11 /= 2;
        short[] sArray = mC68000Cpu.getMemory();
        n2 *= this.xsize;
        n2 += n;
        n3 = mC68000Cpu.data_regs[1] >>> 16;
        n11 -= n3;
        int n12 = this.xsize - n3;
        for (int i = 0; i < n4; ++i) {
            if (bl3) {
                if (bl5) {
                    sArray[n5++] = s2;
                    if (bl2) {
                        this.dataBuffer.setElem(n2++, n8);
                    }
                } else {
                    sArray[n5++] = s4;
                    if (bl2) {
                        this.dataBuffer.setElem(n2++, n10);
                    }
                }
            }
            for (int j = 0; j < n6; ++j) {
                if (bl5) {
                    sArray[n5++] = s;
                    sArray[n5++] = s2;
                    if (!bl2) continue;
                    this.dataBuffer.setElem(n2++, n7);
                    this.dataBuffer.setElem(n2++, n8);
                    continue;
                }
                sArray[n5++] = s3;
                sArray[n5++] = s4;
                if (!bl2) continue;
                this.dataBuffer.setElem(n2++, n9);
                this.dataBuffer.setElem(n2++, n10);
            }
            if (bl4) {
                if (bl5) {
                    sArray[n5++] = s;
                    if (bl2) {
                        this.dataBuffer.setElem(n2++, n7);
                    }
                } else {
                    sArray[n5++] = s3;
                    if (bl2) {
                        this.dataBuffer.setElem(n2++, n9);
                    }
                }
            }
            n5 += n11;
            n2 += n12;
            bl5 = !bl5;
        }
        this.isDirty = true;
    }

    @Override
    public void xorBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        boolean bl2;
        if (mC68000Cpu.data_regs[1] == 0) {
            return;
        }
        int n = mC68000Cpu.data_regs[2] >>> 16;
        int n2 = mC68000Cpu.data_regs[2] & 0xFFFF;
        int n3 = mC68000Cpu.data_regs[1] >>> 16;
        int n4 = mC68000Cpu.data_regs[1] & 0xFFFF;
        int n5 = mC68000Cpu.addr_regs[1];
        boolean bl3 = bl2 = n5 >= this.startAddress && n5 <= this.stopAddress;
        if (!bl2) {
            mC68000Cpu.data_regs[0] = -4;
            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
            return;
        }
        int[] nArray = new int[]{mC68000Cpu.data_regs[6], mC68000Cpu.data_regs[7]};
        if (bl) {
            this.getColoursFromStipple(nArray);
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if ((n & 1) != 0) {
            bl4 = true;
            --n3;
        }
        if ((n3 & 1) != 0) {
            bl5 = true;
            --n3;
        }
        int n6 = n3 / 2;
        boolean bl6 = (n2 & 1) == 0;
        short s = (short)(nArray[0] >>> 16);
        int n7 = this.clut[s & 0xFFFF];
        short s2 = (short)(nArray[0] & 0xFFFF);
        int n8 = this.clut[s2 & 0xFFFF];
        short s3 = (short)(nArray[1] >>> 16);
        int n9 = this.clut[s3 & 0xFFFF];
        short s4 = (short)(nArray[1] & 0xFFFF);
        int n10 = this.clut[s4 & 0xFFFF];
        int n11 = mC68000Cpu.addr_regs[2];
        n5 += n2 * n11;
        n5 += n * 2;
        n5 /= 2;
        n11 /= 2;
        short[] sArray = mC68000Cpu.getMemory();
        n2 *= this.xsize;
        n2 += n;
        for (int i = 0; i < n4; ++i) {
            short s5;
            int n12 = n2;
            int n13 = n5;
            if (bl4) {
                if (bl6) {
                    s5 = (short)(sArray[n13] ^ s2);
                    sArray[n13++] = s5;
                    if (bl2) {
                        this.dataBuffer.setElem(n12, this.dataBuffer.getElem(n12) ^ n8);
                        ++n12;
                    }
                } else {
                    s5 = (short)(sArray[n13] ^ s4);
                    sArray[n13++] = s5;
                    if (bl2) {
                        this.dataBuffer.setElem(n12, this.dataBuffer.getElem(n12) ^ n10);
                        ++n12;
                    }
                }
            }
            for (int j = 0; j < n6; ++j) {
                if (bl6) {
                    s5 = (short)(sArray[n13] ^ s);
                    sArray[n13++] = s5;
                    s5 = (short)(sArray[n13] ^ s2);
                    sArray[n13++] = s5;
                    if (!bl2) continue;
                    this.dataBuffer.setElem(n12, this.dataBuffer.getElem(n12) ^ n7);
                    this.dataBuffer.setElem(++n12, this.dataBuffer.getElem(n12) ^ n8);
                    ++n12;
                    continue;
                }
                s5 = (short)(sArray[n13] ^ s3);
                sArray[n13++] = s5;
                s5 = (short)(sArray[n13] ^ s4);
                sArray[n13++] = s5;
                if (!bl2) continue;
                this.dataBuffer.setElem(n12, this.dataBuffer.getElem(n12) ^ n9);
                this.dataBuffer.setElem(++n12, this.dataBuffer.getElem(n12) ^ n10);
                ++n12;
            }
            if (bl5) {
                if (bl6) {
                    s5 = (short)(sArray[n13] ^ s);
                    sArray[n13++] = s5;
                    if (bl2) {
                        this.dataBuffer.setElem(n12, this.dataBuffer.getElem(n12) ^ n7);
                        ++n12;
                    }
                } else {
                    s5 = (short)(sArray[n13] ^ s3);
                    sArray[n13++] = s5;
                    if (bl2) {
                        this.dataBuffer.setElem(n12, this.dataBuffer.getElem(n12) ^ n9);
                        ++n12;
                    }
                }
            }
            n5 += n11;
            n2 += this.xsize;
            bl6 = !bl6;
        }
        this.isDirty = true;
    }

    private static short alphaBlend(int n, int n2, double d) {
        int n3 = n & 0xF8;
        int n4 = ((n & 0xE000) >>> 11) + ((n & 7) << 5);
        int n5 = (n & 0x1F00) >>> 5;
        int n6 = n2 & 0xF8;
        int n7 = ((n2 & 0xE000) >>> 11) + ((n2 & 7) << 5);
        int n8 = (n2 & 0x1F00) >>> 5;
        n6 = (int)((double)n3 * d + (double)n6 * (1.0 - d));
        n7 = (int)((double)n4 * d + (double)n7 * (1.0 - d));
        n8 = (int)((double)n5 * d + (double)n8 * (1.0 - d));
        n6 &= 0xF8;
        n7 &= 0xFC;
        n7 = (n7 >>> 5) + ((n7 & 0x1C) << 11);
        n8 &= 0xF8;
        n6 |= n7;
        return (short)(n6 |= (n8 <<= 5));
    }

    private void makeClutColours(boolean bl) {
        if (!bl) {
            for (int i = 1; i < 65536; ++i) {
                int n = ((i & 0xE000) >>> 3) + ((i & 7) << 13);
                int n2 = i & 0xF8;
                if (n2 != 0) {
                    n2 <<= 16;
                }
                int n3 = (i & 0x1F00) >>> 5;
                this.clut[i] = n3 | n2 | n;
            }
        } else {
            for (int i = 1; i < 65536; ++i) {
                int n;
                int n4;
                int n5 = ((i & 0xE000) >>> 3) + ((i & 7) << 13);
                if (n5 != 0) {
                    n5 += 768;
                }
                if ((n4 = i & 0xF8) != 0) {
                    n4 <<= 16;
                    n4 += 458752;
                }
                if ((n = (i & 0x1F00) >>> 5) != 0) {
                    n += 7;
                }
                this.clut[i] = n | n4 | n5;
            }
        }
    }

    @Override
    public void moveBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        if (bl) {
            int n = mC68000Cpu.data_regs[1] >>> 16 & 0xFFFF;
            int n2 = mC68000Cpu.data_regs[1] & 0xFFFF;
            int n3 = mC68000Cpu.data_regs[2] >>> 16 & 0xFFFF;
            int n4 = mC68000Cpu.data_regs[2] & 0xFFFF;
            int n5 = mC68000Cpu.data_regs[3] >>> 16 & 0xFFFF;
            int n6 = mC68000Cpu.data_regs[3] & 0xFFFF;
            int[] nArray = new int[n * n2];
            this.raster.getDataElements(n3, n4, n, n2, nArray);
            this.raster.setDataElements(n5, n6, n, n2, nArray);
        } else {
            this.paintBlock(mC68000Cpu.data_regs[1], mC68000Cpu.data_regs[3], mC68000Cpu.getMemory());
        }
        this.isDirty = true;
    }

    private void paintBlock(int n, int n2, short[] sArray) {
        int n3 = n >>> 16;
        n &= 0xFFFF;
        int n4 = n2 >>> 16;
        int n5 = this.nbrOfBytesPerLine / 2;
        int n6 = (n2 &= 0xFFFF) * n5 + n4;
        n6 += this.startAddress / 2;
        n2 *= this.xsize;
        for (int i = 0; i < n; ++i) {
            int n7 = n4 + n2;
            int n8 = n6 + n3;
            for (int j = n6; j < n8; ++j) {
                int n9 = sArray[j] & 0xFFFF;
                this.dataBuffer.setElem(n7++, this.clut[n9]);
            }
            n6 += n5;
            n2 += this.xsize;
        }
    }

    @Override
    public void displayRegion(MC68000Cpu mC68000Cpu, int n, int n2) {
        if (this.stopAddress < n + n2) {
            n2 -= n + n2 - this.stopAddress;
        }
        if (n < this.startAddress) {
            n2 -= this.startAddress - n;
            n = this.startAddress;
        }
        if (n2 < 1) {
            return;
        }
        int n3 = n / 2;
        n -= this.startAddress;
        short[] sArray = mC68000Cpu.getMemory();
        int n4 = 0;
        while (n4 < n2 / 2) {
            short s = sArray[n3];
            this.paintPixel(n, s);
            ++n4;
            n += 2;
            ++n3;
        }
        this.isDirty = true;
    }

    private void paintPixel(int n, int n2) {
        int n3 = n / this.nbrOfBytesPerLine;
        int n4 = n - n3 * this.nbrOfBytesPerLine;
        this.dataBuffer.setElem((n4 /= 2) + n3 * this.xsize, this.clut[n2]);
    }

    @Override
    public void combineBlocks(MC68000Cpu mC68000Cpu) {
        short[] sArray;
        short[] sArray2;
        short[] sArray3;
        int n = mC68000Cpu.data_regs[6] & 0xFF;
        double d = (double)n / 255.0;
        short[] sArray4 = mC68000Cpu.getMemory();
        boolean bl = false;
        n = mC68000Cpu.data_regs[1] >>> 16 & 0xFFFF;
        int n2 = mC68000Cpu.data_regs[1] & 0xFFFF;
        int n3 = mC68000Cpu.data_regs[2] >>> 16 & 0xFFFF;
        int n4 = mC68000Cpu.data_regs[2] & 0xFFFF;
        int n5 = mC68000Cpu.data_regs[3] >>> 16 & 0xFFFF;
        int n6 = mC68000Cpu.data_regs[3] & 0xFFFF;
        int n7 = mC68000Cpu.data_regs[4] >>> 16 & 0xFFFF;
        int n8 = mC68000Cpu.data_regs[4] & 0xFFFF;
        int n9 = mC68000Cpu.addr_regs[2] / 2;
        int n10 = mC68000Cpu.addr_regs[4];
        if (n10 >= this.startAddress) {
            n10 = n4 * n9 + n3 + this.startAddress / 2;
            sArray3 = sArray4;
        } else {
            n10 = n10 / 2 + n4 * n9 + n3;
            sArray3 = sArray4;
        }
        int n11 = mC68000Cpu.data_regs[7] / 2;
        int n12 = mC68000Cpu.addr_regs[1];
        if (n12 >= this.startAddress) {
            n12 = n8 * n11 + n7 + this.startAddress / 2;
            sArray2 = sArray4;
        } else {
            n12 = n12 / 2 + n8 * n11 + n7;
            sArray2 = sArray4;
        }
        int n13 = mC68000Cpu.addr_regs[3] / 2;
        int n14 = mC68000Cpu.addr_regs[5];
        if (n14 >= this.startAddress) {
            n14 = n6 * n13 + n5 + this.startAddress / 2;
            sArray = sArray4;
            bl = true;
        } else {
            n14 = n14 / 2 + n6 * n13 + n5;
            sArray = sArray4;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                short s = sArray3[n10 + j];
                short s2 = sArray2[n12 + j];
                int n15 = s & 0xF8;
                int n16 = ((s & 0xE000) >>> 11) + ((s & 7) << 5);
                int n17 = (s & 0x1F00) >>> 5;
                int n18 = s2 & 0xF8;
                int n19 = ((s2 & 0xE000) >>> 11) + ((s2 & 7) << 5);
                int n20 = (s2 & 0x1F00) >>> 5;
                n18 = (int)((double)n15 * d + (double)n18 * (1.0 - d));
                n19 = (int)((double)n16 * d + (double)n19 * (1.0 - d));
                n20 = (int)((double)n17 * d + (double)n20 * (1.0 - d));
                n18 &= 0xF8;
                n19 &= 0xFC;
                n19 = (n19 >>> 5) + ((n19 & 0x1C) << 11);
                n20 &= 0xF8;
                n18 |= n19;
                sArray[n14 + j] = (short)(n18 |= (n20 <<= 5));
            }
            n10 += n9;
            n14 += n13;
            n12 += n11;
        }
        if (bl) {
            this.paintBlock(mC68000Cpu.data_regs[1], mC68000Cpu.data_regs[3], mC68000Cpu.getMemory());
        }
        mC68000Cpu.data_regs[0] = 0;
        mC68000Cpu.reg_sr |= 4;
        this.isDirty = true;
    }

    @Override
    public synchronized void setVramBase(int n) {
        this.startAddress = n;
        this.stopAddress = n + this.getScreenSizeInBytes();
    }

    @Override
    public void setVibrantColours(boolean bl, short[] sArray) {
        this.vibrantColours = bl;
        this.makeClutColours(this.vibrantColours);
        int n = this.startAddress / 2;
        for (int i = 0; i < this.xsize * this.ysize; ++i) {
            int n2 = sArray[n + i] & 0xFFFF;
            this.dataBuffer.setElem(i, this.clut[n2]);
        }
        this.isDirty = true;
    }

    @Override
    public final int getScreenSizeInBytes() {
        return this.xsize * this.ysize * 2;
    }

    @Override
    public boolean isQLScreen() {
        return false;
    }
}

