/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import inifile.IniFile;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import smsqmulator.DoNothingException;
import smsqmulator.Helper;
import smsqmulator.IncorrectFiletypeException;
import smsqmulator.Localization;
import smsqmulator.Types;
import smsqmulator.Warnings;
import smsqmulator.WinDir;
import smsqmulator.WinDriver;
import smsqmulator.WinFile;
import smsqmulator.WinSpecialFile;
import smsqmulator.cpu.MC68000Cpu;

public class WinDrive {
    public static final int QWA_IDEN = 0;
    public static final int QWA_NAME = 4;
    public static final int QWA_SPR0 = 26;
    public static final int QWA_UCHK = 28;
    public static final int QWA_INTL = 32;
    public static final int QWA_SCTG = 34;
    public static final int QWA_SCTT = 36;
    public static final int QWA_TRKC = 38;
    public static final int QWA_CYLD = 40;
    public static final int QWA_NGRP = 42;
    public static final int QWA_FGRP = 44;
    public static final int QWA_SCTM = 46;
    public static final int QWA_NMAP = 48;
    public static final int QWA_FREE = 50;
    public static final int QWA_ROOT = 52;
    public static final int QWA_RLEN = 54;
    public static final int QWA_FCYL = 58;
    public static final int QWA_FSCT = 58;
    public static final int QWA_PARK = 62;
    public static final int QWA_GMAP = 64;
    public static final byte[] LOWER_CASE = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1};
    public static final int MAX_FILES_OPEN = 1000;
    protected MC68000Cpu cpu;
    protected String driveName;
    protected WinDriver driver;
    protected int driveNumber;
    protected Warnings warnings;
    protected RandomAccessFile raFile = null;
    protected FileChannel ioChannel;
    protected boolean readOnly = false;
    protected FileLock flock;
    protected int clusterSize;
    protected ArrayList<Integer> fatClusterChain;
    protected ByteBuffer driveFAT;
    protected WinDir mainDir;
    protected WinFile[] fileNumber = new WinFile[1000];
    protected boolean specialFileIsOpen = false;

    public WinDrive() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public WinDrive(MC68000Cpu mC68000Cpu, Warnings warnings) {
        this.cpu = mC68000Cpu;
        this.warnings = warnings;
    }

    public WinDrive(MC68000Cpu mC68000Cpu, String string, WinDriver winDriver, int n, Warnings warnings, IniFile iniFile) throws FileNotFoundException, IOException, ArrayIndexOutOfBoundsException, ProtocolException, DoNothingException, IncorrectFiletypeException, UnsupportedOperationException {
        this.cpu = mC68000Cpu;
        this.driveName = string;
        this.driver = winDriver;
        this.driveNumber = n;
        this.warnings = warnings;
        this.readFAT(this.driveName, iniFile.getTrueOrFalse("IGNORE-QXLWIN-LOCK-ERROR"), iniFile.getTrueOrFalse("MAKE-UNLOCKABLE-QXLWIN-READONLY"));
        this.readMainDir();
        if (this.mainDir == null) {
            this.closeRAFile();
            throw new ProtocolException(Localization.Texts[56] + "\n(" + string + ")");
        }
    }

    private void readFAT(String string, boolean bl, boolean bl2) throws FileNotFoundException, IOException, ArrayIndexOutOfBoundsException, ProtocolException, UnsupportedOperationException, DoNothingException, IncorrectFiletypeException, IllegalStateException {
        ByteBuffer byteBuffer;
        int n;
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (this.raFile != null) {
            throw new IllegalStateException();
        }
        try {
            this.raFile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.raFile = new RandomAccessFile(file, "r");
            this.readOnly = true;
        }
        this.ioChannel = this.raFile.getChannel();
        if (!this.readOnly) {
            block20: {
                try {
                    this.flock = this.ioChannel.tryLock();
                }
                catch (Exception exception) {
                    if (bl) break block20;
                    throw new UnsupportedOperationException();
                }
            }
            if (this.flock == null) {
                if (!bl) {
                    this.closeRAFile();
                    throw new ProtocolException(Localization.Texts[66]);
                }
                if (bl2) {
                    this.readOnly = true;
                }
            }
        }
        if ((n = this.ioChannel.read(byteBuffer = ByteBuffer.allocate(512))) != 512 || byteBuffer.getInt(0) != 1363957569) {
            this.closeRAFile();
            throw new IncorrectFiletypeException();
        }
        this.clusterSize = 512 * (byteBuffer.getShort(34) & 0xFFFF);
        this.fatClusterChain = new ArrayList();
        this.fatClusterChain.add(0);
        int n2 = byteBuffer.getShort(64) & 0xFFFF;
        try {
            while (n2 != 0) {
                this.fatClusterChain.add(n2);
                n2 = byteBuffer.getShort(64 + n2 * 2) & 0xFFFF;
            }
        }
        catch (Exception exception) {
            this.closeRAFile();
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = byteBuffer.getShort(46) & 0xFFFF;
        int n4 = n3 / (byteBuffer.getShort(34) & 0xFFFF);
        if (n3 % (byteBuffer.getShort(34) & 0xFFFF) != 0) {
            ++n4;
        }
        if (n4 != this.fatClusterChain.size()) {
            int n5;
            if (this.warnings.warnIfQXLDriveNotCompliant) {
                Toolkit.getDefaultToolkit().beep();
                n5 = JOptionPane.showConfirmDialog(null, Localization.Texts[74] + this.driver.getName(this.driveNumber - 48) + Localization.Texts[75] + "\n" + Localization.Texts[76] + "\n" + Localization.Texts[77] + "WIN" + (this.driveNumber - 48) + "_ " + Localization.Texts[78] + "\n", Localization.Texts[73], 2, 0);
                if (n5 != 0) {
                    this.closeRAFile();
                    throw new DoNothingException();
                }
            }
            for (n5 = 1; n5 < n4; ++n5) {
                this.fatClusterChain.add(n5);
            }
        }
        this.driveFAT = ByteBuffer.allocate(this.clusterSize * this.fatClusterChain.size());
        this.driveFAT.position(0);
        this.driveFAT.limit(this.driveFAT.capacity());
        for (int n6 : this.fatClusterChain) {
            this.driveFAT.limit(this.driveFAT.position() + this.clusterSize);
            int n7 = n6 * this.clusterSize;
            this.ioChannel.position(n7);
            this.ioChannel.read(this.driveFAT);
        }
    }

    private void closeRAFile() {
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.raFile = null;
    }

    private void readMainDir() {
        ArrayList<Integer> arrayList;
        int n = this.driveFAT.getShort(52) & 0xFFFF;
        int n2 = this.driveFAT.getInt(54);
        ByteBuffer byteBuffer = this.readFile(n2, n, arrayList = new ArrayList<Integer>());
        if (byteBuffer != null) {
            this.mainDir = new WinDir(this, null, 0, byteBuffer, arrayList, null, null);
        }
    }

    public boolean openFile(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5;
        WinDir winDir;
        int n6;
        if (this.readOnly && n3 != 1 && n3 != 4) {
            this.cpu.data_regs[0] = -20;
            return false;
        }
        if (this.specialFileIsOpen) {
            this.cpu.data_regs[0] = -9;
            return false;
        }
        for (n6 = 0; n6 < 1000 && this.fileNumber[n6] != null; ++n6) {
        }
        if (n6 > 999) {
            this.cpu.data_regs[0] = -11;
            return false;
        }
        this.cpu.data_regs[0] = -7;
        boolean[] blArray = new boolean[5];
        if (byArray.length == 0) {
            winDir = this.mainDir;
            n5 = 0;
            blArray[0] = true;
            blArray[1] = true;
            blArray[2] = false;
            blArray[3] = false;
        } else {
            if (byArray.length == 4 && byArray2[0] == 42 && byArray2[1] == 100 && byArray2[2] == 50 & byArray2[3] == 100) {
                if (n3 < 4) {
                    return this.makeSpecialAccessFile(n6, n2);
                }
                this.cpu.data_regs[0] = -15;
                return false;
            }
            winDir = this.mainDir.findInDirs(byArray2);
            if (winDir == null) {
                return false;
            }
            n5 = winDir.checkFile(blArray, byArray2);
        }
        switch (n3) {
            case 0: {
                if (!blArray[0]) {
                    return false;
                }
                if (!blArray[1] && !blArray[2] && !blArray[3]) break;
                this.cpu.data_regs[0] = -9;
                return false;
            }
            case 1: {
                if (!blArray[0]) {
                    return false;
                }
                if (!blArray[2]) break;
                this.cpu.data_regs[0] = -9;
                return false;
            }
            case 2: {
                if (blArray[0]) {
                    this.cpu.data_regs[0] = -8;
                    return false;
                }
                if (!blArray[1] && !blArray[2] && !blArray[3]) break;
                this.cpu.data_regs[0] = -9;
                return false;
            }
            case 3: {
                int n7;
                if (blArray[1] || blArray[2] || blArray[3]) {
                    this.cpu.data_regs[0] = -9;
                    return false;
                }
                if (blArray[0]) {
                    n7 = winDir.deleteFile(n5);
                    if (n7 < 0) {
                        this.cpu.data_regs[0] = n7;
                        return false;
                    }
                    this.freeClusters(n7);
                    this.flush();
                }
                n3 = 2;
                break;
            }
            case 4: {
                int n7;
                if (!blArray[0] || !blArray[1]) {
                    byArray = winDir.getName();
                    n7 = byArray.length;
                    this.cpu.writeMemoryWord(n2 + 50, n7);
                    for (int i = 0; i < n7; ++i) {
                        this.cpu.writeMemoryByte(n2 + 52 + i, byArray[i]);
                    }
                    n5 = winDir.getIndex();
                    if ((winDir = winDir.getDir()) == null) {
                        winDir = this.mainDir;
                    }
                    blArray[1] = true;
                }
                if (!blArray[2]) break;
                this.cpu.data_regs[0] = -9;
                return false;
            }
            case 255: {
                if (!blArray[0]) {
                    this.cpu.data_regs[0] = 0;
                    return true;
                }
                if (blArray[2] || blArray[3] || byArray.length == 0) {
                    this.cpu.data_regs[0] = -9;
                    return false;
                }
                if ((n5 = winDir.deleteFile(n5)) < 0) {
                    this.cpu.data_regs[0] = n5;
                    return false;
                }
                this.freeClusters(n5);
                this.flush();
                this.cpu.data_regs[0] = 0;
                return true;
            }
        }
        WinFile winFile = winDir.openFile(n5, byArray, n3, this.cpu);
        if (winFile != null) {
            this.fileNumber[n6] = winFile;
            this.cpu.writeMemoryWord(n2 + 30, n6);
            this.cpu.writeMemoryWord(n2 + 94, n6);
            this.cpu.data_regs[0] = 0;
            if (n3 == 4) {
                this.cpu.writeMemoryWord(n2 + 98, n6);
            }
        }
        return true;
    }

    public void setRootDirLength(int n) {
        this.driveFAT.putInt(54, n);
        this.flush();
    }

    private void writeFAT() throws IOException {
        this.writeFile(this.driveFAT, this.fatClusterChain);
        this.driveFAT.limit(this.driveFAT.capacity());
        this.driveFAT.position(0);
    }

    public void flush() {
        try {
            this.writeFAT();
        }
        catch (Exception exception) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[71], null, exception);
        }
    }

    public ByteBuffer readFile(int n, int n2, ArrayList<Integer> arrayList) {
        if (n < 1 || arrayList == null) {
            return null;
        }
        int n3 = n / this.clusterSize;
        if (n % this.clusterSize != 0) {
            ++n3;
        }
        arrayList.clear();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 * this.clusterSize);
        if (this.readFile(n, n2, byteBuffer, arrayList)) {
            return byteBuffer;
        }
        return null;
    }

    private boolean readFile(int n, int n2, ByteBuffer byteBuffer, ArrayList<Integer> arrayList) {
        if (byteBuffer.capacity() < n) {
            return false;
        }
        int n3 = 0;
        try {
            do {
                arrayList.add(n2);
                if (n > this.clusterSize) {
                    byteBuffer.limit(n3 + this.clusterSize);
                } else {
                    byteBuffer.limit(n3 + n);
                }
                byteBuffer.position(n3);
                long l = n2 * this.clusterSize;
                this.ioChannel.position(l);
                int n4 = this.ioChannel.read(byteBuffer);
                if ((n -= n4) <= 0 || n4 != this.clusterSize) {
                    n2 = 0;
                    continue;
                }
                n3 += this.clusterSize;
                n2 = this.driveFAT.getShort(n2 * 2 + 64) & 0xFFFF;
            } while (n2 != 0);
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void writeFile(ByteBuffer byteBuffer, ArrayList<Integer> arrayList) throws IOException {
        if (this.ioChannel == null) {
            return;
        }
        int n = 0;
        int n2 = this.clusterSize;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        for (int n5 : arrayList) {
            byteBuffer.limit(n2);
            byteBuffer.position(n);
            this.ioChannel.position(n5 * this.clusterSize);
            int n6 = this.ioChannel.write(byteBuffer);
            if (n6 != this.clusterSize) break;
            n += n6;
            if ((n2 += n6) <= byteBuffer.capacity()) continue;
            n2 = byteBuffer.capacity();
        }
        byteBuffer.limit(n4);
        byteBuffer.position(n3);
    }

    public void writePartOfFile(ByteBuffer byteBuffer, ArrayList<Integer> arrayList, int n, int n2) throws IOException {
        if (this.ioChannel == null) {
            return;
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        int n5 = n / this.clusterSize;
        int n6 = (n + n2) / this.clusterSize;
        for (int i = n5; i < n6 + 1; ++i) {
            int n7 = arrayList.get(i);
            byteBuffer.limit((i + 1) * this.clusterSize);
            byteBuffer.position(i * this.clusterSize);
            this.ioChannel.position(n7 * this.clusterSize);
            int n8 = this.ioChannel.write(byteBuffer);
            if (n8 != this.clusterSize) break;
        }
        byteBuffer.limit(n4);
        byteBuffer.position(n3);
    }

    public ByteBuffer increaseCapacity(ByteBuffer byteBuffer, int n, ArrayList<Integer> arrayList) {
        int n2 = this.nbrOfClusters(n);
        if (!this.addClusters(n2, arrayList)) {
            return null;
        }
        n2 *= this.clusterSize;
        if (byteBuffer != null) {
            n2 += byteBuffer.capacity();
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
        if (byteBuffer != null && byteBuffer2 != null) {
            int n3 = byteBuffer.position();
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            byteBuffer2.put(byteBuffer);
            byteBuffer2.position(n3);
        }
        return byteBuffer2;
    }

    public ArrayList<Integer> truncateFile(int n, int n2, ArrayList<Integer> arrayList) {
        if (this.nbrOfClusters(n) == this.nbrOfClusters(n2)) {
            return arrayList;
        }
        this.freeClusters(arrayList.get(0));
        return this.allocateClusters(n2);
    }

    public int readBytes(int n, ByteBuffer byteBuffer, long l) {
        if (byteBuffer.capacity() < n) {
            return -1;
        }
        try {
            byteBuffer.limit(n);
            byteBuffer.position(0);
            return this.ioChannel.read(byteBuffer, l);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int writeBytes(int n, ByteBuffer byteBuffer, long l, int n2) {
        if (byteBuffer.capacity() < n + n2) {
            return -1;
        }
        try {
            int n3 = byteBuffer.position();
            int n4 = byteBuffer.limit();
            byteBuffer.limit(n + n2);
            byteBuffer.position(n2);
            int n5 = this.ioChannel.write(byteBuffer, l);
            byteBuffer.limit(n4);
            byteBuffer.position(n3);
            return n5;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private boolean addCluster(ArrayList<Integer> arrayList) {
        int n = arrayList.get(arrayList.size() - 1);
        if (this.driveFAT.getShort(64 + n * 2) != 0) {
            return false;
        }
        short s = this.driveFAT.getShort(44);
        if (s == 0) {
            return false;
        }
        int n2 = this.driveFAT.getShort(50) & 0xFFFF;
        if (n2 == 0) {
            return false;
        }
        short s2 = this.driveFAT.getShort(64 + n2 * 2);
        this.driveFAT.putShort(50, s2);
        this.driveFAT.putShort(64 + n * 2, (short)(n2 & 0xFFFF));
        this.driveFAT.putShort(64 + n2 * 2, (short)0);
        s = (short)(s - 1);
        this.driveFAT.putShort(44, s);
        arrayList.add(n2);
        return true;
    }

    private boolean addClusters(int n, ArrayList<Integer> arrayList) {
        if ((this.driveFAT.getShort(44) & 0xFFFF) < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            this.addCluster(arrayList);
        }
        return true;
    }

    public ArrayList<Integer> allocateClusters(int n) {
        int n2 = this.driveFAT.getShort(44) & 0xFFFF;
        if (n2 < n) {
            return null;
        }
        int n3 = this.driveFAT.getShort(50) & 0xFFFF;
        if (n3 == 0) {
            return null;
        }
        short s = this.driveFAT.getShort(64 + n3 * 2);
        this.driveFAT.putShort(50, s);
        this.driveFAT.putShort(44, (short)(--n2 & 0xFFFF));
        this.driveFAT.putShort(64 + n3 * 2, (short)0);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n3);
        if (--n != 0) {
            this.addClusters(n, arrayList);
        }
        if (arrayList.size() != n + 1) {
            this.freeClusters(arrayList.get(0));
            return null;
        }
        return arrayList;
    }

    public void freeClusters(int n) {
        int n2 = 0;
        do {
            int n3 = n;
            n = this.driveFAT.getShort(n * 2 + 64) & 0xFFFF;
            this.freeOneCluster(n3);
            ++n2;
        } while (n != 0);
        this.driveFAT.putShort(44, (short)(n2 += this.driveFAT.getShort(44) & 0xFFFF));
    }

    private void freeOneCluster(int n) {
        int n2 = this.driveFAT.getShort(50) & 0xFFFF;
        if (n2 == 0) {
            this.driveFAT.putShort(50, (short)(n & 0xFFFF));
            this.driveFAT.putShort(n * 2 + 64, (short)0);
            return;
        }
        if (n2 > n) {
            this.driveFAT.putShort(50, (short)(n & 0xFFFF));
            this.driveFAT.putShort(n * 2 + 64, (short)(n2 & 0xFFFF));
            return;
        }
        int n3 = n2;
        while (n2 < n && n2 != 0) {
            n3 = n2;
            n2 = this.driveFAT.getShort(n2 * 2 + 64) & 0xFFFF;
        }
        this.driveFAT.putShort(n3 * 2 + 64, (short)(n & 0xFFFF));
        this.driveFAT.putShort(n * 2 + 64, (short)(n2 & 0xFFFF));
    }

    private int nbrOfClusters(int n) {
        int n2 = n / this.clusterSize;
        if (n % this.clusterSize != 0) {
            ++n2;
        }
        return n2;
    }

    public int getIntFromFAT(int n) {
        return this.driveFAT.getInt(n);
    }

    public static final byte[] convert2SMSQELowerCase(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            byArray2[i] = LOWER_CASE[n];
        }
        return byArray2;
    }

    public void unuse() {
        try {
            this.ioChannel.force(true);
            this.raFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cpu = null;
        this.driveName = null;
        this.driver = null;
        this.warnings = null;
    }

    public String getDrivename() {
        return this.driveName;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void trap3OK(int n, int n2, int n3) {
        if (this.readOnly) {
            switch (n2) {
                case 5: 
                case 7: 
                case 70: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    this.cpu.data_regs[0] = -20;
                    return;
                }
                case 65: {
                    this.cpu.data_regs[0] = 0;
                    return;
                }
            }
        }
        switch (n2) {
            case 69: {
                int n4 = this.cpu.addr_regs[1];
                this.cpu.writeSmsqeString(n4, "WIN DRIVER", false, -1);
                this.cpu.addr_regs[1] = n4 + 10;
                this.cpu.data_regs[1] = 0x1001000;
                this.cpu.data_regs[0] = 0;
                break;
            }
            case 74: {
                int n5 = this.cpu.addr_regs[1];
                this.cpu.data_regs[0] = -7;
                int n6 = this.cpu.readMemoryLong(n5 + 2);
                if ((n6 & 0xFF) != this.driveNumber) {
                    return;
                }
                if ((n6 &= 0x5F5F5F30) != this.driver.getDeviceID() && n6 != this.driver.getUsage()) {
                    return;
                }
                if (n3 > 1000) {
                    this.cpu.data_regs[0] = -15;
                    return;
                }
                n6 = this.cpu.readMemoryWord(n5) & 0xFFFF;
                if (n6 < 6 || n6 > 40) {
                    return;
                }
                WinFile winFile = this.fileNumber[n3];
                if (winFile == null) {
                    this.cpu.data_regs[0] = -7;
                    return;
                }
                if (winFile.isDir) {
                    this.cpu.data_regs[0] = -20;
                    return;
                }
                byte[] byArray = new byte[n6 -= 5];
                byte[] byArray2 = new byte[n6];
                int n7 = 0;
                for (int i = 0; i < n6; ++i) {
                    n7 = this.cpu.readMemoryByte(n5 + 7 + i) & 0xFF;
                    byArray2[i] = (byte)n7;
                    byArray[i] = LOWER_CASE[n7];
                }
                WinDir winDir = this.mainDir.findInDirs(byArray);
                if (winDir == null) {
                    this.cpu.data_regs[0] = -7;
                    return;
                }
                if (winDir.getName().length + 1 == n6 && n7 == Types.UNDERSCORE) {
                    this.cpu.data_regs[0] = -9;
                    return;
                }
                boolean[] blArray = new boolean[6];
                winDir.checkFile(blArray, byArray);
                if (blArray[0]) {
                    this.cpu.data_regs[0] = -8;
                    return;
                }
                WinDir winDir2 = winFile.getDir();
                this.cpu.data_regs[0] = 0;
                winDir.renameFile(winDir2, winFile, byArray2);
                break;
            }
            case 79: {
                int n8 = this.cpu.addr_regs[1];
                int n9 = 2 + this.driveFAT.getShort(4) & 0xFFFF;
                this.cpu.readFromBuffer(n8, n9, this.driveFAT, 4);
                for (int i = n9; i < 22; ++i) {
                    this.cpu.writeMemoryByte(n8 + i, 0);
                }
                this.cpu.writeSmsqeString(n8 + 22, "WIN", -1);
                this.cpu.writeMemoryWord(n8 + 28, n + 1 << 8);
                this.cpu.writeMemoryWord(n8 + 30, this.clusterSize);
                this.cpu.writeMemoryLong(n8 + 32, this.driveFAT.getShort(42) & 0xFFFF);
                this.cpu.writeMemoryLong(n8 + 36, this.driveFAT.getShort(44) & 0xFFFF);
                this.cpu.writeMemoryLong(n8 + 40, 64);
                this.cpu.writeMemoryWord(n8 + 44, 258);
                this.cpu.writeMemoryWord(n8 + 46, 258);
                this.cpu.writeMemoryLong(n8 + 48, 0xFFFFFF);
                this.cpu.writeMemoryLong(n8 + 52, -1);
                this.cpu.writeMemoryLong(n8 + 56, -1);
                this.cpu.writeMemoryLong(n8 + 60, -1);
                this.cpu.data_regs[0] = 0;
                break;
            }
            default: {
                WinFile winFile = this.fileNumber[n3];
                if (winFile == null) {
                    this.cpu.data_regs[0] = -7;
                    break;
                }
                winFile.handleTrap3(n2, this.cpu);
            }
        }
    }

    public void setCpu(MC68000Cpu mC68000Cpu) {
        this.cpu = mC68000Cpu;
    }

    public boolean closeFile(int n) {
        WinFile winFile = this.fileNumber[n];
        if (winFile == null) {
            this.cpu.data_regs[0] = 0;
            return false;
        }
        winFile.close();
        this.fileNumber[n] = null;
        this.cpu.data_regs[0] = 0;
        return true;
    }

    private boolean makeSpecialAccessFile(int n, int n2) {
        int n3 = this.cpu.readMemoryByte(this.cpu.addr_regs[1] + 34);
        if (n3 != 0) {
            this.cpu.data_regs[0] = -9;
            return false;
        }
        WinSpecialFile winSpecialFile = new WinSpecialFile(this);
        this.fileNumber[n] = winSpecialFile;
        this.cpu.writeMemoryWord(n2 + 30, n);
        this.cpu.writeMemoryWord(n2 + 94, n);
        this.cpu.data_regs[0] = 0;
        this.specialFileIsOpen = true;
        return true;
    }

    public void specialFileClosed() {
        this.specialFileIsOpen = false;
    }

    public int checkSector(int n) {
        int n2;
        int n3 = this.driveFAT.getShort(34) & 0xFFFF;
        int n4 = n / n3;
        if (n4 > (n2 = this.driveFAT.getShort(42) & 0xFFFF)) {
            return n2 * n3 - 1;
        }
        return n;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public void changeParentDir(WinDir winDir, int n, WinDir winDir2, int n2) {
        for (WinFile winFile : this.fileNumber) {
            if (winFile == null || winFile.getDir() != winDir || winFile.getIndex() != n) continue;
            winFile.setDir(winDir2);
            winFile.setIndex(n2);
        }
    }

    public void closeAllFiles() {
        this.fileNumber = new WinFile[1000];
        this.readMainDir();
    }
}

