/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import inifile.IniFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.JOptionPane;
import smsqmulator.DeviceDriver;
import smsqmulator.DoNothingException;
import smsqmulator.Helper;
import smsqmulator.IncorrectFiletypeException;
import smsqmulator.Localization;
import smsqmulator.Types;
import smsqmulator.Warnings;
import smsqmulator.WinDrive;
import smsqmulator.cpu.MC68000Cpu;

public class WinDriver
implements DeviceDriver {
    protected WinDrive[] drives = new WinDrive[8];
    protected int deviceID = 1464421936;
    protected String[] nativeDir = new String[8];
    protected MC68000Cpu cpu;
    protected int usage = this.deviceID;
    public static final int QLWA = 1363957569;
    protected Warnings warnings;
    public static final int HEADER_LENGTH = 64;

    public WinDriver(MC68000Cpu mC68000Cpu, Warnings warnings) {
        this.cpu = mC68000Cpu;
        this.warnings = warnings;
    }

    @Override
    public boolean openFile(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        if (this.drives[n4] == null) {
            this.cpu.data_regs[0] = -7;
            return false;
        }
        return this.drives[n4].openFile(n, n2, n3, n4, byArray, byArray2);
    }

    @Override
    public boolean closeFile(int n, int n2) {
        if (this.drives[n] == null) {
            return false;
        }
        this.drives[n].closeFile(n2);
        return true;
    }

    @Override
    public boolean trap3OK(int n, int n2, int n3, int n4) {
        if (this.drives[n] == null) {
            return false;
        }
        this.drives[n].trap3OK(n, n2, n4);
        return true;
    }

    @Override
    public boolean deleteFile(int n, byte[] byArray, File file) {
        return false;
    }

    @Override
    public boolean formatMedium(String string, IniFile iniFile) {
        block28: {
            int n;
            this.cpu.data_regs[0] = -15;
            if (string.charAt(4) != Types.UNDERSCORE) {
                return true;
            }
            int n2 = (this.cpu.data_regs[1] & 0xFFFF) - 1;
            int n3 = string.indexOf(Types.UNDERSCORE, 5);
            if (n3 == -1) {
                n3 = string.length();
            }
            try {
                n = Integer.parseInt(string.substring(5, n3));
            }
            catch (Exception exception) {
                return true;
            }
            if (n2 < 0 || n2 > 7) {
                return true;
            }
            if (this.nativeDir[n2] == null || this.nativeDir[n2].isEmpty() || n > 2000 || n < 1) {
                return true;
            }
            File file = new File(this.nativeDir[n2]);
            if (file.exists()) {
                this.cpu.data_regs[0] = -8;
                return true;
            }
            n *= 2048;
            RandomAccessFile randomAccessFile = null;
            try {
                int n4;
                int n5;
                randomAccessFile = new RandomAccessFile(this.nativeDir[n2], "rw");
                FileChannel fileChannel = randomAccessFile.getChannel();
                ByteBuffer byteBuffer = ByteBuffer.allocate(512);
                boolean bl = false;
                n3 = 0;
                for (n5 = 4; n5 < 65; n5 *= 2) {
                    n3 = n / n5;
                    if (n3 >= 65536) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new IOException();
                }
                n = n3 * n5;
                byteBuffer.putShort(42, (short)n3);
                int n6 = n3;
                byteBuffer.putShort(34, (short)n5);
                int n7 = n3 / (n5 * 256);
                if (n7 * n5 * 256 - 32 < n3) {
                    ++n7;
                }
                for (n5 = 0; n5 < 224; ++n5) {
                    byteBuffer.putShort(64 + n5 * 2, (short)(n5 + 1));
                }
                byteBuffer.putShort(44, (short)(n3 - n7 - 1));
                byteBuffer.putInt(64 + (n7 - 1) * 2, 0);
                byteBuffer.putShort(52, (short)n7);
                byteBuffer.putInt(54, 64);
                byteBuffer.putShort(50, (short)(n7 + 1));
                n3 >>>= 8;
                byteBuffer.putShort(46, (short)(++n3));
                byteBuffer.putInt(0, 1363957569);
                n3 = string.indexOf(Types.UNDERSCORE, 5);
                if (n3 == -1) {
                    byteBuffer.putShort(4, (short)4);
                    n3 = this.usage + n2 + 1;
                    byteBuffer.putInt(6, n3);
                    n3 = 4;
                } else {
                    n4 = this.cpu.addr_regs[1] + ++n3 + 2;
                    n3 = string.length() - n3;
                    if (n3 > 20) {
                        n3 = 20;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    for (n5 = 0; n5 < n3; ++n5) {
                        byteBuffer.put(6 + n5, (byte)(this.cpu.readMemoryByte(n4++) & 0xFF));
                    }
                    byteBuffer.putShort(4, (short)n3);
                }
                n4 = 32;
                for (n5 = 6 + n3; n5 < 26; ++n5) {
                    byteBuffer.put(n5, (byte)n4);
                }
                n3 = (int)(System.currentTimeMillis() / 1000L);
                byteBuffer.putInt(28, n3);
                byteBuffer.putShort(48, (short)1);
                fileChannel.write(byteBuffer);
                byteBuffer.position(0);
                n3 = 224;
                n7 = n7 * (byteBuffer.getShort(34) & 0xFFFF) - 1;
                for (n5 = 1; n5 < n7; ++n5) {
                    for (int i = 0; i < 512; i += 2) {
                        if (++n3 >= n6) {
                            byteBuffer.putShort(i, (short)0);
                            continue;
                        }
                        byteBuffer.putShort(i, (short)(n3 & 0xFFFF));
                    }
                    fileChannel.position(n5 * 512);
                    fileChannel.write(byteBuffer);
                    byteBuffer.position(0);
                }
                byteBuffer = ByteBuffer.allocate(512);
                fileChannel.position((n - 1) * 512);
                fileChannel.write(byteBuffer);
                randomAccessFile.close();
                this.drives[n2] = new WinDrive(this.cpu, this.nativeDir[n2], this, n2 + 49, this.warnings, iniFile);
                this.cpu.data_regs[2] = n;
                this.cpu.data_regs[1] = n;
                this.cpu.data_regs[0] = 0;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                JOptionPane.showMessageDialog(null, Localization.Texts[74] + file.getAbsolutePath() + Localization.Texts[91] + "\n" + Localization.Texts[92], Localization.Texts[30], 0);
            }
            catch (Exception exception) {
                if (randomAccessFile == null) break block28;
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    @Override
    public boolean setNames(String[] stringArray, IniFile iniFile, boolean bl, boolean bl2) {
        if (stringArray.length == 8) {
            int n;
            if (iniFile.getTrueOrFalse("DISABLE-WIN-DEVICE")) {
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < 8; ++n) {
                if (this.nativeDir[n] == null || this.nativeDir[n].isEmpty()) continue;
                if (bl || stringArray[n] == null || stringArray[n].isEmpty()) {
                    if (this.drives[n] == null) continue;
                    this.drives[n].unuse();
                    this.drives[n] = null;
                    continue;
                }
                if (this.nativeDir[n].toLowerCase().equals(stringArray[n].toLowerCase()) || this.drives[n] == null) continue;
                this.drives[n].unuse();
                this.drives[n] = null;
            }
            this.nativeDir = (String[])stringArray.clone();
            for (n = 0; n < 8; ++n) {
                try {
                    if (this.nativeDir[n] == null || this.nativeDir[n].isEmpty()) continue;
                    if (this.drives[n] != null) {
                        if (!this.nativeDir[n].equals(this.drives[n].getDrivename())) {
                            this.drives[n].unuse();
                            this.drives[n] = new WinDrive(this.cpu, this.nativeDir[n], this, n + 49, this.warnings, iniFile);
                        }
                    } else {
                        this.drives[n] = new WinDrive(this.cpu, this.nativeDir[n], this, n + 49, this.warnings, iniFile);
                    }
                    if (!this.drives[n].isReadOnly() || !this.warnings.warnIfQXLDriveIsReadOnly) continue;
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(Localization.Texts[105]).append("\n");
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.warnings.warnIfNonexistingQXLDrive) {
                        stringBuilder.append(this.nativeDir[n]).append("\n");
                        stringBuilder.append(Localization.Texts[64]).append("\n");
                    }
                    this.drives[n] = null;
                    continue;
                }
                catch (ProtocolException protocolException) {
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(protocolException.getMessage()).append("\n");
                    this.drives[n] = null;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(Localization.Texts[65]).append("\n");
                    this.drives[n] = null;
                    continue;
                }
                catch (DoNothingException doNothingException) {
                    this.drives[n] = null;
                    continue;
                }
                catch (IncorrectFiletypeException incorrectFiletypeException) {
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(Localization.Texts[111]).append("\n");
                    this.drives[n] = null;
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    stringBuilder.append(this.nativeDir[n]).append("\n");
                    stringBuilder.append(Localization.Texts[126]).append("\n");
                    continue;
                }
                catch (Exception exception) {
                    stringBuilder.append(this.nativeDir[n]);
                    if (exception.getLocalizedMessage() != null) {
                        stringBuilder.append(exception.getLocalizedMessage()).append("\n");
                    } else {
                        stringBuilder.append(exception.toString()).append("\n");
                    }
                    this.drives[n] = null;
                }
            }
            if (stringBuilder.length() != 0 && !bl2) {
                StringBuilder stringBuilder2 = new StringBuilder();
                Helper.reportError(Localization.Texts[45], Localization.Texts[49] + "\n" + stringBuilder.toString(), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return (String[])this.nativeDir.clone();
    }

    @Override
    public String getName(int n) {
        if (this.nativeDir[--n] != null && !this.nativeDir[n].isEmpty()) {
            return this.nativeDir[n];
        }
        return "";
    }

    @Override
    public void setUsage(int n) {
        this.usage = n;
    }

    @Override
    public int getUsage() {
        return this.usage;
    }

    @Override
    public int getDeviceID() {
        return this.deviceID;
    }

    @Override
    public void setCpu(MC68000Cpu mC68000Cpu) {
        this.cpu = mC68000Cpu;
        for (WinDrive winDrive : this.drives) {
            if (winDrive == null) continue;
            winDrive.setCpu(mC68000Cpu);
        }
    }

    @Override
    public void setFilenameChange(int n) {
    }

    @Override
    public void closeAllFiles() {
        for (int i = 0; i < 8; ++i) {
            if (this.drives[i] == null) continue;
            this.drives[i].closeAllFiles();
        }
    }

    @Override
    public void writeBack(int n) {
        this.cpu.data_regs[0] = -19;
    }
}

