/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import smsqmulator.Monitor;
import smsqmulator.WinDir;
import smsqmulator.WinDrive;
import smsqmulator.cpu.MC68000Cpu;

public class WinFile {
    protected int filePosition = 64;
    protected int fileSize;
    protected ByteBuffer buffer;
    protected int index;
    protected WinDir dir;
    protected WinDrive drive;
    protected boolean readOnly;
    protected boolean isDir = false;
    protected ArrayList<Integer> clusterchain;
    protected boolean fileChanged = false;
    protected boolean dirChanged = false;
    protected boolean mapChanged = false;
    protected boolean setDate = true;

    public WinFile(WinDrive winDrive, WinDir winDir, int n, boolean bl, ByteBuffer byteBuffer, ArrayList<Integer> arrayList) {
        this.drive = winDrive;
        this.readOnly = bl;
        this.index = n;
        this.dir = winDir;
        this.buffer = byteBuffer;
        this.buffer.position(this.filePosition);
        this.clusterchain = arrayList;
        this.fileSize = this.dir != null ? this.dir.getFileLength(this.index) : this.drive.getIntFromFAT(54);
        if (!bl) {
            this.readOnly = this.dir == null ? true : this.dir.fileIsDir(this.index);
        }
        if (this.index == 0) {
            this.isDir = true;
            this.readOnly = true;
        }
    }

    public WinFile() {
        this.drive = null;
    }

    public void close() {
        if (!this.readOnly && this.fileChanged) {
            this.writeFile(0, 0);
        }
        if (this.dir != null) {
            this.dir.closeFile(this.index, this.dirChanged, this.setDate);
        }
        if (this.mapChanged) {
            this.drive.flush();
        }
        this.buffer = null;
    }

    public void handleTrap3(int n, MC68000Cpu mC68000Cpu) {
        block1 : switch (n) {
            case 0: {
                if (this.fileSize > this.filePosition) {
                    mC68000Cpu.data_regs[0] = 0;
                    break;
                }
                mC68000Cpu.data_regs[0] = -10;
                break;
            }
            case 1: {
                if (this.filePosition >= this.fileSize) {
                    mC68000Cpu.data_regs[0] = -10;
                    break;
                }
                mC68000Cpu.data_regs[1] = (mC68000Cpu.data_regs[1] & 0xFFFFFF00) + (this.buffer.get() & 0xFF);
                ++this.filePosition;
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 2: {
                this.getLine(mC68000Cpu);
                break;
            }
            case 3: {
                this.readBytes(mC68000Cpu, mC68000Cpu.data_regs[2] & 0xFFFF);
                break;
            }
            case 5: {
                if (this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.sendByte(mC68000Cpu);
                break;
            }
            case 6: 
            case 7: {
                if (this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.sendMultipleBytes(mC68000Cpu, mC68000Cpu.data_regs[2] & 0xFFFF);
                break;
            }
            case 64: {
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 65: {
                mC68000Cpu.data_regs[0] = 0;
                if (!this.fileChanged) break;
                try {
                    this.drive.writeFile(this.buffer, this.clusterchain);
                }
                catch (Exception exception) {
                    mC68000Cpu.data_regs[0] = -6;
                }
                this.fileChanged = false;
                if (this.dirChanged) {
                    this.dir.writeFile(0, 0);
                }
                if (!this.mapChanged) break;
                this.drive.flush();
                this.mapChanged = false;
                break;
            }
            case 66: {
                this.filePosition = 64;
            }
            case 67: {
                this.filePosition += mC68000Cpu.data_regs[1];
                mC68000Cpu.data_regs[0] = 0;
                if (this.filePosition > this.fileSize) {
                    this.filePosition = this.fileSize;
                    mC68000Cpu.data_regs[0] = -10;
                }
                if (this.filePosition < 64) {
                    this.filePosition = 64;
                }
                mC68000Cpu.data_regs[1] = this.filePosition - 64;
                this.buffer.position(this.filePosition);
                break;
            }
            case 70: {
                if (this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.dir.setFileHeader(this.index, mC68000Cpu, this.fileSize);
                this.dirChanged = true;
                break;
            }
            case 71: {
                int n2 = mC68000Cpu.addr_regs[1];
                int n3 = mC68000Cpu.data_regs[2] & 0xFFFF;
                if (n3 > 64) {
                    n3 = 64;
                }
                if (this.index != 0) {
                    if (n3 > 4) {
                        mC68000Cpu.readFromBuffer(n2 + 4, n3 - 4, this.dir.getDirBuffer(), this.index + 4);
                    }
                    mC68000Cpu.writeMemoryLong(n2, this.fileSize - 64);
                } else {
                    for (int i = n2; i < n2 + n3; i += 2) {
                        mC68000Cpu.writeMemoryWord(i, 0);
                    }
                    mC68000Cpu.writeMemoryLong(n2, this.drive.getIntFromFAT(54) - 64);
                    mC68000Cpu.writeMemoryWord(n2 + 4, 255);
                }
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + n3;
                mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] & 0xFFFF0000 | n3;
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 72: {
                this.filePosition = 64;
                this.buffer.position(this.filePosition);
                this.readBytes(mC68000Cpu, this.fileSize - 64);
                this.filePosition = this.buffer.position();
                break;
            }
            case 73: {
                if (this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.sendMultipleBytes(mC68000Cpu, mC68000Cpu.data_regs[2]);
                break;
            }
            case 75: {
                if (this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.clusterchain = this.drive.truncateFile(this.fileSize, this.filePosition, this.clusterchain);
                this.fileSize = this.filePosition;
                this.dir.setInHeader(this.index, this.fileSize);
                this.dirChanged = true;
                this.mapChanged = true;
                this.fileChanged = true;
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 76: {
                mC68000Cpu.data_regs[0] = 0;
                if (this.dir == null || this.dir.fileIsDir(this.index)) {
                    return;
                }
                int n4 = (mC68000Cpu.data_regs[2] & 0xFF) * 4 + 52 + this.index;
                switch (mC68000Cpu.data_regs[1]) {
                    case -1: {
                        mC68000Cpu.data_regs[1] = this.dir.getFileDate(n4);
                        break block1;
                    }
                    case 0: {
                        mC68000Cpu.data_regs[1] = (int)(System.currentTimeMillis() / 1000L + (long)Monitor.TIME_OFFSET);
                    }
                }
                if (this.readOnly && n4 != 60) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.dir.setFileDate(n4, mC68000Cpu.data_regs[1]);
                this.dirChanged = true;
                this.setDate = false;
                break;
            }
            case 77: {
                this.makeDirectory(mC68000Cpu);
                break;
            }
            case 78: {
                mC68000Cpu.data_regs[0] = 0;
                if (this.dir == null || this.dir.fileIsDir(this.index)) {
                    return;
                }
                if (mC68000Cpu.data_regs[1] == -1 || mC68000Cpu.data_regs[1] == 0) {
                    mC68000Cpu.data_regs[1] = this.dir.getFileVersion(this.index);
                    break;
                }
                if (mC68000Cpu.data_regs[1] <= 0) break;
                if (this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.dir.setFileVersion(this.index, mC68000Cpu.data_regs[1]);
                this.dirChanged = true;
                break;
            }
            default: {
                mC68000Cpu.data_regs[0] = -19;
            }
        }
    }

    private void readBytes(MC68000Cpu mC68000Cpu, int n) {
        int n2;
        int n3 = n;
        if (n3 == 0) {
            mC68000Cpu.data_regs[1] = 0;
            mC68000Cpu.data_regs[0] = 0;
            return;
        }
        if (this.filePosition >= this.fileSize & n3 != 0) {
            mC68000Cpu.data_regs[0] = -10;
            return;
        }
        if (this.filePosition + n3 > this.fileSize) {
            n3 = this.fileSize - this.filePosition;
        }
        if ((n2 = mC68000Cpu.readFromBuffer(mC68000Cpu.addr_regs[1], n3, this.buffer, this.filePosition)) == -1) {
            mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] & 0xFFFF0000;
            mC68000Cpu.data_regs[0] = -10;
            return;
        }
        this.filePosition += n2;
        this.buffer.position(this.filePosition);
        mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + n2;
        mC68000Cpu.data_regs[1] = n2;
        mC68000Cpu.data_regs[0] = n2 == n ? 0 : -10;
    }

    private void getLine(MC68000Cpu mC68000Cpu) {
        if (this.filePosition >= this.fileSize) {
            mC68000Cpu.data_regs[0] = -10;
            return;
        }
        this.buffer.position(this.filePosition);
        int n = mC68000Cpu.addr_regs[1];
        int n2 = mC68000Cpu.data_regs[2] & 0xFFFF;
        if (this.filePosition + n2 >= this.fileSize) {
            n2 = this.fileSize - this.filePosition;
        }
        boolean bl = false;
        int n3 = n;
        while (n < n3 + n2) {
            byte by = this.buffer.get();
            mC68000Cpu.writeMemoryByte(n, by);
            if (by == 10) {
                ++n;
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            mC68000Cpu.data_regs[0] = n2 < mC68000Cpu.data_regs[2] ? -10 : -5;
        } else {
            n2 = n - n3;
            if (n2 <= 0) {
                mC68000Cpu.data_regs[0] = -10;
                return;
            }
            if (n2 > 1 && this.buffer.get(this.buffer.position() - 2) == 13) {
                mC68000Cpu.writeMemoryByte(n - 2, 10);
            }
            mC68000Cpu.data_regs[0] = 0;
        }
        mC68000Cpu.addr_regs[1] = --n;
        mC68000Cpu.data_regs[1] = --n2;
        this.filePosition = this.buffer.position();
    }

    private void sendByte(MC68000Cpu mC68000Cpu) {
        if (this.filePosition >= this.buffer.capacity()) {
            this.buffer.position(0);
            this.buffer.limit(this.fileSize);
            ByteBuffer byteBuffer = this.drive.increaseCapacity(this.buffer, 1, this.clusterchain);
            if (byteBuffer == null) {
                mC68000Cpu.data_regs[0] = -11;
                return;
            }
            this.buffer = byteBuffer;
            this.mapChanged = true;
        }
        this.buffer.position(this.filePosition);
        this.buffer.put((byte)(mC68000Cpu.data_regs[1] & 0xFF));
        ++this.filePosition;
        if (this.filePosition > this.fileSize) {
            ++this.fileSize;
            this.dir.setInHeader(this.index, this.fileSize);
            this.dirChanged = true;
        }
        this.fileChanged = true;
        mC68000Cpu.data_regs[0] = 0;
    }

    private void sendMultipleBytes(MC68000Cpu mC68000Cpu, int n) {
        if (n == 0) {
            mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] & 0xFFFF0000;
            mC68000Cpu.data_regs[0] = 0;
            return;
        }
        int n2 = this.buffer.capacity() - this.filePosition;
        if (n2 < n) {
            this.buffer.position(0);
            this.buffer.limit(this.fileSize);
            ByteBuffer byteBuffer = this.drive.increaseCapacity(this.buffer, n - n2, this.clusterchain);
            if (byteBuffer == null) {
                mC68000Cpu.data_regs[0] = -11;
                return;
            }
            this.buffer = null;
            this.buffer = byteBuffer;
            this.mapChanged = true;
        }
        this.buffer.position(this.filePosition);
        n = mC68000Cpu.writeToBuffer(this.buffer, mC68000Cpu.addr_regs[1], n);
        if (n == -1) {
            mC68000Cpu.data_regs[0] = -11;
            return;
        }
        this.filePosition += n;
        if (this.filePosition > this.fileSize) {
            this.fileSize = this.filePosition;
        }
        this.buffer.position(this.filePosition);
        mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + n;
        mC68000Cpu.data_regs[1] = n;
        mC68000Cpu.data_regs[0] = 0;
        this.dir.setInHeader(this.index, this.fileSize);
        this.dirChanged = true;
        this.fileChanged = true;
    }

    private void makeDirectory(MC68000Cpu mC68000Cpu) {
        mC68000Cpu.data_regs[0] = -20;
        if (this.fileSize != 64 || this.dir == null || this.dir.fileIsDir(this.index) || this.clusterchain.size() != 1) {
            mC68000Cpu.data_regs[0] = -15;
            return;
        }
        if (this.dir.makeDirectory(this.index, this.clusterchain, this.buffer)) {
            this.filePosition = this.fileSize = this.dir.getFileLength(this.index);
            this.readOnly = true;
            mC68000Cpu.data_regs[0] = 0;
            this.setDate = false;
        }
    }

    public void writeFile(int n, int n2) {
        try {
            if (n == 0 && n2 == 0) {
                this.drive.writeFile(this.buffer, this.clusterchain);
            } else {
                this.drive.writePartOfFile(this.buffer, this.clusterchain, n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDirStatus(boolean bl) {
        this.isDir = bl;
    }

    public WinDir getDir() {
        return this.dir;
    }

    public void setDir(WinDir winDir) {
        this.dir = winDir;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setDirAndFatChanged() {
        this.dirChanged = true;
        this.mapChanged = true;
    }
}

