/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.ADD2Dn;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class ADD_An
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 1; i < 5; ++i) {
            Instruction instruction;
            int n;
            if (i == 1) {
                n = 53320;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        boolean bl2;
                        int n2 = n >> 9 & 7;
                        int n3 = mC68000Cpu.addr_regs[n & 7] & 0xFFFF;
                        if ((n3 & 0x8000) != 0) {
                            n3 |= 0xFFFF0000;
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        int n4 = mC68000Cpu.data_regs[n2] & 0xFFFF;
                        if ((n4 & 0x8000) != 0) {
                            n4 |= 0xFFFF0000;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        n4 += n3;
                        boolean bl3 = ((n4 &= 0xFFFF) & 0x8000) != 0;
                        int n5 = n2;
                        mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] & 0xFFFF0000;
                        int n6 = n2;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | n4;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (n4 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if (bl3) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                        if (bl2 && bl && !bl3 || !bl2 && !bl && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && bl || !bl3 && bl || bl2 && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADD_An.this.disassembleOp(n, n2, Size.Word, "d", mC68000Cpu);
                    }
                };
            } else if (i == 2) {
                n = 53384;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n >> 9 & 7;
                        int n3 = mC68000Cpu.addr_regs[n & 7];
                        boolean bl = n3 < 0;
                        boolean bl2 = mC68000Cpu.data_regs[n2] < 0;
                        int n4 = n2;
                        mC68000Cpu.data_regs[n4] = mC68000Cpu.data_regs[n4] + n3;
                        boolean bl3 = mC68000Cpu.data_regs[n2] < 0;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (mC68000Cpu.data_regs[n2] == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl3) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (bl && bl2 && !bl3 || !bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && bl2 || !bl3 && bl2 || bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADD_An.this.disassembleOp(n, n2, Size.Long, "d", mC68000Cpu);
                    }
                };
            } else if (i == 3) {
                n = 53448;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.addr_regs[n & 7] & 0xFFFF;
                        if ((n2 & 0x8000) != 0) {
                            n2 |= 0xFFFF0000;
                        }
                        int n3 = n >> 9 & 7;
                        mC68000Cpu.addr_regs[n3] = mC68000Cpu.addr_regs[n3] + n2;
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADD_An.this.disassembleOp(n, n2, Size.Word, "a", mC68000Cpu);
                    }
                };
            } else {
                n = 53704;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n >> 9 & 7;
                        mC68000Cpu.addr_regs[n2] = mC68000Cpu.addr_regs[n2] + mC68000Cpu.addr_regs[n & 7];
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADD_An.this.disassembleOp(n, n2, Size.Long, "a", mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (j << 9) + k, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, String string, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        DisassembledOperand disassembledOperand2 = new DisassembledOperand(string + (n2 >> 9 & 7));
        if (string.equals("a")) {
            return new DisassembledInstruction(n, n2, "adda" + size.ext(), disassembledOperand, disassembledOperand2);
        }
        return new DisassembledInstruction(n, n2, "add" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

