/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class ADDXmem
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 53512;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n >> 9 & 7;
                        int n3 = n & 7;
                        if (n3 == 7) {
                            int n4 = n3;
                            mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] - 2;
                        } else {
                            int n5 = n3;
                            mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] - 1;
                        }
                        if (n2 == 7) {
                            int n6 = n2;
                            mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] - 2;
                        } else {
                            int n7 = n2;
                            mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] - 1;
                        }
                        int n8 = mC68000Cpu.readMemoryByteSigned(mC68000Cpu.addr_regs[n3]);
                        int n9 = mC68000Cpu.readMemoryByteSigned(mC68000Cpu.addr_regs[n2]);
                        boolean bl = n8 < 0;
                        boolean bl2 = n9 < 0;
                        n9 += n8;
                        if ((mC68000Cpu.reg_sr & 0x10) != 0) {
                            ++n9;
                        }
                        boolean bl3 = (n9 & 0x80) != 0;
                        mC68000Cpu.writeMemoryByte(mC68000Cpu.addr_regs[n2], n9);
                        mC68000Cpu.reg_sr &= 0xFFE4;
                        if (n9 != 0) {
                            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                            if (bl3) {
                                mC68000Cpu.reg_sr += 8;
                            }
                        }
                        if (bl && bl2 && !bl3 || !bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && bl2 || !bl3 && bl2 || bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADDXmem.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 53576;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = n >> 9 & 7;
                        int n4 = n2 = n & 7;
                        mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] - 2;
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] - 2;
                        int n6 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n2]);
                        int n7 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n3]);
                        boolean bl = n6 < 0;
                        boolean bl2 = n7 < 0;
                        n7 += n6;
                        if ((mC68000Cpu.reg_sr & 0x10) != 0) {
                            ++n7;
                        }
                        boolean bl3 = (n7 & 0x8000) != 0;
                        mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[n3], n7);
                        mC68000Cpu.reg_sr &= 0xFFE4;
                        if (n7 != 0) {
                            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                            if (bl3) {
                                mC68000Cpu.reg_sr += 8;
                            }
                        }
                        if (bl && bl2 && !bl3 || !bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && bl2 || !bl3 && bl2 || bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADDXmem.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 53640;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = n >> 9 & 7;
                        int n4 = n2 = n & 7;
                        mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] - 4;
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] - 4;
                        int n6 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n2]);
                        int n7 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n3]);
                        boolean bl = n6 < 0;
                        boolean bl2 = n7 < 0;
                        n7 += n6;
                        if ((mC68000Cpu.reg_sr & 0x10) != 0) {
                            ++n7;
                        }
                        boolean bl3 = n7 < 0;
                        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[n3], n7);
                        mC68000Cpu.reg_sr &= 0xFFE4;
                        if (n7 != 0) {
                            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                            if (bl3) {
                                mC68000Cpu.reg_sr += 8;
                            }
                        }
                        if (bl && bl2 && !bl3 || !bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && bl2 || !bl3 && bl2 || bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADDXmem.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                int n2 = j << 9;
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + n2 + k, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = new DisassembledOperand("-(a" + (n2 & 7) + ")");
        DisassembledOperand disassembledOperand2 = new DisassembledOperand("-(a" + (n2 >> 9 & 7) + ")");
        return new DisassembledInstruction(n, n2, "addx" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

