/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class ADDXreg
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 53504;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        boolean bl2;
                        int n2 = n >> 9 & 7;
                        int n3 = mC68000Cpu.data_regs[n & 7] & 0xFF;
                        int n4 = mC68000Cpu.data_regs[n2] & 0xFF;
                        if ((n3 & 0x80) != 0) {
                            n3 |= 0xFFFFFF00;
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        if ((n4 & 0x80) != 0) {
                            n4 |= 0xFFFFFF00;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        n4 += n3;
                        if ((mC68000Cpu.reg_sr & 0x10) != 0) {
                            ++n4;
                        }
                        boolean bl3 = ((n4 &= 0xFF) & 0x80) != 0;
                        int n5 = n2;
                        mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] & 0xFFFFFF00;
                        int n6 = n2;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | n4;
                        mC68000Cpu.reg_sr &= 0xFFE4;
                        if (n4 != 0) {
                            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                            if (bl3) {
                                mC68000Cpu.reg_sr += 8;
                            }
                        }
                        if (bl2 && bl && !bl3 || !bl2 && !bl && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && bl || !bl3 && bl || bl2 && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADDXreg.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 53568;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        boolean bl2;
                        int n2 = n >> 9 & 7;
                        int n3 = mC68000Cpu.data_regs[n & 7] & 0xFFFF;
                        int n4 = mC68000Cpu.data_regs[n2] & 0xFFFF;
                        if ((n3 & 0x8000) != 0) {
                            n3 |= 0xFFFF0000;
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        if ((n4 & 0x8000) != 0) {
                            n4 |= 0xFFFF0000;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        n4 += n3;
                        if ((mC68000Cpu.reg_sr & 0x10) != 0) {
                            ++n4;
                        }
                        boolean bl3 = ((n4 &= 0xFFFF) & 0x8000) != 0;
                        int n5 = n2;
                        mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] & 0xFFFF0000;
                        int n6 = n2;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | n4;
                        mC68000Cpu.reg_sr &= 0xFFE4;
                        if (n4 != 0) {
                            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                            if (bl3) {
                                mC68000Cpu.reg_sr += 8;
                            }
                        }
                        if (bl2 && bl && !bl3 || !bl2 && !bl && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && bl || !bl3 && bl || bl2 && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADDXreg.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 53632;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n >> 9 & 7;
                        int n3 = mC68000Cpu.data_regs[n & 7];
                        int n4 = mC68000Cpu.data_regs[n2];
                        boolean bl = n3 < 0;
                        boolean bl2 = n4 < 0;
                        n4 += n3;
                        if ((mC68000Cpu.reg_sr & 0x10) != 0) {
                            ++n4;
                        }
                        boolean bl3 = n4 < 0;
                        mC68000Cpu.data_regs[n2] = n4;
                        mC68000Cpu.reg_sr &= 0xFFE4;
                        if (n4 != 0) {
                            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                            if (bl3) {
                                mC68000Cpu.reg_sr += 8;
                            }
                        }
                        if (bl && bl2 && !bl3 || !bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && bl2 || !bl3 && bl2 || bl && !bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ADDXreg.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                int n2 = j << 9;
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + n2 + k, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = new DisassembledOperand("d" + (n2 & 7));
        DisassembledOperand disassembledOperand2 = new DisassembledOperand("d" + (n2 >> 9 & 7));
        return new DisassembledInstruction(n, n2, "addx" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

