/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.CMP;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class CMPM
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 45320;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n >> 9 & 7;
                        int n3 = n & 7;
                        int n4 = mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[n3]);
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 1;
                        int n6 = mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[n2]);
                        int n7 = n2;
                        mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 1;
                        boolean bl2 = (n4 & 0x80) != 0;
                        boolean bl3 = (n6 & 0x80) != 0;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl4 = bl = ((n6 -= n4) & 0x80) != 0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMPM.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 45384;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n >> 9 & 7;
                        int n3 = n & 7;
                        int n4 = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[n3]);
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 2;
                        int n6 = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[n2]);
                        int n7 = n2;
                        mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 2;
                        boolean bl2 = (n4 & 0x8000) != 0;
                        boolean bl3 = (n6 & 0x8000) != 0;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl4 = bl = ((n6 -= n4) & 0x8000) != 0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMPM.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 45448;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n >> 9 & 7;
                        int n3 = n & 7;
                        int n4 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n3]);
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 4;
                        int n6 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n2]);
                        int n7 = n2;
                        mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 4;
                        int n8 = n6 - n4;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl2 = n4 < 0;
                        boolean bl3 = n6 < 0;
                        boolean bl4 = bl = n8 < 0;
                        if (n8 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMPM.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (j << 9) + k, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = new DisassembledOperand("(a" + (n2 & 7) + ")+");
        DisassembledOperand disassembledOperand2 = new DisassembledOperand("(a" + (n2 >> 9 & 7) + ")+");
        return new DisassembledInstruction(n, n2, "cmpm" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

