/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.CMP;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class CMP_AnPlus
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 5; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 45080;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n & 7;
                        int n3 = mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[n2]);
                        if (n2 == 7) {
                            int n4 = n2;
                            mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] + 2;
                        } else {
                            int n5 = n2;
                            mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 1;
                        }
                        int n6 = mC68000Cpu.data_regs[n >>> 9 & 7] & 0xFF;
                        boolean bl2 = (n3 & 0x80) != 0;
                        boolean bl3 = (n6 & 0x80) != 0;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl4 = bl = ((n6 -= n3) & 0x80) != 0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMP_AnPlus.this.disassembleOp(n, n2, Size.Byte, "d", mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 45144;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n & 7;
                        int n3 = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[n2]);
                        int n4 = n2;
                        mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] + 2;
                        int n5 = mC68000Cpu.data_regs[n >>> 9 & 7] & 0xFFFF;
                        boolean bl2 = (n3 & 0x8000) != 0;
                        boolean bl3 = (n5 & 0x8000) != 0;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl4 = bl = ((n5 -= n3) & 0x8000) != 0;
                        if (n5 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMP_AnPlus.this.disassembleOp(n, n2, Size.Word, "d", mC68000Cpu);
                    }
                };
            } else if (i == 2) {
                n = 45208;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n & 7;
                        int n3 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n2]);
                        int n4 = n2;
                        mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] + 4;
                        int n5 = mC68000Cpu.data_regs[n >>> 9 & 7];
                        int n6 = n5 - n3;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl2 = n3 < 0;
                        boolean bl3 = n5 < 0;
                        boolean bl4 = bl = n6 < 0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMP_AnPlus.this.disassembleOp(n, n2, Size.Long, "d", mC68000Cpu);
                    }
                };
            } else if (i == 3) {
                n = 45272;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n & 7;
                        int n3 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n2]);
                        int n4 = n2;
                        mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] + 2;
                        int n5 = mC68000Cpu.addr_regs[n >>> 9 & 7];
                        int n6 = n5 - n3;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl2 = n3 < 0;
                        boolean bl3 = n5 < 0;
                        boolean bl4 = bl = n6 < 0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMP_AnPlus.this.disassembleOp(n, n2, Size.Word, "a", mC68000Cpu);
                    }
                };
            } else {
                n = 45528;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n & 7;
                        int n3 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n2]);
                        int n4 = n2;
                        mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] + 4;
                        int n5 = mC68000Cpu.addr_regs[n >>> 9 & 7];
                        int n6 = n5 - n3;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl2 = n3 < 0;
                        boolean bl3 = n5 < 0;
                        boolean bl4 = bl = n6 < 0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMP_AnPlus.this.disassembleOp(n, n2, Size.Long, "a", mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (k << 9) + j, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, String string, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        DisassembledOperand disassembledOperand2 = new DisassembledOperand(string + (n2 >> 9 & 7));
        if (string.equals("a")) {
            return new DisassembledInstruction(n, n2, "cmpa" + size.ext(), disassembledOperand, disassembledOperand2);
        }
        return new DisassembledInstruction(n, n2, "cmp" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

