/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class DBcc
implements InstructionSet {
    protected static final String[] names = new String[]{"dbt", "dbra", "dbhi", "dbls", "dbcc", "dbcs", "dbne", "dbeq", "dbvc", "dbvs", "dbpl", "dbmi", "dbge", "dblt", "dbgt", "dble"};

    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 20680;
        Instruction instruction = new Instruction(){
            private static final int C_FLAG = 1;
            private static final int V_FLAG = 2;
            private static final int Z_FLAG = 4;
            private static final int N_FLAG = 8;
            private static final int C_Z_FLAGS = 5;
            private static final int N_V_FLAGS = 10;

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = n & 7;
                int n3 = mC68000Cpu.data_regs[n2] & 0xFFFF;
                if (!this.testCC(n >> 8 & 0xF, mC68000Cpu.reg_sr)) {
                    int n4 = n2;
                    mC68000Cpu.data_regs[n4] = mC68000Cpu.data_regs[n4] & 0xFFFF0000;
                    if (--n3 != -1) {
                        int n5 = n2;
                        mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] | n3;
                        mC68000Cpu.pc_reg += mC68000Cpu.readMemoryWordPCSignedInc() / 2;
                    } else {
                        int n6 = n2;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | 0xFFFF;
                        ++mC68000Cpu.pc_reg;
                    }
                } else {
                    ++mC68000Cpu.pc_reg;
                }
            }

            private boolean testCC(int n, int n2) {
                switch (n) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return (n2 & 5) == 0;
                    }
                    case 3: {
                        return (n2 & 5) != 0;
                    }
                    case 4: {
                        return (n2 & 1) == 0;
                    }
                    case 5: {
                        return (n2 & 1) != 0;
                    }
                    case 6: {
                        return (n2 & 4) == 0;
                    }
                    case 7: {
                        return (n2 & 4) != 0;
                    }
                    case 8: {
                        return (n2 & 2) == 0;
                    }
                    case 9: {
                        return (n2 & 2) != 0;
                    }
                    case 10: {
                        return (n2 & 8) == 0;
                    }
                    case 11: {
                        return (n2 & 8) != 0;
                    }
                    case 12: {
                        int n3 = n2 & 0xA;
                        return n3 == 0 || n3 == 10;
                    }
                    case 13: {
                        int n4 = n2 & 0xA;
                        return n4 == 8 || n4 == 2;
                    }
                    case 14: {
                        int n5 = n2 & 0xE;
                        return n5 == 0 || n5 == 10;
                    }
                    case 15: {
                        int n6 = n2 & 0xE;
                        return (n6 & 4) != 0 || n6 == 8 || n6 == 2;
                    }
                }
                throw new IllegalArgumentException("Invalid Condition Code value!");
            }

            @Override
            public final DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                int n3 = n2 >> 8 & 0xF;
                int n4 = mC68000Cpu.readMemoryWordSigned(n + 2);
                DisassembledOperand disassembledOperand = new DisassembledOperand(String.format("d%d", n2 & 7));
                DisassembledOperand disassembledOperand2 = new DisassembledOperand(String.format("$%08x", n4 + n + 2), 2, n4);
                return new DisassembledInstruction(n, n2, names[n3], disassembledOperand, disassembledOperand2);
            }
        };
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                mC68000Cpu.addInstruction(n + (i << 8) + j, instruction);
            }
        }
    }
}

