/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.MOVE;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class MOVEAnL8
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 5113;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        n2 = mC68000Cpu.readMemoryByte(n2);
                        int n3 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        mC68000Cpu.writeMemoryByte(n3, n2);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if ((n2 & 0x80) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnL8.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 13305;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        short s = mC68000Cpu.readMemoryShort(mC68000Cpu.readMemoryLongPC());
                        mC68000Cpu.pc_reg += 2;
                        int n2 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        mC68000Cpu.writeMemoryShort(n2, s);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (s == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (s < 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnL8.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 9209;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        n2 = mC68000Cpu.readMemoryLong(n2);
                        int n3 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        mC68000Cpu.writeMemoryLong(n3, n2);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (n2 < 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnL8.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            mC68000Cpu.addInstruction(n, instruction);
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2 + disassembledOperand.bytes, n2 >> 6 & 7, n2 >> 9 & 7, size);
        return new DisassembledInstruction(n, n2, "move" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

