/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.MOVE;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class MOVEAnP6
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 4504;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = n & 7;
                        int n4 = mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[n3]) & 0xFF;
                        if (n3 == 7) {
                            int n5 = n3;
                            mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 2;
                        } else {
                            int n6 = n3;
                            mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 1;
                        }
                        int n7 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n8 = n2 = (n7 & 0x80) != 0 ? n7 | 0xFFFFFF00 : n7 & 0xFF;
                        n2 = (n7 & 0x8000) != 0 ? ((n7 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n7 >> 12 & 7])) : (n2 += mC68000Cpu.addr_regs[n7 >> 12 & 7])) : ((n7 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n7 >> 12 & 7])) : (n2 += mC68000Cpu.data_regs[n7 >> 12 & 7]));
                        mC68000Cpu.writeMemoryByte(mC68000Cpu.addr_regs[n >> 9 & 7] + n2, n4);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n4 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if ((n4 & 0x80) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnP6.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 12696;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = n & 7;
                        short s = mC68000Cpu.readMemoryShort(mC68000Cpu.addr_regs[n3]);
                        int n4 = n3;
                        mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] + 2;
                        int n5 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n6 = n2 = (n5 & 0x80) != 0 ? n5 | 0xFFFFFF00 : n5 & 0xFF;
                        n2 = (n5 & 0x8000) != 0 ? ((n5 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n5 >> 12 & 7])) : (n2 += mC68000Cpu.addr_regs[n5 >> 12 & 7])) : ((n5 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n5 >> 12 & 7])) : (n2 += mC68000Cpu.data_regs[n5 >> 12 & 7]));
                        mC68000Cpu.writeMemoryShort(mC68000Cpu.addr_regs[n >> 9 & 7] + n2, s);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (s == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (s < 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnP6.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 8600;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = n & 7;
                        int n4 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n3]);
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 4;
                        int n6 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n7 = n2 = (n6 & 0x80) != 0 ? n6 | 0xFFFFFF00 : n6 & 0xFF;
                        n2 = (n6 & 0x8000) != 0 ? ((n6 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n6 >> 12 & 7])) : (n2 += mC68000Cpu.addr_regs[n6 >> 12 & 7])) : ((n6 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n6 >> 12 & 7])) : (n2 += mC68000Cpu.data_regs[n6 >> 12 & 7]));
                        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[n >> 9 & 7] + n2, n4);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n4 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (n4 < 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnP6.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (k << 9) + j, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2 + disassembledOperand.bytes, n2 >> 6 & 7, n2 >> 9 & 7, size);
        return new DisassembledInstruction(n, n2, "move" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

