/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.MOVEM;

import smsqmulator.Helper;
import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class MOVEM2Mem8
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 2; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 18592;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = mC68000Cpu.addr_regs[n & 7];
                        int n4 = mC68000Cpu.readMemoryWordPCInc();
                        int n5 = 1;
                        int n6 = n3;
                        for (n2 = 0; n2 < 8; ++n2) {
                            if ((n4 & n5) != 0) {
                                n3 -= 2;
                                if ((n & 7) == 7 - n2) {
                                    mC68000Cpu.writeMemoryWord(n3, n6);
                                } else {
                                    mC68000Cpu.writeMemoryWord(n3, mC68000Cpu.addr_regs[7 - n2]);
                                }
                            }
                            n5 <<= 1;
                        }
                        for (n2 = 0; n2 < 8; ++n2) {
                            if ((n4 & n5) != 0) {
                                mC68000Cpu.writeMemoryWord(n3 -= 2, mC68000Cpu.data_regs[7 - n2]);
                            }
                            n5 <<= 1;
                        }
                        mC68000Cpu.addr_regs[n & 7] = n3;
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEM2Mem8.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 18656;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = mC68000Cpu.addr_regs[n & 7];
                        int n4 = mC68000Cpu.readMemoryWordPCInc();
                        int n5 = 1;
                        int n6 = n3;
                        for (n2 = 0; n2 < 8; ++n2) {
                            if ((n4 & n5) != 0) {
                                n3 -= 4;
                                if ((n & 7) == 7 - n2) {
                                    mC68000Cpu.writeMemoryLong(n3, n6);
                                } else {
                                    mC68000Cpu.writeMemoryLong(n3, mC68000Cpu.addr_regs[7 - n2]);
                                }
                            }
                            n5 <<= 1;
                        }
                        for (n2 = 0; n2 < 8; ++n2) {
                            if ((n4 & n5) != 0) {
                                mC68000Cpu.writeMemoryLong(n3 -= 4, mC68000Cpu.data_regs[7 - n2]);
                            }
                            n5 <<= 1;
                        }
                        mC68000Cpu.addr_regs[n & 7] = n3;
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEM2Mem8.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                mC68000Cpu.addInstruction(n + j, instruction);
            }
        }
    }

    public final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        int n3 = n2 >> 3 & 7;
        int n4 = n2 & 7;
        int n5 = mC68000Cpu.readMemoryWord(n + 2);
        boolean bl = n3 == 4;
        DisassembledOperand disassembledOperand = new DisassembledOperand(Helper.regListToString(n5, bl), 2, n5);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 4, n3, n4, size);
        return new DisassembledInstruction(n, n2, "movem" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

