/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class NOT
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 17920;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n3 = mC68000Cpu.data_regs[n & 7] & 0xFF;
                                n3 ^= 0xFFFFFFFF;
                                int n4 = n & 7;
                                mC68000Cpu.data_regs[n4] = mC68000Cpu.data_regs[n4] & 0xFFFFFF00;
                                int n5 = n & 7;
                                mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] | (n3 &= 0xFF);
                                mC68000Cpu.reg_sr &= 0xFFF0;
                                if (n3 == 0) {
                                    mC68000Cpu.reg_sr |= 4;
                                } else if ((n3 & 0x80) != 0) {
                                    mC68000Cpu.reg_sr |= 8;
                                }
                                return;
                            }
                            case 2: {
                                n2 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                int n6 = n & 7;
                                n2 = mC68000Cpu.addr_regs[n6];
                                if (n6 == 7) {
                                    int n7 = n6;
                                    mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 2;
                                    break;
                                }
                                int n8 = n6;
                                mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] + 1;
                                break;
                            }
                            case 4: {
                                int n9 = n & 7;
                                if (n9 == 7) {
                                    int n10 = n9;
                                    mC68000Cpu.addr_regs[n10] = mC68000Cpu.addr_regs[n10] - 2;
                                } else {
                                    int n11 = n9;
                                    mC68000Cpu.addr_regs[n11] = mC68000Cpu.addr_regs[n11] - 1;
                                }
                                n2 = mC68000Cpu.addr_regs[n9];
                                break;
                            }
                            case 5: {
                                n2 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n2 = NOT.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n2 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n12 = mC68000Cpu.readMemoryByte(n2);
                        n12 ^= 0xFFFFFFFF;
                        mC68000Cpu.writeMemoryByte(n2, n12 &= 0xFF);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n12 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if ((n12 & 0x80) != 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return NOT.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 17984;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n3 = mC68000Cpu.data_regs[n & 7] & 0xFFFF;
                                n3 ^= 0xFFFFFFFF;
                                int n4 = n & 7;
                                mC68000Cpu.data_regs[n4] = mC68000Cpu.data_regs[n4] & 0xFFFF0000;
                                int n5 = n & 7;
                                mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] | (n3 &= 0xFFFF);
                                mC68000Cpu.reg_sr &= 0xFFF0;
                                if (n3 == 0) {
                                    mC68000Cpu.reg_sr |= 4;
                                } else if ((n3 & 0x8000) != 0) {
                                    mC68000Cpu.reg_sr |= 8;
                                }
                                return;
                            }
                            case 2: {
                                n2 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                n2 = mC68000Cpu.addr_regs[n & 7];
                                int n6 = n & 7;
                                mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 2;
                                break;
                            }
                            case 4: {
                                int n7 = n & 7;
                                mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] - 2;
                                n2 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 5: {
                                n2 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n2 = NOT.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n2 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n8 = mC68000Cpu.readMemoryWord(n2);
                        n8 ^= 0xFFFFFFFF;
                        mC68000Cpu.writeMemoryWord(n2, n8 &= 0xFFFF);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n8 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if ((n8 & 0x8000) != 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return NOT.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 18048;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n3 = mC68000Cpu.data_regs[n & 7];
                                mC68000Cpu.data_regs[n & 7] = n3 ^= 0xFFFFFFFF;
                                mC68000Cpu.reg_sr &= 0xFFF0;
                                if (n3 == 0) {
                                    mC68000Cpu.reg_sr |= 4;
                                } else if (n3 < 0) {
                                    mC68000Cpu.reg_sr |= 8;
                                }
                                return;
                            }
                            case 2: {
                                n2 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                n2 = mC68000Cpu.addr_regs[n & 7];
                                int n4 = n & 7;
                                mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] + 4;
                                break;
                            }
                            case 4: {
                                int n5 = n & 7;
                                mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] - 4;
                                n2 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 5: {
                                n2 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n2 = NOT.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n2 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n6 = mC68000Cpu.readMemoryLong(n2);
                        mC68000Cpu.writeMemoryLong(n2, n6 ^= 0xFFFFFFFF);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if (n6 < 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return NOT.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                if (j == 1) continue;
                int n2 = j << 3;
                for (int k = 0; k < 8 && !(j == 7 & k > 1); ++k) {
                    mC68000Cpu.addInstruction(n + n2 + k, instruction);
                }
            }
        }
    }

    protected int getDisplacement(MC68000Cpu mC68000Cpu) {
        int n;
        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
        n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
        return n;
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "not" + size.ext(), disassembledOperand);
    }
}

