/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class ORreg
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 32768;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = n >> 9 & 7;
                        boolean bl = true;
                        int n5 = mC68000Cpu.data_regs[n4] & 0xFF;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                n2 = mC68000Cpu.data_regs[n & 7] & 0xFF;
                                bl = false;
                                break;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                int n6 = n & 7;
                                n3 = mC68000Cpu.addr_regs[n6];
                                if (n6 == 7) {
                                    int n7 = n6;
                                    mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 2;
                                    break;
                                }
                                int n8 = n6;
                                mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] + 1;
                                break;
                            }
                            case 4: {
                                int n9 = n & 7;
                                if (n9 == 7) {
                                    int n10 = n9;
                                    mC68000Cpu.addr_regs[n10] = mC68000Cpu.addr_regs[n10] - 2;
                                } else {
                                    int n11 = n9;
                                    mC68000Cpu.addr_regs[n11] = mC68000Cpu.addr_regs[n11] - 1;
                                }
                                n3 = mC68000Cpu.addr_regs[n9];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = ORreg.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                        break block0;
                                    }
                                    case 2: {
                                        n3 = mC68000Cpu.pc_reg * 2 + mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 3: {
                                        n3 = mC68000Cpu.pc_reg * 2 + ORreg.this.getDisplacement(mC68000Cpu);
                                        break block0;
                                    }
                                    case 4: {
                                        n2 = mC68000Cpu.readMemoryWordPCInc() & 0xFF;
                                        bl = false;
                                    }
                                }
                            }
                        }
                        if (bl) {
                            n2 = mC68000Cpu.readMemoryByte(n3);
                        }
                        int n12 = n4;
                        mC68000Cpu.data_regs[n12] = mC68000Cpu.data_regs[n12] & 0xFFFFFF00;
                        int n13 = n4;
                        mC68000Cpu.data_regs[n13] = mC68000Cpu.data_regs[n13] | (n2 |= n5);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if ((n2 & 0x80) != 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Byte);
                        DisassembledOperand disassembledOperand2 = new DisassembledOperand("d" + (n2 >> 9 & 7));
                        return new DisassembledInstruction(n, n2, "or" + Size.Byte.ext(), disassembledOperand, disassembledOperand2);
                    }
                };
            } else if (i == 1) {
                n = 32832;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = n >> 9 & 7;
                        boolean bl = true;
                        int n5 = mC68000Cpu.data_regs[n4] & 0xFFFF;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                n2 = mC68000Cpu.data_regs[n & 7] & 0xFFFF;
                                bl = false;
                                break;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                int n6 = n & 7;
                                mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 2;
                                break;
                            }
                            case 4: {
                                int n7 = n & 7;
                                mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] - 2;
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = ORreg.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                        break block0;
                                    }
                                    case 2: {
                                        n3 = mC68000Cpu.pc_reg * 2 + mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 3: {
                                        n3 = mC68000Cpu.pc_reg * 2 + ORreg.this.getDisplacement(mC68000Cpu);
                                        break block0;
                                    }
                                    case 4: {
                                        n2 = mC68000Cpu.readMemoryWordPCInc();
                                        bl = false;
                                    }
                                }
                            }
                        }
                        if (bl) {
                            n2 = mC68000Cpu.readMemoryWord(n3);
                        }
                        int n8 = n4;
                        mC68000Cpu.data_regs[n8] = mC68000Cpu.data_regs[n8] & 0xFFFF0000;
                        int n9 = n4;
                        mC68000Cpu.data_regs[n9] = mC68000Cpu.data_regs[n9] | (n2 |= n5);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if ((n2 & 0x8000) != 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Word);
                        DisassembledOperand disassembledOperand2 = new DisassembledOperand("d" + (n2 >> 9 & 7));
                        return new DisassembledInstruction(n, n2, "or" + Size.Word.ext(), disassembledOperand, disassembledOperand2);
                    }
                };
            } else {
                n = 32896;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = n >> 9 & 7;
                        boolean bl = true;
                        int n5 = mC68000Cpu.data_regs[n4];
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                n2 = mC68000Cpu.data_regs[n & 7];
                                bl = false;
                                break;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                int n6 = n & 7;
                                mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 4;
                                break;
                            }
                            case 4: {
                                int n7 = n & 7;
                                mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] - 4;
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = ORreg.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                        break block0;
                                    }
                                    case 2: {
                                        n3 = mC68000Cpu.pc_reg * 2 + mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 3: {
                                        n3 = mC68000Cpu.pc_reg * 2 + ORreg.this.getDisplacement(mC68000Cpu);
                                        break block0;
                                    }
                                    case 4: {
                                        n2 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                        bl = false;
                                    }
                                }
                            }
                        }
                        if (bl) {
                            n2 = mC68000Cpu.readMemoryLong(n3);
                        }
                        mC68000Cpu.data_regs[n4] = n2 |= n5;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n2 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if (n2 < 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Long);
                        DisassembledOperand disassembledOperand2 = new DisassembledOperand("d" + (n2 >> 9 & 7));
                        return new DisassembledInstruction(n, n2, "or" + Size.Long.ext(), disassembledOperand, disassembledOperand2);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                int n2 = j << 9;
                for (int k = 0; k < 8; ++k) {
                    if (k == 1) continue;
                    int n3 = k << 3;
                    for (int i2 = 0; i2 < 8 && !(k == 7 & i2 > 4); ++i2) {
                        mC68000Cpu.addInstruction(n + n2 + n3 + i2, instruction);
                    }
                }
            }
        }
    }

    protected int getDisplacement(MC68000Cpu mC68000Cpu) {
        int n;
        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
        n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
        return n;
    }
}

