/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class SCC
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 20672;
        Instruction instruction = new Instruction(){
            private static final int C_FLAG = 1;
            private static final int V_FLAG = 2;
            private static final int Z_FLAG = 4;
            private static final int N_FLAG = 8;
            private static final int C_Z_FLAGS = 5;
            private static final int N_V_FLAGS = 10;
            private final String[] names = new String[]{"st", "sf", "shi", "sls", "scc", "scs", "sne", "seq", "svc", "svs", "spl", "smi", "sge", "slt", "sgt", "sle"};

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = 0;
                block0 : switch (n >> 3 & 7) {
                    case 0: {
                        if (this.testCC(n >> 8 & 0xF, mC68000Cpu.reg_sr)) {
                            int n3 = n & 7;
                            mC68000Cpu.data_regs[n3] = mC68000Cpu.data_regs[n3] | 0xFF;
                        } else {
                            int n4 = n & 7;
                            mC68000Cpu.data_regs[n4] = mC68000Cpu.data_regs[n4] & 0xFFFFFF00;
                        }
                        return;
                    }
                    case 2: {
                        n2 = mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 3: {
                        int n5 = n & 7;
                        n2 = mC68000Cpu.addr_regs[n5];
                        if (n5 == 7) {
                            int n6 = n5;
                            mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 2;
                            break;
                        }
                        int n7 = n5;
                        mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 1;
                        break;
                    }
                    case 4: {
                        int n8 = n & 7;
                        if (n8 == 7) {
                            int n9 = n8;
                            mC68000Cpu.addr_regs[n9] = mC68000Cpu.addr_regs[n9] - 2;
                        } else {
                            int n10 = n8;
                            mC68000Cpu.addr_regs[n10] = mC68000Cpu.addr_regs[n10] - 1;
                        }
                        n2 = mC68000Cpu.addr_regs[n8];
                        break;
                    }
                    case 5: {
                        n2 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                        break;
                    }
                    case 6: {
                        n2 = this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 7: {
                        switch (n & 7) {
                            case 0: {
                                n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                                break block0;
                            }
                            case 1: {
                                n2 = mC68000Cpu.readMemoryLongPC();
                                mC68000Cpu.pc_reg += 2;
                            }
                        }
                    }
                }
                if (this.testCC(n >> 8 & 0xF, mC68000Cpu.reg_sr)) {
                    mC68000Cpu.writeMemoryByte(n2, 255);
                } else {
                    mC68000Cpu.writeMemoryByte(n2, 0);
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Byte);
                return new DisassembledInstruction(n, n2, this.names[n2 >> 8 & 0xF], disassembledOperand);
            }

            private boolean testCC(int n, int n2) {
                switch (n) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return (n2 & 5) == 0;
                    }
                    case 3: {
                        return (n2 & 5) != 0;
                    }
                    case 4: {
                        return (n2 & 1) == 0;
                    }
                    case 5: {
                        return (n2 & 1) != 0;
                    }
                    case 6: {
                        return (n2 & 4) == 0;
                    }
                    case 7: {
                        return (n2 & 4) != 0;
                    }
                    case 8: {
                        return (n2 & 2) == 0;
                    }
                    case 9: {
                        return (n2 & 2) != 0;
                    }
                    case 10: {
                        return (n2 & 8) == 0;
                    }
                    case 11: {
                        return (n2 & 8) != 0;
                    }
                    case 12: {
                        int n3 = n2 & 0xA;
                        return n3 == 0 || n3 == 10;
                    }
                    case 13: {
                        int n4 = n2 & 0xA;
                        return n4 == 8 || n4 == 2;
                    }
                    case 14: {
                        int n5 = n2 & 0xE;
                        return n5 == 0 || n5 == 10;
                    }
                    case 15: {
                        int n6 = n2 & 0xE;
                        return (n6 & 4) != 0 || n6 == 8 || n6 == 2;
                    }
                }
                throw new IllegalArgumentException("Invalid Condition Code value!");
            }

            protected int getDisplacement(MC68000Cpu mC68000Cpu) {
                int n;
                int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                return n;
            }
        };
        for (int i = 0; i < 16; ++i) {
            int n2 = i << 8;
            for (int j = 0; j < 8; ++j) {
                if (j == 1) continue;
                int n3 = j << 3;
                for (int k = 0; k < 8 && !(j == 7 & k > 1); ++k) {
                    mC68000Cpu.addInstruction(n + n2 + n3 + k, instruction);
                }
            }
        }
    }
}

