/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.SUB2Dn;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class SUB_d16An
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 8; ++i) {
            Instruction instruction;
            int n;
            if (i == 4 || i == 5 || i == 6) continue;
            if (i == 0) {
                n = 36904;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n >> 9 & 7;
                        int n3 = mC68000Cpu.readMemoryByteSigned(mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc());
                        boolean bl2 = n3 < 0;
                        int n4 = mC68000Cpu.data_regs[n2] & 0xFF;
                        if ((n4 & 0x80) != 0) {
                            n4 |= 0xFFFFFF00;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        boolean bl3 = ((n4 -= n3) & 0x80) != 0;
                        int n5 = n2;
                        mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] & 0xFFFFFF00;
                        int n6 = n2;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | (n4 &= 0xFF);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (n4 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl3) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl && !bl3 || bl2 && !bl && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl || bl3 && !bl || bl2 && bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUB_d16An.this.disassembleOp(n, n2, Size.Byte, "d", mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 36968;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = n >> 9 & 7;
                        int n3 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc());
                        boolean bl2 = n3 < 0;
                        int n4 = mC68000Cpu.data_regs[n2] & 0xFFFF;
                        if ((n4 & 0x8000) != 0) {
                            n4 |= 0xFFFF0000;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        boolean bl3 = ((n4 -= n3) & 0x8000) != 0;
                        int n5 = n2;
                        mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] & 0xFFFF0000;
                        int n6 = n2;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | (n4 &= 0xFFFF);
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (n4 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl3) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl && !bl3 || bl2 && !bl && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl || bl3 && !bl || bl2 && bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUB_d16An.this.disassembleOp(n, n2, Size.Word, "d", mC68000Cpu);
                    }
                };
            } else if (i == 2) {
                n = 37032;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n >> 9 & 7;
                        int n3 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc());
                        boolean bl = n3 < 0;
                        boolean bl2 = mC68000Cpu.data_regs[n2] < 0;
                        int n4 = n2;
                        mC68000Cpu.data_regs[n4] = mC68000Cpu.data_regs[n4] - n3;
                        boolean bl3 = mC68000Cpu.data_regs[n2] < 0;
                        mC68000Cpu.reg_sr &= 0xFFE0;
                        if (mC68000Cpu.data_regs[n2] == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl3) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl && bl2 && !bl3 || bl && !bl2 && bl3) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl && !bl2 || bl3 && !bl2 || bl && bl3) {
                            mC68000Cpu.reg_sr += 17;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUB_d16An.this.disassembleOp(n, n2, Size.Long, "d", mC68000Cpu);
                    }
                };
            } else if (i == 3) {
                n = 37096;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n >> 9 & 7;
                        mC68000Cpu.addr_regs[n2] = mC68000Cpu.addr_regs[n2] - mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc());
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUB_d16An.this.disassembleOp(n, n2, Size.Word, "a", mC68000Cpu);
                    }
                };
            } else {
                n = 37352;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n >> 9 & 7;
                        mC68000Cpu.addr_regs[n2] = mC68000Cpu.addr_regs[n2] - mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc());
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return SUB_d16An.this.disassembleOp(n, n2, Size.Long, "a", mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (j << 9) + k, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, String string, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        DisassembledOperand disassembledOperand2 = new DisassembledOperand(string + (n2 >> 9 & 7));
        if (string.equals("a")) {
            return new DisassembledInstruction(n, n2, "SUBa" + size.ext(), disassembledOperand, disassembledOperand2);
        }
        return new DisassembledInstruction(n, n2, "SUB" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

