/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import smsqmulator.cpu.MC68000Cpu;

public class Arith {
    private static final int exponentOne = 0x3FF00000;
    private int oldPC;
    private int whatOp;
    private static final double QL_2PI = 6.2831853069365025;
    private static final double QL_PI = 3.1415926534682512;

    public final void handleOp(MC68000Cpu mC68000Cpu, int n) {
        this.oldPC = mC68000Cpu.pc_reg;
        mC68000Cpu.data_regs[0] = 0;
        mC68000Cpu.reg_sr |= 4;
        mC68000Cpu.pc_reg = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[7]) / 2;
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] + 4;
        this.whatOp = n;
        switch (n) {
            case 0: {
                double d = Arith.qlFloat2Double(mC68000Cpu.data_regs[2] & 0xFFFF, mC68000Cpu.data_regs[1]);
                this.double2QlFloat(d + Arith.qlFloat2Double(mC68000Cpu), mC68000Cpu);
                break;
            }
            case 1: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + 6;
                this.double2QlFloat(d + Arith.qlFloat2Double(mC68000Cpu), mC68000Cpu);
                break;
            }
            case 2: {
                double d = Arith.qlFloat2Double(mC68000Cpu.data_regs[2] & 0xFFFF, mC68000Cpu.data_regs[1]);
                this.double2QlFloat(Arith.qlFloat2Double(mC68000Cpu) - d, mC68000Cpu);
                break;
            }
            case 3: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + 6;
                this.double2QlFloat(Arith.qlFloat2Double(mC68000Cpu) - d, mC68000Cpu);
                break;
            }
            case 4: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                this.double2QlFloat(d + d, mC68000Cpu);
                break;
            }
            case 5: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                this.double2QlFloat(d / 2.0, mC68000Cpu);
                break;
            }
            case 6: {
                double d = Arith.qlFloat2Double(mC68000Cpu.data_regs[2] & 0xFFFF, mC68000Cpu.data_regs[1]);
                if (d == 0.0) {
                    mC68000Cpu.data_regs[0] = -18;
                    mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                    break;
                }
                this.double2QlFloat(Arith.qlFloat2Double(mC68000Cpu) / d, mC68000Cpu);
                break;
            }
            case 7: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                if (d == 0.0) {
                    mC68000Cpu.data_regs[0] = -18;
                    mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                    break;
                }
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + 6;
                this.double2QlFloat(Arith.qlFloat2Double(mC68000Cpu) / d, mC68000Cpu);
                break;
            }
            case 8: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                if (d == 0.0) {
                    mC68000Cpu.data_regs[0] = -18;
                    mC68000Cpu.reg_sr &= 0xFFFFFFFB;
                    break;
                }
                this.double2QlFloat(1.0 / d, mC68000Cpu);
                break;
            }
            case 9: {
                double d = Arith.qlFloat2Double(mC68000Cpu.data_regs[2] & 0xFFFF, mC68000Cpu.data_regs[1]);
                this.double2QlFloat(Arith.qlFloat2Double(mC68000Cpu) * d, mC68000Cpu);
                break;
            }
            case 10: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + 6;
                this.double2QlFloat(Arith.qlFloat2Double(mC68000Cpu) * d, mC68000Cpu);
                break;
            }
            case 11: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                this.double2QlFloat(d * d, mC68000Cpu);
                break;
            }
            case 12: {
                this.double2QlFloat(Math.sqrt(Arith.qlFloat2Double(mC68000Cpu)), mC68000Cpu);
                break;
            }
            case 13: {
                this.double2QlFloat(Math.cos(Arith.qlFloat2Double(mC68000Cpu)), mC68000Cpu);
                break;
            }
            case 14: {
                double d = Arith.qlFloat2Double(mC68000Cpu);
                d = d == 3.1415926534682512 || d == 6.2831853069365025 ? 0.0 : Math.sin(d);
                this.double2QlFloat(d, mC68000Cpu);
                break;
            }
            case 15: {
                this.double2QlFloat(1.0 / Math.tan(Arith.qlFloat2Double(mC68000Cpu)), mC68000Cpu);
                break;
            }
            case 16: {
                this.double2QlFloat(Math.tan(Arith.qlFloat2Double(mC68000Cpu)), mC68000Cpu);
                break;
            }
            default: {
                mC68000Cpu.data_regs[0] = -19;
                mC68000Cpu.reg_sr &= 0xFFFFFFFB;
            }
        }
    }

    private static double qlFloat2Double(MC68000Cpu mC68000Cpu) {
        int n = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[1]);
        int n2 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 2);
        if (n == 123 && n2 == -2035810304) {
            return 360.0;
        }
        return Arith.qlFloat2Double(n, n2);
    }

    private static double qlFloat2Double(int n, int n2) {
        boolean bl;
        if (n2 == 0) {
            return 0.0;
        }
        boolean bl2 = bl = n2 < 0;
        if (bl) {
            n2 = -n2;
            ++n;
        } else {
            n2 <<= 1;
        }
        if (n < 1027 || n > 3070) {
            return Double.NaN;
        }
        n -= 2048;
        long l = n2 & 0xFFFF;
        n2 >>>= 12;
        long l2 = n2 |= 0x3FF00000;
        l2 <<= 32;
        double d = Double.longBitsToDouble(l2 |= (l <<= 20)) - 1.0;
        return bl ? -d * Math.pow(2.0, n) : d * Math.pow(2.0, n);
    }

    private void double2QlFloat(double d, MC68000Cpu mC68000Cpu) {
        int n;
        int n2;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            this.errorReturnAfterResult(mC68000Cpu);
            return;
        }
        long l = Double.doubleToLongBits(d);
        if (d != 0.0) {
            n2 = (int)l;
            n = (int)(l >>>= 32);
            boolean bl = n < 0;
            n += n;
            if ((n >>>= 1) == 0) {
                this.errorReturnAfterResult(mC68000Cpu);
                return;
            }
            int n3 = n;
            n >>>= 20;
            n += 1026;
            n3 &= 0xFFFFF;
            n3 |= 0x100000;
            boolean bl2 = (n2 & 0x380000) != 0;
            n2 >>>= 22;
            if (bl2 && (n2 |= (n3 <<= 10)) != Integer.MAX_VALUE) {
                ++n2;
            }
            if (bl) {
                if (n2 != 0 && (n2 & n2 - 1) == 0) {
                    n2 <<= 1;
                    n2 |= Integer.MIN_VALUE;
                    --n;
                }
                n2 = 0 - n2;
            }
        } else {
            n = 0;
            n2 = 0;
        }
        mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[1], n);
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[1] + 2, n2);
    }

    private void errorReturnAfterResult(MC68000Cpu mC68000Cpu) {
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        switch (this.whatOp) {
            case 0: 
            case 2: {
                this.resetCpu3Regs(mC68000Cpu, 0);
                break;
            }
            case 1: {
                this.resetCpu3Regs(mC68000Cpu, 6);
                break;
            }
            case 3: {
                mC68000Cpu.pc_reg = this.oldPC;
                int n = this.oldPC * 2 + mC68000Cpu.readMemoryWordPCSignedInc();
                mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
                mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.pc_reg * 2);
                mC68000Cpu.pc_reg = (n & 0xFFFFFFF) / 2;
                break;
            }
            case 4: {
                mC68000Cpu.data_regs[0] = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[1]) & 0xFFFF;
                mC68000Cpu.pc_reg = this.oldPC;
                break;
            }
            case 5: {
                boolean bl;
                int n = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[1]);
                int n2 = n - 1;
                mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[1], n2);
                mC68000Cpu.reg_sr &= 0xFFE0;
                boolean bl2 = false;
                boolean bl3 = (n & 0x8000) != 0;
                boolean bl4 = bl = (n2 & 0x8000) != 0;
                if (n2 == 0) {
                    mC68000Cpu.reg_sr += 4;
                } else if (bl) {
                    mC68000Cpu.reg_sr += 8;
                }
                if (!bl2 && bl3 && !bl) {
                    mC68000Cpu.reg_sr += 2;
                }
                if (bl && !bl3) {
                    mC68000Cpu.reg_sr += 17;
                }
                mC68000Cpu.pc_reg = this.oldPC;
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                this.resetCpu5Regs(mC68000Cpu, 0);
                break;
            }
            case 7: 
            case 10: {
                this.resetCpu5Regs(mC68000Cpu, 6);
                break;
            }
            case 8: {
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] - 2;
                mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[1], 1);
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] - 4;
                mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[1], 134299648);
                mC68000Cpu.pc_reg = this.oldPC + 1;
                break;
            }
            case 12: {
                mC68000Cpu.pc_reg = this.oldPC + 1;
                mC68000Cpu.reg_sr &= 0xFFE0;
                mC68000Cpu.data_regs[0] = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 2);
                if (mC68000Cpu.data_regs[0] == 0) {
                    mC68000Cpu.reg_sr += 4;
                    break;
                }
                if (mC68000Cpu.data_regs[0] >= 0) break;
                mC68000Cpu.reg_sr += 8;
                break;
            }
            case 13: 
            case 14: {
                this.resetCpu4Regs(mC68000Cpu);
                break;
            }
            case 15: 
            case 16: {
                int n = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 2);
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] - 4;
                mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[1], n);
                n = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[1] + 4);
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] - 2;
                mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[1], n);
                mC68000Cpu.pc_reg = this.oldPC + 1;
            }
        }
    }

    private void resetCpu5Regs(MC68000Cpu mC68000Cpu, int n) {
        mC68000Cpu.pc_reg = this.oldPC + 1;
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[7]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[4]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[3]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[2]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[1]);
        mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] - n;
        mC68000Cpu.data_regs[0] = 0;
    }

    private void resetCpu3Regs(MC68000Cpu mC68000Cpu, int n) {
        mC68000Cpu.pc_reg = this.oldPC + 1;
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[3]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[2]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[1]);
        mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] - n;
        mC68000Cpu.data_regs[0] = 0;
    }

    private void resetCpu4Regs(MC68000Cpu mC68000Cpu) {
        mC68000Cpu.pc_reg = this.oldPC + 1;
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.addr_regs[2]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[3]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[2]);
        mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.data_regs[1]);
        mC68000Cpu.data_regs[0] = 0;
    }
}

