/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import smsqmulator.ClipboardMonitorThread;
import smsqmulator.cpu.MC68000Cpu;

public class ClipboardXfer
implements ClipboardOwner {
    private static final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private int changeCounter;
    private String content = null;
    private ClipboardMonitorThread clipboardMonitorThread = null;

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setClipboardContents(String string) {
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
    }

    public final String getClipboardContents() {
        String string = "";
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return string;
        }
        boolean bl = transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (bl) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferClipboardContentsToScrap(MC68000Cpu mC68000Cpu) {
        if (this.isMonitoring()) {
            String string = this.content;
            synchronized (string) {
                if (!this.content.isEmpty()) {
                    mC68000Cpu.writeSmsqeString(mC68000Cpu.addr_regs[1], this.content, 32000);
                }
            }
        } else {
            String string = this.getClipboardContents();
            if (!string.isEmpty()) {
                mC68000Cpu.writeSmsqeString(mC68000Cpu.addr_regs[1], string, 32000);
            }
        }
    }

    public void transferScrapToClipboard(MC68000Cpu mC68000Cpu) {
        String string = mC68000Cpu.readSmsqeString(mC68000Cpu.addr_regs[1]);
        if (!string.isEmpty()) {
            this.setClipboardContents(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setNewContent(String string) {
        String string2 = this.content;
        synchronized (string2) {
            this.content = string;
            ++this.changeCounter;
        }
    }

    public final synchronized void getChangeCounter(MC68000Cpu mC68000Cpu) {
        if (mC68000Cpu.data_regs[1] == this.changeCounter) {
            mC68000Cpu.data_regs[0] = 0;
            mC68000Cpu.reg_sr |= 4;
        } else {
            mC68000Cpu.data_regs[1] = this.content.length() > 32000 ? 32000 : this.content.length();
            mC68000Cpu.data_regs[0] = this.changeCounter;
            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
        }
    }

    public void startMonitoring() {
        if (this.isMonitoring()) {
            return;
        }
        this.content = this.getClipboardContents();
        this.changeCounter = 0;
        this.clipboardMonitorThread = new ClipboardMonitorThread(this, this.getClipboardContents());
        this.clipboardMonitorThread.setName("ClipboardMonitor");
        this.clipboardMonitorThread.setDaemon(true);
        this.clipboardMonitorThread.start();
    }

    public void stopMonitoring() {
        if (this.clipboardMonitorThread != null) {
            this.clipboardMonitorThread.cancel();
            this.clipboardMonitorThread.interrupt();
        }
        this.clipboardMonitorThread = null;
    }

    public synchronized boolean isMonitoring() {
        return this.clipboardMonitorThread != null && this.clipboardMonitorThread.isAlive();
    }
}

