/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import smsqmulator.Helper;
import smsqmulator.IPError;
import smsqmulator.IPSocket;
import smsqmulator.cpu.MC68000Cpu;

public class IPHandler {
    private final HashMap<Integer, IPSocket> socketMap = new HashMap(50);
    private static final int MAX_SOCKETS = 50;
    private static final byte LF = 10;
    private static final int IOB_TEST = 0;
    private static final int IOB_FBYT = 1;
    private static final int IOB_FLIN = 2;
    private static final int IOB_FMUL = 3;
    private static final int IOB_SBYT = 5;
    private static final int IOB_SMUL = 7;
    private static final int IOF_LOAD = 72;
    private static final int IOF_SAVE = 73;
    private static final int IP_LISTEN = 80;
    private static final int IP_SEND = 81;
    private static final int IP_RECV = 83;
    private static final int IP_RECVFM = 84;
    private static final int IP_BIND = 88;
    private static final int IP_CONNECT = 89;
    private static final int IP_GETHOSTNAME = 91;
    private static final int IP_GETPEERNAME = 93;
    private static final int IP_GETHOSTBYNAME = 94;
    private static final int IP_H_ERRNO = 98;
    private static final int IP_H_STRERROR = 123;
    private static final int IP_ERRNO = 124;
    private int lastError;

    private int getNewKey() {
        for (int i = 1; i < 50; ++i) {
            if (this.socketMap.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    public void handleTrap(MC68000Cpu mC68000Cpu) {
        IPSocket iPSocket = null;
        switch (mC68000Cpu.data_regs[0]) {
            case 1: {
                iPSocket = new IPSocket(mC68000Cpu, this.socketMap);
                if (mC68000Cpu.data_regs[0] != 0) break;
                int n = this.getNewKey();
                if (n == -1) {
                    mC68000Cpu.data_regs[0] = -3;
                    break;
                }
                this.socketMap.put(n, iPSocket);
                mC68000Cpu.data_regs[7] = -n;
                break;
            }
            case 2: {
                int n = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[7]);
                mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] + 4;
                iPSocket = this.socketMap.get(-mC68000Cpu.addr_regs[0]);
                if (iPSocket == null) {
                    mC68000Cpu.data_regs[0] = -6;
                    break;
                }
                this.handleIO(n, mC68000Cpu, iPSocket);
                break;
            }
            case 3: {
                iPSocket = this.socketMap.get(-mC68000Cpu.addr_regs[0]);
                if (iPSocket != null) {
                    iPSocket.close();
                }
                this.socketMap.remove(-mC68000Cpu.addr_regs[0]);
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 4: {
                Set<Integer> set = this.socketMap.keySet();
                for (Integer n : set) {
                    this.socketMap.get(n).close();
                }
                this.socketMap.clear();
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 5: {
                iPSocket = this.socketMap.get(-mC68000Cpu.addr_regs[0]);
                String string = iPSocket == null ? "UNKNOWN SOCKET" : iPSocket.getName();
                int n = mC68000Cpu.data_regs[2] & 0xFFFF;
                mC68000Cpu.writeSmsqeString(mC68000Cpu.addr_regs[1], string, true, n);
                if (string.length() > n) {
                    mC68000Cpu.data_regs[0] = -15;
                    break;
                }
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 6: {
                int n;
                int n2;
                String string = IPHandler.getHName();
                if (string == null) {
                    string = "Unknown name!";
                }
                if ((n2 = string.length()) > (n = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[1] + 2))) {
                    mC68000Cpu.data_regs[0] = -5;
                    break;
                }
                mC68000Cpu.writeSmsqeString(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 4), string, true, n2);
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 7: {
                String string;
                try {
                    string = IPHandler.getLocalAddress();
                }
                catch (Exception exception) {
                    string = "";
                }
                int n = string.length();
                int n3 = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[1] + 2);
                if (n > n3) {
                    mC68000Cpu.data_regs[0] = -5;
                    break;
                }
                mC68000Cpu.writeSmsqeString(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[1] + 4), string, true, n);
                mC68000Cpu.data_regs[0] = 0;
            }
        }
        if (mC68000Cpu.data_regs[0] == 0) {
            mC68000Cpu.reg_sr |= 4;
            this.lastError = 0;
        } else {
            mC68000Cpu.reg_sr &= 0xFFFFFFFB;
            if (iPSocket != null) {
                this.lastError = iPSocket.getLastError();
            }
        }
    }

    private void handleIO(int n, MC68000Cpu mC68000Cpu, IPSocket iPSocket) {
        mC68000Cpu.data_regs[0] = 0;
        block2 : switch (n) {
            case 0: {
                if (iPSocket.getSocketType() == 1396919135) {
                    mC68000Cpu.data_regs[0] = -10;
                    break;
                }
                switch (iPSocket.getConnectionStatus()) {
                    case NOT_CONNECTED: 
                    case CONNECTED: 
                    case LISTENING: {
                        try {
                            if (iPSocket.rawIn.available() != 0) break block2;
                            mC68000Cpu.data_regs[0] = -1;
                        }
                        catch (Exception exception) {
                            mC68000Cpu.data_regs[0] = -1;
                        }
                        break;
                    }
                    default: {
                        mC68000Cpu.data_regs[0] = -1;
                        break;
                    }
                }
                break;
            }
            case 1: {
                byte[] byArray = new byte[1];
                mC68000Cpu.data_regs[0] = iPSocket.receive1Byte(mC68000Cpu, byArray);
                if (mC68000Cpu.data_regs[0] != 0) break;
                int n2 = byArray[0] & 0xFF;
                mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] & 0xFFFFFF00 | n2;
                break;
            }
            case 2: {
                int n3;
                int n4 = mC68000Cpu.data_regs[2] & 0xFFFF;
                int n5 = mC68000Cpu.data_regs[1] & 0xFFFF;
                if (n5 >= n4) {
                    mC68000Cpu.data_regs[0] = -5;
                    break;
                }
                byte[] byArray = new byte[1];
                int n6 = mC68000Cpu.addr_regs[1];
                for (n3 = n5; n3 < n4; ++n3) {
                    mC68000Cpu.data_regs[0] = iPSocket.receive1Byte(mC68000Cpu, byArray);
                    if (mC68000Cpu.data_regs[0] != 0) break;
                    mC68000Cpu.writeMemoryByte(n6++, byArray[0]);
                    if (byArray[0] == 10) break;
                }
                if (mC68000Cpu.data_regs[0] != 0 && mC68000Cpu.data_regs[0] != -1) break;
                if (n3 == n4 && byArray[0] != 10) {
                    mC68000Cpu.data_regs[0] = -5;
                }
                n4 = n6 - mC68000Cpu.addr_regs[1];
                mC68000Cpu.addr_regs[1] = n6;
                mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] & 0xFFFF0000;
                mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] | n4 + n5;
                break;
            }
            case 3: {
                if (mC68000Cpu.data_regs[1] >= mC68000Cpu.data_regs[2]) break;
                int n7 = iPSocket.receive(mC68000Cpu, mC68000Cpu.data_regs[2], false, null);
                if (n7 < 0) {
                    mC68000Cpu.data_regs[0] = n7;
                    break;
                }
                mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] + n7;
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + n7;
                mC68000Cpu.data_regs[0] = mC68000Cpu.data_regs[1] < mC68000Cpu.data_regs[2] ? -1 : 0;
                break;
            }
            case 5: {
                mC68000Cpu.data_regs[0] = iPSocket.send1Byte(mC68000Cpu, mC68000Cpu.data_regs[1]);
                break;
            }
            case 7: {
                int n8 = mC68000Cpu.data_regs[1] & 0xFFFF;
                int n9 = iPSocket.send(mC68000Cpu, mC68000Cpu.data_regs[2] & 0xFFFF);
                if (n9 < 0) {
                    mC68000Cpu.data_regs[0] = n9;
                    mC68000Cpu.data_regs[1] = n8;
                    break;
                }
                mC68000Cpu.data_regs[1] = n8 | n9;
                break;
            }
            case 72: {
                byte[] byArray = new byte[mC68000Cpu.data_regs[2]];
                while (mC68000Cpu.data_regs[1] < mC68000Cpu.data_regs[2]) {
                    int n10 = iPSocket.receive(mC68000Cpu, mC68000Cpu.data_regs[2] - mC68000Cpu.data_regs[1], false, byArray);
                    if (n10 < 0) {
                        mC68000Cpu.data_regs[0] = n10;
                        break block2;
                    }
                    mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + n10;
                    mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] + n10;
                }
                break;
            }
            case 73: {
                int n11 = iPSocket.send(mC68000Cpu, mC68000Cpu.data_regs[2]);
                if (n11 < 0) {
                    mC68000Cpu.data_regs[0] = n11;
                    mC68000Cpu.data_regs[1] = 0;
                    break;
                }
                mC68000Cpu.data_regs[1] = n11;
                break;
            }
            case 80: {
                mC68000Cpu.data_regs[0] = iPSocket.listen(mC68000Cpu);
                break;
            }
            case 81: {
                int n12 = iPSocket.send(mC68000Cpu, mC68000Cpu.data_regs[2]);
                if (n12 < 0) {
                    mC68000Cpu.data_regs[0] = n12;
                    mC68000Cpu.data_regs[1] = 0;
                    break;
                }
                mC68000Cpu.data_regs[1] = n12;
                break;
            }
            case 83: {
                int n13 = iPSocket.receive(mC68000Cpu, mC68000Cpu.data_regs[2], true, null);
                if (n13 < 0) {
                    mC68000Cpu.data_regs[0] = n13;
                    mC68000Cpu.data_regs[1] = 0;
                    break;
                }
                mC68000Cpu.data_regs[1] = n13;
                break;
            }
            case 88: {
                mC68000Cpu.data_regs[0] = iPSocket.bind(mC68000Cpu);
                break;
            }
            case 89: {
                mC68000Cpu.data_regs[0] = iPSocket.connect(mC68000Cpu);
                break;
            }
            case 91: {
                String string = IPHandler.getHName();
                if (string != null) {
                    IPHandler.writeCString(mC68000Cpu, mC68000Cpu.addr_regs[1], string, mC68000Cpu.data_regs[2] & 0xFFFF);
                    break;
                }
                mC68000Cpu.data_regs[0] = -7;
                break;
            }
            case 94: {
                try {
                    int n14 = mC68000Cpu.addr_regs[2];
                    String string = IPHandler.readCString(mC68000Cpu, mC68000Cpu.addr_regs[1]);
                    InetAddress inetAddress = InetAddress.getByName(string);
                    byte[] byArray = inetAddress.getAddress();
                    mC68000Cpu.writeMemoryLong(n14 + 8, 2);
                    mC68000Cpu.writeMemoryLong(n14 + 12, 4);
                    int n15 = n14 + 16;
                    mC68000Cpu.writeMemoryLong(n14, n15);
                    mC68000Cpu.writeMemoryLong(n15, n15 + 12);
                    mC68000Cpu.writeMemoryLong(n15 += 12, n15 + 8);
                    mC68000Cpu.writeMemoryLong(n15 + 4, 0);
                    int n16 = n15 + 8;
                    n15 = (byArray[0] & 0xFF) << 24;
                    n15 += (byArray[1] & 0xFF) << 16;
                    n15 += (byArray[2] & 0xFF) << 8;
                    mC68000Cpu.writeMemoryLong(n16, n15 += byArray[3] & 0xFF);
                    n15 = n16 + 4;
                    n16 = IPHandler.writeCString(mC68000Cpu, n15, string, mC68000Cpu.data_regs[2] & 0xFFFF);
                    n16 += 1 + n15;
                    mC68000Cpu.writeMemoryLong(n14 + 4, n16 &= 0xFFFFFFFE);
                    mC68000Cpu.writeMemoryLong(n16, n15);
                }
                catch (UnknownHostException unknownHostException) {
                    iPSocket.setLastError(4);
                    mC68000Cpu.data_regs[0] = -7;
                }
                break;
            }
            case 93: {
                mC68000Cpu.data_regs[0] = iPSocket.getRemote(mC68000Cpu);
                break;
            }
            case 98: {
                mC68000Cpu.data_regs[0] = 0;
                mC68000Cpu.data_regs[1] = iPSocket.getLastError();
                break;
            }
            case 123: {
                String string = IPError.getErrorString(iPSocket.getLastError());
                IPHandler.writeCString(mC68000Cpu, mC68000Cpu.addr_regs[1], string, string.length() + 1);
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 124: {
                mC68000Cpu.data_regs[0] = 0;
                mC68000Cpu.data_regs[1] = this.lastError;
                break;
            }
            default: {
                iPSocket.setLastError(14);
                mC68000Cpu.data_regs[0] = -19;
            }
        }
        this.lastError = iPSocket.getLastError();
    }

    private void closeAllSockets() {
        Set<Integer> set = this.socketMap.keySet();
        for (Integer n : set) {
            this.socketMap.get(n).close();
        }
        this.socketMap.clear();
    }

    public IPSocket getSocketFromMap(int n) {
        return this.socketMap.get(n);
    }

    public static final int writeCString(MC68000Cpu mC68000Cpu, int n, String string, int n2) {
        mC68000Cpu.writeSmsqeString(n, string + "\u0000", false, mC68000Cpu.data_regs[2] & 0xFFFF);
        int n3 = string.length() + 1;
        if (n3 > (mC68000Cpu.data_regs[2] & 0xFFFF)) {
            n3 = mC68000Cpu.data_regs[2] & 0xFFFF;
            mC68000Cpu.writeMemoryByte(n + n3 - 1, 0);
            mC68000Cpu.data_regs[0] = -18;
        } else {
            mC68000Cpu.data_regs[0] = 0;
        }
        return n3;
    }

    public static final String readCString(MC68000Cpu mC68000Cpu, int n) {
        byte by;
        StringBuilder stringBuilder = new StringBuilder(100);
        while ((by = (byte)mC68000Cpu.readMemoryByte(n++)) != 0) {
            stringBuilder.append(Helper.convertToJava(by));
        }
        return stringBuilder.toString();
    }

    private static String getHName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            String string = System.getenv("COMPUTERNAME");
            if (string != null) {
                return IPHandler.stripSite(string);
            }
            return IPHandler.stripSite(System.getenv("HOSTNAME"));
        }
    }

    private static String stripSite(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase().endsWith(".site") && string.length() > 5 ? string.substring(0, string.length() - 5) : string;
    }

    private static String getLocalAddress() {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception exception) {
            return "";
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                return inetAddress.getHostAddress();
            }
        }
        return "";
    }
}

