/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import smsqmulator.CircularBuffer;
import smsqmulator.MonitorHandler;

public class MonitorPanel
extends JPanel {
    private int commandlineHistoryCounter = 0;
    private final int commandlineHistoryMaxSize = 50;
    private CircularBuffer<String> commandlineHistory;
    private final JTextArea registerTextArea = new JTextArea();
    private final JTextArea dataTextArea = new JTextArea();
    private final JTextField monitorCommandsTextField = new JTextField();
    private final JSplitPane jSplitPane1 = new JSplitPane();

    public MonitorPanel(final MonitorHandler monitorHandler) {
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel jPanel2 = new JPanel();
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
                if (propertyChangeEvent.getPropertyName().equals("lastDividerLocation")) {
                    monitorHandler.dividerLocationChanged(jSplitPane.getDividerLocation());
                }
            }
        });
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.registerTextArea.setEditable(false);
        this.registerTextArea.setColumns(20);
        this.registerTextArea.setFont(new Font("Monospaced", 0, 10));
        this.registerTextArea.setRows(5);
        jScrollPane.setViewportView(this.registerTextArea);
        MWListener mWListener = new MWListener(this.registerTextArea, jScrollPane);
        this.registerTextArea.addMouseWheelListener(mWListener);
        GroupLayout groupLayout = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane, -1, 395, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane, -2, 257, -2));
        this.jSplitPane1.setLeftComponent(jPanel2);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.dataTextArea.setEditable(false);
        this.dataTextArea.setColumns(20);
        this.dataTextArea.setFont(new Font("Monospaced", 0, 10));
        this.dataTextArea.setRows(5);
        jScrollPane2.setViewportView(this.dataTextArea);
        MWListener mWListener2 = new MWListener(this.dataTextArea, jScrollPane2);
        this.dataTextArea.addMouseWheelListener(mWListener2);
        GroupLayout groupLayout2 = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 521, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane2, -2, 257, -2));
        this.jSplitPane1.setRightComponent(jPanel);
        this.monitorCommandsTextField.setFont(new Font("Courier New", 0, 12));
        this.monitorCommandsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MonitorPanel.this.monitorCommandsTextField.getText();
                monitorHandler.monitorCommand(string);
                MonitorPanel.this.monitorCommandsTextField.setText("");
                MonitorPanel.this.commandlineHistory.addNoDoubles(string);
                MonitorPanel.this.commandlineHistoryCounter = 0;
            }
        });
        this.monitorCommandsTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38 && MonitorPanel.this.commandlineHistory != null) {
                    MonitorPanel.this.monitorCommandsTextField.setText((String)MonitorPanel.this.commandlineHistory.get(MonitorPanel.this.commandlineHistoryCounter));
                    MonitorPanel.this.commandlineHistoryCounter++;
                    if (MonitorPanel.this.commandlineHistoryCounter > 50) {
                        MonitorPanel.this.commandlineHistoryCounter = 0;
                    }
                }
                if (keyEvent.getKeyCode() == 40 && MonitorPanel.this.commandlineHistory != null) {
                    MonitorPanel.this.monitorCommandsTextField.setText((String)MonitorPanel.this.commandlineHistory.get(MonitorPanel.this.commandlineHistoryCounter));
                    MonitorPanel.this.commandlineHistoryCounter--;
                    if (MonitorPanel.this.commandlineHistoryCounter < 0) {
                        MonitorPanel.this.commandlineHistoryCounter = 49;
                    }
                }
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.monitorCommandsTextField, -1, 936, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap())));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap(281, Short.MAX_VALUE).addComponent(this.monitorCommandsTextField, -2, -1, -2).addContainerGap()).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -2, -1, -2).addContainerGap(36, Short.MAX_VALUE))));
        jPanel.setFocusable(false);
        this.dataTextArea.setFocusable(false);
        this.registerTextArea.setFocusable(false);
        try {
            this.commandlineHistory = new CircularBuffer(this.commandlineHistoryMaxSize);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.commandlineHistory = null;
        }
    }

    public JTextArea getDataLogger() {
        return this.dataTextArea;
    }

    public JTextArea getRegLogger() {
        return this.registerTextArea;
    }

    public JTextField getInputWindow() {
        return this.monitorCommandsTextField;
    }

    public void setDividerLocation(int n) {
        this.jSplitPane1.setDividerLocation(n);
    }

    private class MWListener
    implements MouseWheelListener {
        private final JTextArea ta;
        private final JScrollPane jScrollPane;

        private MWListener(JTextArea jTextArea, JScrollPane jScrollPane) {
            this.ta = jTextArea;
            this.jScrollPane = jScrollPane;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.isControlDown()) {
                Font font = this.ta.getFont();
                float f = font.getSize();
                if (mouseWheelEvent.getWheelRotation() < 0) {
                    if ((f += 1.0f) > 60.0f) {
                        f = 60.0f;
                    }
                } else if ((f -= 1.0f) < 4.0f) {
                    f = 4.0f;
                }
                Font font2 = font.deriveFont(f);
                this.ta.setFont(font2);
                mouseWheelEvent.consume();
            } else {
                this.jScrollPane.dispatchEvent(mouseWheelEvent);
            }
        }
    }
}

