/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import smsqmulator.Types;
import smsqmulator.XfaDriver;
import smsqmulator.cpu.MC68000Cpu;

public class SfaDriver
extends XfaDriver {
    public SfaDriver(MC68000Cpu mC68000Cpu) {
        super(mC68000Cpu);
        this.usage = this.deviceID = 1397113136;
    }

    public static int readHeaderOK(File file, MC68000Cpu mC68000Cpu, ByteBuffer byteBuffer) {
        if (file.isDirectory()) {
            return -1;
        }
        FileChannel fileChannel = null;
        try {
            fileChannel = new RandomAccessFile(file, "r").getChannel();
            if (byteBuffer == null || byteBuffer.capacity() < 68) {
                byteBuffer = ByteBuffer.allocate(68);
            } else {
                byteBuffer.position(0);
                byteBuffer.limit(68);
            }
            fileChannel.read(byteBuffer);
            fileChannel.close();
            if (byteBuffer.getInt(0) == 1397113136) {
                return 1;
            }
            if (byteBuffer.getInt(0) == 1562464580) {
                for (int i = 4; i < 18; ++i) {
                    if (byteBuffer.get(i) == Types.QEMU[i]) continue;
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            mC68000Cpu.data_regs[0] = -7;
            return 0;
        }
        catch (IOException iOException) {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            mC68000Cpu.data_regs[0] = -9;
            return 0;
        }
    }
}

