/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.nio.ByteBuffer;
import smsqmulator.WinDrive;
import smsqmulator.WinFile;
import smsqmulator.cpu.MC68000Cpu;

public class WinSpecialFile
extends WinFile {
    public WinSpecialFile(WinDrive winDrive) {
        this.filePosition = 0;
        this.buffer = ByteBuffer.allocate(512);
        this.drive = winDrive;
    }

    @Override
    public void close() {
        this.drive.specialFileClosed();
    }

    @Override
    public void handleTrap3(int n, MC68000Cpu mC68000Cpu) {
        int n2 = mC68000Cpu.data_regs[2] & 0xFFFF;
        int n3 = mC68000Cpu.addr_regs[1];
        switch (n) {
            case 3: {
                if (n2 < 512) {
                    if (n2 == 2) {
                        mC68000Cpu.data_regs[1] = 2;
                        mC68000Cpu.writeMemoryShort(n3, (short)512);
                        mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + 2;
                        mC68000Cpu.data_regs[0] = 0;
                        break;
                    }
                    mC68000Cpu.data_regs[0] = -19;
                    break;
                }
                long l = this.filePosition * 512;
                if (this.drive.readBytes(512, this.buffer, l) != 512) {
                    return;
                }
                if (n2 == 514) {
                    mC68000Cpu.writeMemoryShort(n3, (short)512);
                    n3 += 2;
                }
                mC68000Cpu.readFromBuffer(n3, 512, this.buffer, 0);
                mC68000Cpu.addr_regs[1] = n3 + 512;
                mC68000Cpu.data_regs[1] = 512;
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 7: {
                if (n2 != 512 & n2 != 514) {
                    if (n2 == 2) {
                        mC68000Cpu.data_regs[0] = 0;
                        break;
                    }
                    mC68000Cpu.data_regs[0] = -19;
                    break;
                }
                long l = this.filePosition * 512;
                if (n2 == 514) {
                    mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + 2;
                }
                int n4 = mC68000Cpu.data_regs[2];
                mC68000Cpu.data_regs[2] = 512;
                mC68000Cpu.writeToBuffer(this.buffer, 0);
                if (this.drive.writeBytes(512, this.buffer, l, 0) != 512) {
                    return;
                }
                mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + 512;
                mC68000Cpu.data_regs[2] = n4;
                mC68000Cpu.data_regs[1] = n2;
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 66: {
                this.filePosition = 0;
            }
            case 67: {
                this.filePosition += mC68000Cpu.data_regs[1];
                this.filePosition = this.drive.checkSector(this.filePosition);
                mC68000Cpu.data_regs[0] = 0;
                mC68000Cpu.data_regs[1] = this.filePosition;
                break;
            }
            case 64: {
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            default: {
                mC68000Cpu.data_regs[0] = -19;
            }
        }
    }
}

