/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.io.EOFException;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.TimeZone;
import smsqmulator.Helper;
import smsqmulator.Monitor;
import smsqmulator.NfaFileheader;
import smsqmulator.QemuFileheader;
import smsqmulator.SfaFileheader;
import smsqmulator.Types;
import smsqmulator.XfaDriver;
import smsqmulator.XfaFileheader;
import smsqmulator.cpu.MC68000Cpu;

public class XfaFile {
    protected RandomAccessFile raFile;
    protected FileChannel inoutChannel;
    protected XfaFileheader header;
    protected boolean isDir = false;
    protected File file;
    protected int driveNumber;
    protected int totalSize;
    protected int freeSize;
    protected static final int allocSize = 1024;
    protected File[] myFiles;
    protected String[] myFileNames;
    protected int filePosition = 0;
    protected String[] driveNames;
    protected int deviceID;
    protected int headerOffset;
    protected String filename;
    protected boolean readOnly = true;
    protected int filenameChange;
    protected int usageName;
    private boolean setDate = true;
    private boolean setVersion = true;
    protected TimeZone timeZone = TimeZone.getDefault();
    protected ByteBuffer dirBuffer;

    public XfaFile(RandomAccessFile randomAccessFile, FileChannel fileChannel, boolean bl, File file, String string, boolean bl2, int n, int n2, String[] stringArray, int n3, int n4) {
        this.raFile = randomAccessFile;
        this.inoutChannel = fileChannel;
        this.file = file;
        this.driveNumber = n2;
        this.driveNames = stringArray;
        this.filename = string.replace(File.separator + File.separator, File.separator);
        this.isDir = bl2;
        this.deviceID = n;
        this.readOnly = !bl;
        this.makeFileheader(file, string, this.inoutChannel);
        this.filePosition = this.header.getOffset();
        if (bl) {
            try {
                fileChannel.lock();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.filenameChange = n3;
        this.usageName = n4;
        if (this.readOnly) {
            this.setDate = false;
            this.setVersion = false;
        }
    }

    public XfaFile(File file, String string, boolean bl, int n, String[] stringArray, int n2, int n3, int n4) {
        this.file = file;
        this.isDir = bl;
        this.driveNumber = n;
        this.driveNames = stringArray;
        this.filename = string.replaceAll(File.separator + "{2,}", File.separator);
        this.filenameChange = n3;
        this.usageName = n4;
        this.deviceID = n2;
        if (file.isDirectory()) {
            this.myFiles = file.listFiles();
            this.myFileNames = file.list();
            this.freeSize = (int)(file.getUsableSpace() / 1024L);
            this.totalSize = (int)(file.getTotalSpace() / 1024L);
            this.makeDirBuffer();
        }
        this.makeFileheader(file, this.filename, null);
    }

    private void makeFileheader(File file, String string, FileChannel fileChannel) {
        try {
            switch (this.deviceID) {
                case 1313227056: {
                    if (this.isDir) {
                        this.header = new NfaFileheader(file, this.makeFilename(), this.dirBuffer.capacity());
                        break;
                    }
                    this.header = new NfaFileheader(file, string, 0);
                    break;
                }
                case 1397113136: {
                    if (this.isDir) {
                        this.header = new SfaFileheader(file, string, fileChannel, this.dirBuffer.capacity());
                        break;
                    }
                    try {
                        this.header = new QemuFileheader(file, this.makeFilename(), fileChannel);
                    }
                    catch (Exception exception) {
                        fileChannel.position(0L);
                        this.header = new SfaFileheader(file, string, fileChannel, 0);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown device: " + this.deviceID);
                }
            }
            if (!this.isDir) {
                this.headerOffset = this.header.getOffset();
                if (!this.readOnly) {
                    this.header.flushHeader(fileChannel, this.setDate);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close(MC68000Cpu mC68000Cpu) {
        boolean bl = false;
        if (!this.readOnly && this.header != null) {
            bl = this.header.flushHeader(this.inoutChannel, this.setDate);
        }
        try {
            if (this.inoutChannel != null && this.inoutChannel.isOpen()) {
                this.inoutChannel.force(true);
                this.inoutChannel.close();
            }
            if (this.raFile != null) {
                this.raFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.header.setFileDates(this.file);
        }
        mC68000Cpu.data_regs[0] = 0;
        this.header = null;
    }

    public void handleTrap3(int n, int n2, MC68000Cpu mC68000Cpu, String string) {
        switch (n) {
            case 0: {
                mC68000Cpu.data_regs[0] = 0;
                if (!this.isDir) {
                    try {
                        if (this.inoutChannel.position() < this.raFile.length()) break;
                        mC68000Cpu.data_regs[0] = -10;
                    }
                    catch (Exception exception) {
                        mC68000Cpu.data_regs[0] = -10;
                    }
                    break;
                }
                if (this.filePosition < this.dirBuffer.capacity()) break;
                mC68000Cpu.data_regs[0] = -10;
                break;
            }
            case 1: {
                this.readByte(mC68000Cpu);
                break;
            }
            case 2: {
                this.getLine(mC68000Cpu);
                break;
            }
            case 3: {
                this.getBytes(mC68000Cpu);
                break;
            }
            case 4: {
                mC68000Cpu.data_regs[0] = -10;
                break;
            }
            case 5: {
                if (this.isDir || this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.writeByte(mC68000Cpu);
                break;
            }
            case 6: 
            case 7: {
                if (this.isDir || this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.saveFile(mC68000Cpu, false);
                break;
            }
            case 64: 
            case 65: {
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 66: {
                this.setFilePosition(mC68000Cpu, mC68000Cpu.data_regs[1], true);
                break;
            }
            case 67: {
                this.setFilePosition(mC68000Cpu, mC68000Cpu.data_regs[1], false);
                break;
            }
            case 69: {
                int n3 = mC68000Cpu.addr_regs[1];
                if (this.deviceID == 1313227056) {
                    mC68000Cpu.writeSmsqeString(n3, "NFA DRIVER", false, -1);
                } else {
                    mC68000Cpu.writeSmsqeString(n3, "SFA DRIVER", false, -1);
                }
                mC68000Cpu.addr_regs[1] = n3 + 10;
                mC68000Cpu.data_regs[1] = 0x1001000;
                mC68000Cpu.data_regs[0] = 0;
                break;
            }
            case 70: {
                if (this.isDir || this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                int n4 = this.header.writeFileHeader(mC68000Cpu, mC68000Cpu.addr_regs[1]);
                if (n4 != 0) {
                    mC68000Cpu.data_regs[0] = 0;
                    mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] & 0xFFFF0000 | n4;
                    mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + n4;
                    break;
                }
                mC68000Cpu.data_regs[0] = -6;
                break;
            }
            case 71: {
                int n5 = mC68000Cpu.addr_regs[1];
                int n6 = this.header.readFileheader(mC68000Cpu, n5, mC68000Cpu.data_regs[2] & 0xFFFF);
                if (n6 != 0) {
                    mC68000Cpu.data_regs[0] = 0;
                    mC68000Cpu.data_regs[1] = mC68000Cpu.data_regs[1] & 0xFFFF0000 | n6;
                    mC68000Cpu.addr_regs[1] = n5 + n6;
                    break;
                }
                mC68000Cpu.data_regs[0] = -6;
                break;
            }
            case 72: {
                this.loadFile(mC68000Cpu, true, true);
                break;
            }
            case 73: {
                if (this.isDir || this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.saveFile(mC68000Cpu, true);
                break;
            }
            case 74: {
                this.renameFile(mC68000Cpu, string);
                break;
            }
            case 75: {
                if (this.isDir || this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                try {
                    this.inoutChannel.truncate(this.inoutChannel.position());
                    mC68000Cpu.data_regs[0] = 0;
                }
                catch (Exception exception) {
                    mC68000Cpu.data_regs[0] = -4;
                }
                break;
            }
            case 76: {
                this.setOrReadDate(mC68000Cpu);
                break;
            }
            case 77: {
                if (this.isDir || this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.makeDirectory(mC68000Cpu);
                break;
            }
            case 78: {
                this.getOrSetVersion(mC68000Cpu);
                break;
            }
            case 79: {
                this.getExtendedInfo(mC68000Cpu);
            }
        }
    }

    private void getExtendedInfo(MC68000Cpu mC68000Cpu) {
        int n = mC68000Cpu.addr_regs[1];
        if (this.deviceID == 1313227056) {
            mC68000Cpu.writeSmsqeString(n, "NFA DRIVE " + (this.driveNumber + 1), -1);
            mC68000Cpu.writeSmsqeString(n + 22, "NFA", -1);
        } else {
            mC68000Cpu.writeSmsqeString(n, "SFA DRIVE " + (this.driveNumber + 1), -1);
            mC68000Cpu.writeSmsqeString(n + 22, "SFA", -1);
        }
        for (int i = 14; i < 22; i += 2) {
            mC68000Cpu.writeMemoryShort(n + i, (short)0);
        }
        mC68000Cpu.writeMemoryWord(n + 28, this.driveNumber + 1 << 8);
        mC68000Cpu.writeMemoryWord(n + 30, 1024);
        mC68000Cpu.writeMemoryLong(n + 32, this.totalSize);
        mC68000Cpu.writeMemoryLong(n + 36, this.freeSize);
        mC68000Cpu.writeMemoryLong(n + 40, 64);
        mC68000Cpu.writeMemoryWord(n + 44, 514);
        mC68000Cpu.writeMemoryWord(n + 46, 258);
        mC68000Cpu.writeMemoryLong(n + 48, 0xFFFFFF);
        mC68000Cpu.writeMemoryLong(n + 52, -1);
        mC68000Cpu.writeMemoryLong(n + 56, -1);
        mC68000Cpu.writeMemoryLong(n + 60, -1);
        mC68000Cpu.data_regs[0] = 0;
    }

    private void getOrSetVersion(MC68000Cpu mC68000Cpu) {
        if (this.header == null) {
            return;
        }
        mC68000Cpu.data_regs[0] = 0;
        int n = mC68000Cpu.data_regs[1];
        switch (n) {
            case -1: {
                mC68000Cpu.data_regs[1] = this.header.getVersion();
                break;
            }
            case 0: {
                this.setVersion = false;
                break;
            }
            default: {
                if (this.isDir || this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                if (this.deviceID == 1397113136) {
                    this.header.setVersion(n);
                }
                this.setVersion = false;
            }
        }
    }

    private void setOrReadDate(MC68000Cpu mC68000Cpu) {
        if (this.header == null) {
            return;
        }
        mC68000Cpu.data_regs[0] = 0;
        int n = mC68000Cpu.data_regs[1];
        switch (n) {
            case -1: {
                mC68000Cpu.data_regs[1] = this.header.getDate(mC68000Cpu.data_regs[2]);
                break;
            }
            case 0: {
                n = (int)(System.currentTimeMillis() / 1000L + (long)Monitor.TIME_OFFSET);
            }
            default: {
                if (this.isDir || this.readOnly) {
                    mC68000Cpu.data_regs[0] = -20;
                    break;
                }
                this.header.setDate(mC68000Cpu.data_regs[2] & 0xFF, n);
                this.setDate = false;
            }
        }
    }

    private void setFilePosition(MC68000Cpu mC68000Cpu, int n, boolean bl) {
        mC68000Cpu.data_regs[0] = 0;
        if (this.isDir) {
            this.filePosition = !bl ? (this.filePosition += n) : n;
            if (this.filePosition < 0) {
                this.filePosition = 0;
            }
            if (this.filePosition >= this.dirBuffer.capacity()) {
                this.filePosition = this.dirBuffer.capacity();
                mC68000Cpu.data_regs[0] = -10;
            }
            mC68000Cpu.data_regs[1] = this.filePosition;
        } else {
            this.filePosition = !bl ? (this.filePosition += n) : n + this.headerOffset;
            if (this.filePosition < 0) {
                this.filePosition = this.headerOffset;
            }
            mC68000Cpu.data_regs[1] = this.filePosition - this.headerOffset;
            try {
                if (this.filePosition > (int)this.inoutChannel.size()) {
                    this.filePosition = (int)this.inoutChannel.size();
                    mC68000Cpu.data_regs[1] = this.isDir ? this.filePosition : this.filePosition - this.headerOffset;
                    mC68000Cpu.data_regs[0] = -10;
                }
                if (this.inoutChannel != null) {
                    this.inoutChannel.position(this.filePosition);
                }
            }
            catch (Exception exception) {
                mC68000Cpu.data_regs[0] = -10;
            }
        }
    }

    private boolean loadFile(MC68000Cpu mC68000Cpu, boolean bl, boolean bl2) {
        try {
            int n = mC68000Cpu.addr_regs[1];
            int n2 = mC68000Cpu.data_regs[2];
            if (!bl2) {
                n2 &= 0xFFFF;
            }
            if (bl) {
                this.inoutChannel.position(this.headerOffset);
            } else {
                this.inoutChannel.position(this.filePosition);
            }
            int n3 = mC68000Cpu.readFromFile(n, n2, this.inoutChannel);
            this.filePosition = (int)this.inoutChannel.position();
            if (n3 == -1) {
                mC68000Cpu.data_regs[0] = -10;
                return false;
            }
            mC68000Cpu.data_regs[0] = 0;
            mC68000Cpu.addr_regs[1] = n += n3;
            mC68000Cpu.data_regs[1] = n3;
            return true;
        }
        catch (Exception exception) {
            mC68000Cpu.data_regs[0] = -11;
            try {
                this.filePosition = (int)this.inoutChannel.position();
            }
            catch (Exception exception2) {
                this.filePosition = this.headerOffset;
            }
            return false;
        }
    }

    private void getBytes(MC68000Cpu mC68000Cpu) {
        if (this.isDir) {
            mC68000Cpu.data_regs[0] = 0;
            int n = mC68000Cpu.data_regs[2] & 0xFFFF;
            int n2 = mC68000Cpu.addr_regs[1];
            if (this.filePosition + n > this.dirBuffer.capacity()) {
                n = this.dirBuffer.capacity() - this.filePosition;
                mC68000Cpu.data_regs[0] = -10;
            }
            this.dirBuffer.position(0);
            this.dirBuffer.limit(this.dirBuffer.capacity());
            int n3 = 0;
            while (n3 < n) {
                mC68000Cpu.writeMemoryByte(n2, this.dirBuffer.get(this.filePosition));
                ++n3;
                ++n2;
                ++this.filePosition;
            }
            mC68000Cpu.data_regs[1] = n;
            mC68000Cpu.addr_regs[1] = n2;
        } else {
            this.loadFile(mC68000Cpu, false, false);
        }
    }

    private void getLine(MC68000Cpu mC68000Cpu) {
        int n = mC68000Cpu.addr_regs[1];
        int n2 = this.filePosition;
        if (!this.loadFile(mC68000Cpu, false, false)) {
            return;
        }
        int n3 = this.filePosition - n2;
        int n4 = n + n3;
        n3 = n;
        boolean bl = false;
        while (n < n4) {
            if (mC68000Cpu.readMemoryByte(n++) != 10) continue;
            bl = true;
            break;
        }
        if (!bl) {
            mC68000Cpu.data_regs[0] = this.filePosition - n2 < mC68000Cpu.data_regs[2] ? -10 : -5;
        } else {
            if ((n3 = n - n3) <= 0) {
                mC68000Cpu.data_regs[0] = -10;
            }
            n4 = 0;
            if (mC68000Cpu.readMemoryByte(n - 2) == 13 && n3 > 1) {
                mC68000Cpu.writeMemoryByte(n - 2, 10);
                n4 = 1;
            }
            mC68000Cpu.addr_regs[1] = --n;
            mC68000Cpu.data_regs[1] = --n3;
            this.filePosition = n2 + n3 + n4;
            try {
                this.inoutChannel.position(this.filePosition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveFile(MC68000Cpu mC68000Cpu, boolean bl) {
        if (this.isDir) {
            mC68000Cpu.data_regs[0] = -19;
            return;
        }
        try {
            int n = mC68000Cpu.addr_regs[1];
            int n2 = bl ? mC68000Cpu.data_regs[2] : mC68000Cpu.data_regs[2] & 0xFFFF;
            if (n2 != 0) {
                this.inoutChannel.position(this.filePosition);
                int n3 = mC68000Cpu.writeToFile(n, n2, this.inoutChannel);
                this.filePosition = (int)this.inoutChannel.position();
                mC68000Cpu.addr_regs[1] = n + n3;
                mC68000Cpu.data_regs[1] = n3;
            } else {
                mC68000Cpu.data_regs[1] = 0;
            }
            mC68000Cpu.data_regs[0] = 0;
        }
        catch (Exception exception) {
            mC68000Cpu.data_regs[0] = -11;
        }
    }

    private void writeByte(MC68000Cpu mC68000Cpu) {
        if (this.isDir) {
            mC68000Cpu.data_regs[0] = -19;
            return;
        }
        try {
            this.raFile.writeByte(mC68000Cpu.data_regs[1] & 0xFF);
            ++this.filePosition;
            mC68000Cpu.data_regs[0] = 0;
        }
        catch (Exception exception) {
            mC68000Cpu.data_regs[0] = -6;
        }
    }

    private void readByte(MC68000Cpu mC68000Cpu) {
        try {
            mC68000Cpu.data_regs[1] = this.raFile.readByte() & 0xFF;
            ++this.filePosition;
            mC68000Cpu.data_regs[0] = 0;
        }
        catch (EOFException eOFException) {
            mC68000Cpu.data_regs[0] = -10;
        }
        catch (Exception exception) {
            mC68000Cpu.data_regs[0] = -6;
        }
    }

    public boolean isIsDir() {
        return this.isDir;
    }

    public void setAsDir() {
        this.isDir = true;
    }

    public void flushHeader() {
        if (this.header != null) {
            this.header.flushHeader(this.inoutChannel, this.setDate);
        }
    }

    private void makeDirectory(MC68000Cpu mC68000Cpu) {
        File file;
        boolean bl = false;
        String string = this.driveNames[this.driveNumber];
        try {
            if (this.raFile != null) {
                this.raFile.close();
            }
            if (this.file != null) {
                bl = this.file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            mC68000Cpu.data_regs[0] = -8;
            return;
        }
        String[] stringArray = this.header.getSMSQEFilename().split("_");
        ArrayList<File> arrayList = new ArrayList<File>();
        String string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            file = new File(string2 = string2 + stringArray[i] + File.separator);
            if (file.exists() && !file.isDirectory()) {
                this.unravelFiles(arrayList, mC68000Cpu);
                return;
            }
            if (file.exists()) continue;
            try {
                bl = file.mkdir();
                if (bl) continue;
                this.unravelFiles(arrayList, mC68000Cpu);
                return;
            }
            catch (Exception exception) {
                this.unravelFiles(arrayList, mC68000Cpu);
                return;
            }
        }
        string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            file = new File(string2);
            if (!file.isDirectory()) {
                mC68000Cpu.data_regs[0] = -9;
                return;
            }
            String[] stringArray2 = file.list();
            String string3 = stringArray[i] + "_";
            int n = string3.length();
            for (String string4 : stringArray2) {
                if (!string4.startsWith(string3)) continue;
                File file2 = new File(file.getAbsolutePath() + File.separator + string4);
                string4 = string4.substring(n);
                File file3 = new File(file.getAbsolutePath() + File.separator + stringArray[i] + File.separator + string4);
                file2.renameTo(file3);
            }
            string2 = string2 + stringArray[i] + File.separator;
        }
        mC68000Cpu.data_regs[0] = 0;
    }

    private void unravelFiles(ArrayList<File> arrayList, MC68000Cpu mC68000Cpu) {
        for (int i = arrayList.size() - 1; i > -1; --i) {
            File file = arrayList.get(i);
            file.delete();
        }
        mC68000Cpu.data_regs[0] = -9;
    }

    public String getFilename() {
        return this.filename;
    }

    private void renameFile(MC68000Cpu mC68000Cpu, String string) {
        File file;
        boolean bl;
        String string2 = mC68000Cpu.readSmsqeString(mC68000Cpu.addr_regs[1]);
        mC68000Cpu.data_regs[0] = -7;
        if (string2 == null || string2.length() < 5 || string2.length() > 39) {
            return;
        }
        int n = Helper.convertUsageName(string2.substring(0, 3));
        if (n != this.deviceID && n != this.usageName) {
            return;
        }
        try {
            n = Integer.parseInt(string2.substring(3, 4)) - 1;
            if (n != this.driveNumber) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception exception) {
            return;
        }
        String string3 = string2 = string2.substring(5);
        switch (this.filenameChange) {
            default: {
                break;
            }
            case 1: {
                string2 = string2.toUpperCase();
                break;
            }
            case 2: {
                string2 = string2.toLowerCase();
            }
        }
        string2 = XfaDriver.convertFilename(string, string2);
        boolean bl2 = bl = this.raFile != null;
        if (bl) {
            try {
                this.raFile.close();
            }
            catch (Exception exception) {
                return;
            }
        }
        if ((file = new File(string + string2)).exists()) {
            mC68000Cpu.data_regs[0] = -8;
            return;
        }
        if (!this.file.renameTo(file)) {
            mC68000Cpu.data_regs[0] = -9;
            return;
        }
        this.file = file;
        if (this.deviceID == 1397113136) {
            this.header.setSMSQEFilename(string3);
            try {
                this.raFile = new RandomAccessFile(this.file, "rw");
                this.inoutChannel = this.raFile.getChannel();
                this.header.flushHeader(this.inoutChannel, this.setDate);
                this.raFile.close();
            }
            catch (Exception exception) {
                return;
            }
        }
        if (bl) {
            try {
                this.raFile = !this.readOnly ? new RandomAccessFile(this.file, "rw") : new RandomAccessFile(this.file, "r");
                this.inoutChannel = this.raFile.getChannel();
                if (!this.readOnly) {
                    this.inoutChannel.lock();
                }
            }
            catch (Exception exception) {
                return;
            }
        }
        mC68000Cpu.data_regs[0] = 0;
    }

    private void makeDirBuffer() {
        this.dirBuffer = ByteBuffer.allocate(64 * this.myFiles.length);
        int n = 0;
        for (int i = 0; i < this.myFiles.length; ++i) {
            int n2;
            int n3 = 0;
            File file = this.myFiles[i];
            String string = this.myFileNames[i];
            switch (this.filenameChange) {
                default: {
                    break;
                }
                case 1: {
                    string = string.toUpperCase();
                    break;
                }
                case 2: {
                    string = string.toLowerCase();
                }
            }
            if (!string.equals(this.myFileNames[i])) continue;
            if (this.deviceID == 1397113136 && !file.isDirectory()) {
                this.dirBuffer.position(n);
                this.dirBuffer.limit(n + 4);
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    FileChannel fileChannel = randomAccessFile.getChannel();
                    fileChannel.read(this.dirBuffer);
                    n2 = this.dirBuffer.getInt(n);
                    switch (n2) {
                        case 1397113136: {
                            this.dirBuffer.position(n);
                            this.dirBuffer.limit(n + 64);
                            fileChannel.read(this.dirBuffer);
                            fileChannel.close();
                            n += 64;
                            break;
                        }
                        case 1562464580: {
                            this.dirBuffer.limit(n + 20);
                            fileChannel.read(this.dirBuffer);
                            for (int j = 4; j < 18; ++j) {
                                if (this.dirBuffer.get(n + j) == Types.QEMU[j]) continue;
                                fileChannel.close();
                                randomAccessFile.close();
                                this.dirBuffer.limit(this.dirBuffer.capacity());
                                break;
                            }
                            n3 = this.dirBuffer.get(n + 19) * 2;
                            this.dirBuffer.position(n + 4);
                            this.dirBuffer.limit(n + 14);
                            fileChannel.read(this.dirBuffer);
                            fileChannel.close();
                            randomAccessFile.close();
                            this.dirBuffer.putInt(n, (int)file.length() - n3);
                            this.dirBuffer.limit(this.dirBuffer.capacity());
                            break;
                        }
                        default: {
                            fileChannel.close();
                            randomAccessFile.close();
                            this.dirBuffer.limit(this.dirBuffer.capacity());
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n3 == 0) continue;
            }
            try {
                string = file.getAbsolutePath();
                n2 = this.driveNames[this.driveNumber].length();
                if (n2 >= string.length()) {
                    string = this.driveNames[this.driveNumber] + "_**UNKNOWN**";
                }
                string = string.substring(n2).replace(File.separator, "_");
            }
            catch (Exception exception) {
                string = this.driveNames[this.driveNumber] + "_**UNKNOWN**";
            }
            n2 = string.length();
            if (n2 > 36) {
                if (this.deviceID != 1397113136 || file.isDirectory()) continue;
                for (int j = n; j < n + 64; j += 4) {
                    this.dirBuffer.putInt(j, 0);
                }
                continue;
            }
            this.dirBuffer.putShort(n + 14, (short)n2);
            for (int j = 0; j < n2; ++j) {
                this.dirBuffer.put(n + 16 + j, Helper.convertToSMSQE(string.charAt(j)));
            }
            if (file.isDirectory()) {
                this.dirBuffer.putShort(n + 4, (short)255);
                String[] stringArray = file.list();
                n2 = stringArray != null ? (stringArray.length + 1) * 64 : 0;
                this.dirBuffer.putInt(n, n2);
            } else {
                if (n3 == 0) {
                    this.dirBuffer.putShort(n + 4, (short)0);
                }
                n2 = (int)file.length() + 64;
                if (this.deviceID == 1397113136 && (n2 -= n3) < 0) {
                    n2 = 0;
                }
                this.dirBuffer.putInt(n, n2);
                long l = file.lastModified();
                l += (long)this.timeZone.getOffset(l);
                n2 = (int)(l / 1000L) + 283996799;
                this.dirBuffer.putInt(n + 52, n2);
                this.dirBuffer.putInt(n + 60, n2);
            }
            this.dirBuffer.put(n + 4, (byte)NfaFileheader.setAttrs(file));
            n += 64;
        }
    }

    private String makeFilename() {
        String string;
        try {
            string = this.file.getAbsolutePath();
            int n = this.driveNames[this.driveNumber].length();
            if (this.driveNames[this.driveNumber].endsWith(File.separator)) {
                --n;
            }
            if (n > string.length()) {
                string = this.driveNames[this.driveNumber] + "_**UNKNOWN**";
            }
            string = n == string.length() ? "" : string.substring(n).replace(File.separator, "_");
        }
        catch (Exception exception) {
            string = this.driveNames[this.driveNumber] + "_**UNKNOWN**";
        }
        if (string.startsWith("_") && string.length() > 1) {
            string = string.substring(1);
        }
        return string;
    }
}

