/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu;

import smsqmulator.cpu.DisassembledOperand;

public class DisassembledInstruction {
    public final int address;
    public final int opcode;
    public final int num_operands;
    public final String instruction;
    private int size;
    public final DisassembledOperand op1;
    public final DisassembledOperand op2;

    public DisassembledInstruction(int n, int n2, String string) {
        this.address = n;
        this.opcode = n2;
        this.instruction = string;
        this.num_operands = 0;
        this.op1 = null;
        this.op2 = null;
        this.size = 2;
    }

    public DisassembledInstruction(int n, int n2, String string, DisassembledOperand disassembledOperand) {
        this.address = n;
        this.opcode = n2;
        this.instruction = string;
        this.num_operands = 1;
        this.op1 = disassembledOperand;
        this.op2 = null;
        this.size = this.op1.bytes + 2;
    }

    public DisassembledInstruction(int n, int n2, String string, DisassembledOperand disassembledOperand, DisassembledOperand disassembledOperand2) {
        this.address = n;
        this.opcode = n2;
        this.instruction = string;
        this.num_operands = 2;
        this.op1 = disassembledOperand;
        this.op2 = disassembledOperand2;
        this.size = this.op1.bytes + 2 + this.op2.bytes;
    }

    public int size() {
        return this.size;
    }

    public void shortFormat(StringBuilder stringBuilder) {
        stringBuilder.append(String.format("%08x   ", this.address));
        stringBuilder.append(this.instruction);
        switch (this.num_operands) {
            case 1: {
                for (int i = this.instruction.length(); i < 9; ++i) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.op1.operand);
                break;
            }
            case 2: {
                for (int i = this.instruction.length(); i < 9; ++i) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.op1.operand).append(",").append(this.op2.operand);
                break;
            }
        }
    }

    public void formatInstruction(StringBuilder stringBuilder) {
        stringBuilder.append(String.format("%08x   %04x", this.address, this.opcode));
        switch (this.num_operands) {
            case 0: {
                stringBuilder.append("                    ").append(this.instruction);
                break;
            }
            case 1: {
                if (this.op1.bytes == 2) {
                    stringBuilder.append(String.format(" %04x               ", this.op1.memory_read));
                } else if (this.op1.bytes == 4) {
                    stringBuilder.append(String.format(" %08x           ", this.op1.memory_read));
                } else {
                    stringBuilder.append("                    ");
                }
                stringBuilder.append(this.instruction);
                for (int i = this.instruction.length(); i < 9; ++i) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.op1.operand);
                break;
            }
            case 2: {
                int n = 0;
                if (this.op1.bytes == 2) {
                    stringBuilder.append(String.format(" %04x", this.op1.memory_read));
                    n += 5;
                } else if (this.op1.bytes == 4) {
                    stringBuilder.append(String.format(" %08x", this.op1.memory_read));
                    n += 9;
                }
                if (this.op2.bytes == 2) {
                    stringBuilder.append(String.format(" %04x", this.op2.memory_read));
                    n += 5;
                } else if (this.op2.bytes == 4) {
                    stringBuilder.append(String.format(" %08x", this.op2.memory_read));
                    n += 9;
                }
                while (n < 21) {
                    stringBuilder.append(" ");
                    ++n;
                }
                stringBuilder.append(this.instruction);
                for (int i = this.instruction.length(); i < 9; ++i) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.op1.operand).append(",").append(this.op2.operand);
                break;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        this.formatInstruction(stringBuilder);
        return stringBuilder.toString();
    }
}

