/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu;

import inifile.IniFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.Random;
import java.util.TooManyListenersException;
import smsqmulator.ExternalInterruptHandler;
import smsqmulator.Helper;
import smsqmulator.Localization;
import smsqmulator.Monitor;
import smsqmulator.Screen;
import smsqmulator.TrapDispatcher;
import smsqmulator.Types;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.JavaComm;
import smsqmulator.cpu.Size;
import smsqmulator.cpu.instructions.ABCD;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_An;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_AnPlus;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_Dn;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_I;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_L;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_W;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_d16PC;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_d8AnXn;
import smsqmulator.cpu.instructions.ADD2Dn.ADD_d8PCXn;
import smsqmulator.cpu.instructions.ADD2EA.ADD_AnContent;
import smsqmulator.cpu.instructions.ADD2EA.ADD_MinusAn;
import smsqmulator.cpu.instructions.ADD2EA.ADD_d16An;
import smsqmulator.cpu.instructions.ADDI;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_An;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_AnPlus;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_AnPtr;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_Dn;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_L;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_MinusAn;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_W;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_d16An;
import smsqmulator.cpu.instructions.ADDQ.ADDQ_d8AnXn;
import smsqmulator.cpu.instructions.ADDXmem;
import smsqmulator.cpu.instructions.ADDXreg;
import smsqmulator.cpu.instructions.ANDI;
import smsqmulator.cpu.instructions.ANDI_CCR;
import smsqmulator.cpu.instructions.ANDI_SR;
import smsqmulator.cpu.instructions.ANDmem;
import smsqmulator.cpu.instructions.ANDreg;
import smsqmulator.cpu.instructions.ASL.ASLimm;
import smsqmulator.cpu.instructions.ASL.ASLmem;
import smsqmulator.cpu.instructions.ASL.ASLreg;
import smsqmulator.cpu.instructions.ASR.ASRimm;
import smsqmulator.cpu.instructions.ASR.ASRmem;
import smsqmulator.cpu.instructions.ASR.ASRreg;
import smsqmulator.cpu.instructions.BCHGimm;
import smsqmulator.cpu.instructions.BCHGreg;
import smsqmulator.cpu.instructions.BCLRimm;
import smsqmulator.cpu.instructions.BCLRreg;
import smsqmulator.cpu.instructions.BRA;
import smsqmulator.cpu.instructions.BSETimm;
import smsqmulator.cpu.instructions.BSETreg;
import smsqmulator.cpu.instructions.BSR;
import smsqmulator.cpu.instructions.BTST.BTST_AnContent;
import smsqmulator.cpu.instructions.BTST.BTST_AnPlus;
import smsqmulator.cpu.instructions.BTST.BTST_Dn;
import smsqmulator.cpu.instructions.BTST.BTST_L;
import smsqmulator.cpu.instructions.BTST.BTST_MinusAn;
import smsqmulator.cpu.instructions.BTST.BTST_W;
import smsqmulator.cpu.instructions.BTST.BTST_d16An;
import smsqmulator.cpu.instructions.BTST.BTST_d16PC;
import smsqmulator.cpu.instructions.BTST.BTST_d8AnXn;
import smsqmulator.cpu.instructions.BTST.BTST_d8PCXn;
import smsqmulator.cpu.instructions.Bcc;
import smsqmulator.cpu.instructions.CHK;
import smsqmulator.cpu.instructions.CLR.CLR_AnContent;
import smsqmulator.cpu.instructions.CLR.CLR_AnPlus;
import smsqmulator.cpu.instructions.CLR.CLR_Dn;
import smsqmulator.cpu.instructions.CLR.CLR_L;
import smsqmulator.cpu.instructions.CLR.CLR_MinusAn;
import smsqmulator.cpu.instructions.CLR.CLR_W;
import smsqmulator.cpu.instructions.CLR.CLR_d16An;
import smsqmulator.cpu.instructions.CLR.CLR_d8AnXn;
import smsqmulator.cpu.instructions.CMP.CMPM;
import smsqmulator.cpu.instructions.CMP.CMP_An;
import smsqmulator.cpu.instructions.CMP.CMP_AnContent;
import smsqmulator.cpu.instructions.CMP.CMP_AnPlus;
import smsqmulator.cpu.instructions.CMP.CMP_Dn;
import smsqmulator.cpu.instructions.CMP.CMP_I;
import smsqmulator.cpu.instructions.CMP.CMP_L;
import smsqmulator.cpu.instructions.CMP.CMP_MinusAn;
import smsqmulator.cpu.instructions.CMP.CMP_W;
import smsqmulator.cpu.instructions.CMP.CMP_d16An;
import smsqmulator.cpu.instructions.CMP.CMP_d16PC;
import smsqmulator.cpu.instructions.CMP.CMP_d8AnXn;
import smsqmulator.cpu.instructions.CMP.CMP_d8PCXn;
import smsqmulator.cpu.instructions.CMPI.CMPI_AnContent;
import smsqmulator.cpu.instructions.CMPI.CMPI_AnPlus;
import smsqmulator.cpu.instructions.CMPI.CMPI_Dn;
import smsqmulator.cpu.instructions.CMPI.CMPI_L;
import smsqmulator.cpu.instructions.CMPI.CMPI_MinusAn;
import smsqmulator.cpu.instructions.CMPI.CMPI_W;
import smsqmulator.cpu.instructions.CMPI.CMPI_d16An;
import smsqmulator.cpu.instructions.CMPI.CMPI_d8AnXn;
import smsqmulator.cpu.instructions.DBcc;
import smsqmulator.cpu.instructions.DIVSW;
import smsqmulator.cpu.instructions.DIVUW;
import smsqmulator.cpu.instructions.EOR;
import smsqmulator.cpu.instructions.EORI;
import smsqmulator.cpu.instructions.EORI_CCR;
import smsqmulator.cpu.instructions.EORI_SR;
import smsqmulator.cpu.instructions.EXG;
import smsqmulator.cpu.instructions.EXT;
import smsqmulator.cpu.instructions.ILLEGAL;
import smsqmulator.cpu.instructions.ILLEGALQmon;
import smsqmulator.cpu.instructions.JMP.JMP1;
import smsqmulator.cpu.instructions.JMP.JMP2;
import smsqmulator.cpu.instructions.JMP.JMP3;
import smsqmulator.cpu.instructions.JMP.JMP4;
import smsqmulator.cpu.instructions.JMP.JMP5;
import smsqmulator.cpu.instructions.JMP.JMP6;
import smsqmulator.cpu.instructions.JMP.JMP7;
import smsqmulator.cpu.instructions.JSR.JSR1;
import smsqmulator.cpu.instructions.JSR.JSR2;
import smsqmulator.cpu.instructions.JSR.JSR3;
import smsqmulator.cpu.instructions.JSR.JSR4;
import smsqmulator.cpu.instructions.JSR.JSR5;
import smsqmulator.cpu.instructions.JSR.JSR6;
import smsqmulator.cpu.instructions.JSR.JSR7;
import smsqmulator.cpu.instructions.LEA.LEA_An;
import smsqmulator.cpu.instructions.LEA.LEA_L;
import smsqmulator.cpu.instructions.LEA.LEA_W;
import smsqmulator.cpu.instructions.LEA.LEA_d16An;
import smsqmulator.cpu.instructions.LEA.LEA_d16PC;
import smsqmulator.cpu.instructions.LEA.LEA_d8AnXn;
import smsqmulator.cpu.instructions.LEA.LEA_d8PCXn;
import smsqmulator.cpu.instructions.LINK;
import smsqmulator.cpu.instructions.LSL.LSLimm;
import smsqmulator.cpu.instructions.LSL.LSLmem;
import smsqmulator.cpu.instructions.LSL.LSLreg;
import smsqmulator.cpu.instructions.LSR.LSRimm;
import smsqmulator.cpu.instructions.LSR.LSRmem;
import smsqmulator.cpu.instructions.LSR.LSRreg;
import smsqmulator.cpu.instructions.MOVE.MOVEAn1;
import smsqmulator.cpu.instructions.MOVE.MOVEAn2;
import smsqmulator.cpu.instructions.MOVE.MOVEAn2bis;
import smsqmulator.cpu.instructions.MOVE.MOVEAn3;
import smsqmulator.cpu.instructions.MOVE.MOVEAn4;
import smsqmulator.cpu.instructions.MOVE.MOVEAn5;
import smsqmulator.cpu.instructions.MOVE.MOVEAn6;
import smsqmulator.cpu.instructions.MOVE.MOVEAn7;
import smsqmulator.cpu.instructions.MOVE.MOVEAn8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnC1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnC2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnC3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnC4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnC5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnC6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnC7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnC8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnD1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnD2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnD3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnD4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnD5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnD6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnD7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnD8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnI1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnI2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnI3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnI4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnI5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnI6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnI7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnI8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnL1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnL2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnL3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnL4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnL5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnL6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnL7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnL8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnM1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnM2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnM3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnM4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnM5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnM6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnM7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnM8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnP1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnP2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnP3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnP4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnP5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnP6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnP7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnP8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnT1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnT2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnT3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnT4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnT5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnT6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnT7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnT8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnW1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnW2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnW3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnW4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnW5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnW6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnW7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnW8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnX1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnX2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnX3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnX4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnX5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnX6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnX7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnX8;
import smsqmulator.cpu.instructions.MOVE.MOVEAnY1;
import smsqmulator.cpu.instructions.MOVE.MOVEAnY2;
import smsqmulator.cpu.instructions.MOVE.MOVEAnY3;
import smsqmulator.cpu.instructions.MOVE.MOVEAnY4;
import smsqmulator.cpu.instructions.MOVE.MOVEAnY5;
import smsqmulator.cpu.instructions.MOVE.MOVEAnY6;
import smsqmulator.cpu.instructions.MOVE.MOVEAnY7;
import smsqmulator.cpu.instructions.MOVE.MOVEAnY8;
import smsqmulator.cpu.instructions.MOVE.MOVEDn1;
import smsqmulator.cpu.instructions.MOVE.MOVEDn2;
import smsqmulator.cpu.instructions.MOVE.MOVEDn3;
import smsqmulator.cpu.instructions.MOVE.MOVEDn4;
import smsqmulator.cpu.instructions.MOVE.MOVEDn5;
import smsqmulator.cpu.instructions.MOVE.MOVEDn6;
import smsqmulator.cpu.instructions.MOVE.MOVEDn7;
import smsqmulator.cpu.instructions.MOVE.MOVEDn8;
import smsqmulator.cpu.instructions.MOVEA.MOVEA1;
import smsqmulator.cpu.instructions.MOVEA.MOVEA10;
import smsqmulator.cpu.instructions.MOVEA.MOVEA11;
import smsqmulator.cpu.instructions.MOVEA.MOVEA12;
import smsqmulator.cpu.instructions.MOVEA.MOVEA2;
import smsqmulator.cpu.instructions.MOVEA.MOVEA3;
import smsqmulator.cpu.instructions.MOVEA.MOVEA4;
import smsqmulator.cpu.instructions.MOVEA.MOVEA5;
import smsqmulator.cpu.instructions.MOVEA.MOVEA6;
import smsqmulator.cpu.instructions.MOVEA.MOVEA7;
import smsqmulator.cpu.instructions.MOVEA.MOVEA8;
import smsqmulator.cpu.instructions.MOVEA.MOVEA9;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Mem1;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Mem2;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Mem3;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Mem4;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Mem5;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Mem6;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Reg1;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Reg2;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Reg3;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Reg4;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Reg5;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Reg6;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Reg7;
import smsqmulator.cpu.instructions.MOVEM.MOVEM2Reg8;
import smsqmulator.cpu.instructions.MOVEPm2r;
import smsqmulator.cpu.instructions.MOVEPr2m;
import smsqmulator.cpu.instructions.MOVEQ;
import smsqmulator.cpu.instructions.MOVE_FROM_CCR;
import smsqmulator.cpu.instructions.MOVE_FROM_SR;
import smsqmulator.cpu.instructions.MOVE_TO_CCR;
import smsqmulator.cpu.instructions.MOVE_TO_SR;
import smsqmulator.cpu.instructions.MOVE_USP;
import smsqmulator.cpu.instructions.MULSW;
import smsqmulator.cpu.instructions.MULUW;
import smsqmulator.cpu.instructions.NBCD;
import smsqmulator.cpu.instructions.NEG;
import smsqmulator.cpu.instructions.NEGX;
import smsqmulator.cpu.instructions.NOP;
import smsqmulator.cpu.instructions.NOT;
import smsqmulator.cpu.instructions.NULL;
import smsqmulator.cpu.instructions.ORI;
import smsqmulator.cpu.instructions.ORI_CCR;
import smsqmulator.cpu.instructions.ORI_SR;
import smsqmulator.cpu.instructions.ORmem;
import smsqmulator.cpu.instructions.ORreg;
import smsqmulator.cpu.instructions.PEA;
import smsqmulator.cpu.instructions.RESET;
import smsqmulator.cpu.instructions.ROL.ROLimm;
import smsqmulator.cpu.instructions.ROL.ROLmem;
import smsqmulator.cpu.instructions.ROL.ROLreg;
import smsqmulator.cpu.instructions.ROR.RORimm;
import smsqmulator.cpu.instructions.ROR.RORmem;
import smsqmulator.cpu.instructions.ROR.RORreg;
import smsqmulator.cpu.instructions.ROX.ROXLimm;
import smsqmulator.cpu.instructions.ROX.ROXLmem;
import smsqmulator.cpu.instructions.ROX.ROXLreg;
import smsqmulator.cpu.instructions.ROX.ROXRimm;
import smsqmulator.cpu.instructions.ROX.ROXRmem;
import smsqmulator.cpu.instructions.ROX.ROXRreg;
import smsqmulator.cpu.instructions.RTE;
import smsqmulator.cpu.instructions.RTR;
import smsqmulator.cpu.instructions.RTS;
import smsqmulator.cpu.instructions.SBCD;
import smsqmulator.cpu.instructions.SCC;
import smsqmulator.cpu.instructions.STOP;
import smsqmulator.cpu.instructions.SUB2Dn.SUB_An;
import smsqmulator.cpu.instructions.SUB2Dn.SUB_AnPlus;
import smsqmulator.cpu.instructions.SUB2Dn.SUB_Dn;
import smsqmulator.cpu.instructions.SUB2Dn.SUB_I;
import smsqmulator.cpu.instructions.SUB2Dn.SUB_MinusAn;
import smsqmulator.cpu.instructions.SUB2Dn.SUB_d16PC;
import smsqmulator.cpu.instructions.SUB2Dn.SUB_d8AnXn;
import smsqmulator.cpu.instructions.SUB2Dn.SUB_d8PCXn;
import smsqmulator.cpu.instructions.SUB2EA.SUB_AnContent;
import smsqmulator.cpu.instructions.SUB2EA.SUB_L;
import smsqmulator.cpu.instructions.SUB2EA.SUB_W;
import smsqmulator.cpu.instructions.SUB2EA.SUB_d16An;
import smsqmulator.cpu.instructions.SUBI;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_An;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_AnPlus;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_AnPtr;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_Dn;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_L;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_MinusAn;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_W;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_d16An;
import smsqmulator.cpu.instructions.SUBQ.SUBQ_d8AnXn;
import smsqmulator.cpu.instructions.SUBXmem;
import smsqmulator.cpu.instructions.SUBXreg;
import smsqmulator.cpu.instructions.SWAP;
import smsqmulator.cpu.instructions.TAS;
import smsqmulator.cpu.instructions.TRAP;
import smsqmulator.cpu.instructions.TRAPV;
import smsqmulator.cpu.instructions.TST.TST_AnContent;
import smsqmulator.cpu.instructions.TST.TST_AnPlus;
import smsqmulator.cpu.instructions.TST.TST_Dn;
import smsqmulator.cpu.instructions.TST.TST_L;
import smsqmulator.cpu.instructions.TST.TST_MinusAn;
import smsqmulator.cpu.instructions.TST.TST_W;
import smsqmulator.cpu.instructions.TST.TST_d16An;
import smsqmulator.cpu.instructions.TST.TST_d8AnXn;
import smsqmulator.cpu.instructions.UNLK;

public class MC68000Cpu {
    protected ExternalInterruptHandler[] externalInterruptHandlersList = new ExternalInterruptHandler[10];
    protected boolean[] interruptSignaled = new boolean[10];
    protected int[] interruptLevel = new int[10];
    protected int nbrOfInterruptHandlers = 0;
    protected boolean newInterruptGenerated = false;
    public TrapDispatcher trapDispatcher;
    protected final short[] mainMemory;
    public static final int cutOff = 0xFFFFFFF;
    protected int screenStart = 0;
    protected int screenStop = 0;
    public Screen screen = null;
    public int ramSize;
    protected int totRamSize;
    protected int totRamSizeForLong;
    protected int totRamSizeForWord;
    protected int totMemSize;
    private String romFile;
    private IniFile iniFile;
    protected Random randomNumber = new Random();
    private boolean romLoadedOK = false;
    private boolean traceFlag;
    public final int[] data_regs;
    public final int[] addr_regs;
    public int pc_reg;
    public int reg_sr;
    public int reg_usp;
    public int reg_ssp;
    protected int currentInstructionAddress = 0;
    protected StringBuilder disasmBuffer;
    protected final Instruction[] i_table;
    protected ExternalInterruptHandler ieh = null;
    public static final int INTERRUPT_FLAGS_MASK = 1792;
    public static final int SUPERVISOR_FLAG = 8192;
    public static final int TRACE_FLAG = 32768;
    public int stopNow;
    private static final int TRACEBACK = 50;
    public int[] pcs = new int[50];

    public MC68000Cpu(int n, int n2, int n3) {
        this.data_regs = new int[8];
        this.addr_regs = new int[8];
        if ((n & 1) == 1) {
            ++n;
        }
        this.disasmBuffer = new StringBuilder(64);
        this.i_table = new Instruction[65536];
        this.loadInstructionSet();
        this.ramSize = n;
        this.screenStart = this.ramSize + 78 + 10;
        this.screenStop = this.totRamSize = this.screenStart + n3;
        this.totRamSizeForLong = this.totRamSize - 3;
        this.totRamSizeForWord = this.totRamSize - 1;
        this.totMemSize = this.totRamSize + n2;
        this.mainMemory = new short[this.totMemSize / 2];
    }

    public MC68000Cpu(int n, IniFile iniFile, int n2, int n3) {
        this(n, n2, n3);
        this.iniFile = iniFile;
    }

    public MC68000Cpu(int n, Screen screen, IniFile iniFile, int n2) {
        this(n, iniFile, n2, screen.getScreenSizeInBytes());
        this.screen = screen;
        if (screen.isQLScreen()) {
            this.screenStart = 131072;
            this.screenStop = 163838;
        }
        this.screen.setVramBase(this.screenStart);
    }

    public final int execute() {
        int n;
        if (this.newInterruptGenerated) {
            n = this.reg_sr;
            if ((this.reg_sr & 0x2000) == 0) {
                this.reg_sr |= 0x2000;
                this.reg_usp = this.addr_regs[7];
                this.addr_regs[7] = this.reg_ssp;
            }
            this.addr_regs[7] = this.addr_regs[7] - 6;
            int n2 = this.addr_regs[7] / 2;
            this.mainMemory[n2] = (short)n;
            this.mainMemory[n2 + 1] = (short)(this.pc_reg * 2 >> 16 & 0xFFFF);
            this.mainMemory[n2 + 2] = (short)(this.pc_reg * 2 & 0xFFFF);
            this.reg_sr &= 0xFFFF7FFF;
            this.traceFlag = false;
            n = this.readMemoryLong(104);
            if (n == 0 && (n = this.readMemoryLong(60)) == 0) {
                throw new IllegalArgumentException("Interrupt vector not set for uninitialised interrupt vector while trapping uninitialised vector 26");
            }
            this.pc_reg = n / 2;
            this.reg_sr &= 0xFFFFF8FF;
            this.reg_sr |= 0x200;
            this.newInterruptGenerated = false;
        }
        for (n = 0; n < 49; ++n) {
            this.pcs[n] = this.pcs[n + 1];
        }
        this.pcs[49] = this.pc_reg;
        this.currentInstructionAddress = this.pc_reg;
        n = this.mainMemory[this.pc_reg] & 0xFFFF;
        ++this.pc_reg;
        this.i_table[n].execute(n, this);
        if (this.traceFlag && n != 20083) {
            this.raiseException(9);
        }
        return this.stopNow;
    }

    public final void executeContinuous() {
        int n = 20083;
        while (true) {
            int n2;
            if (this.newInterruptGenerated) {
                n2 = this.reg_sr;
                if ((this.reg_sr & 0x2000) == 0) {
                    this.reg_sr |= 0x2000;
                    this.reg_usp = this.addr_regs[7];
                    this.addr_regs[7] = this.reg_ssp;
                }
                this.addr_regs[7] = this.addr_regs[7] - 6;
                int n3 = this.addr_regs[7] / 2;
                this.mainMemory[n3] = (short)n2;
                this.pc_reg *= 2;
                this.mainMemory[n3 + 1] = (short)(this.pc_reg >> 16 & 0xFFFF);
                this.mainMemory[n3 + 2] = (short)(this.pc_reg & 0xFFFF);
                this.reg_sr &= 0xFFFF7FFF;
                this.traceFlag = false;
                this.pc_reg = this.readMemoryLong(104) / 2;
                if (this.pc_reg == 0) {
                    this.pc_reg = this.readMemoryLong(60) / 2;
                    if (this.pc_reg == 0) {
                        throw new IllegalArgumentException("Interrupt vector not set for uninitialised interrupt vector while trapping uninitialised vector 26");
                    }
                }
                this.reg_sr &= 0xFFFFF8FF;
                this.reg_sr |= 0x200;
                this.newInterruptGenerated = false;
            }
            n2 = this.mainMemory[this.pc_reg] & 0xFFFF;
            ++this.pc_reg;
            Instruction instruction = this.i_table[n2];
            instruction.execute(n2, this);
            if (!this.traceFlag || n2 == n) continue;
            this.raiseException(9);
        }
    }

    public void generateInterrupt() {
        if ((this.reg_sr & 0x700) < 512) {
            this.newInterruptGenerated = true;
        }
    }

    public void registerInterruptHandler(ExternalInterruptHandler externalInterruptHandler) {
        this.ieh = externalInterruptHandler;
    }

    public int registerInterruptHandler(ExternalInterruptHandler externalInterruptHandler, int n) throws IllegalArgumentException, InputMismatchException, TooManyListenersException {
        if (this.nbrOfInterruptHandlers >= this.externalInterruptHandlersList.length) {
            throw new TooManyListenersException("Too manu Exception handlers!");
        }
        for (int i = 0; i < this.nbrOfInterruptHandlers; ++i) {
            if (this.externalInterruptHandlersList[i].getClass() != externalInterruptHandler.getClass()) continue;
            throw new InputMismatchException("An interrupt handler of this class is already registered with this  CPU");
        }
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Interrupt level must be between 0 & 7 inclusive!");
        }
        this.externalInterruptHandlersList[this.nbrOfInterruptHandlers] = externalInterruptHandler;
        this.interruptLevel[this.nbrOfInterruptHandlers] = n;
        ++this.nbrOfInterruptHandlers;
        return this.nbrOfInterruptHandlers - 1;
    }

    public synchronized void generateInterrupt(int n) {
        if (n > -1 && n < this.nbrOfInterruptHandlers) {
            this.interruptSignaled[n] = true;
            this.newInterruptGenerated = true;
        }
    }

    public void clearInterruptHandlers() {
        this.ieh = null;
        for (int i = 0; i < this.nbrOfInterruptHandlers; ++i) {
            if (this.externalInterruptHandlersList[i] == null) continue;
            this.externalInterruptHandlersList[i].removeHandler();
            this.externalInterruptHandlersList[i] = null;
            this.interruptSignaled[i] = false;
            this.interruptLevel[i] = 0;
        }
        this.nbrOfInterruptHandlers = 0;
        this.ieh = null;
    }

    public final int readMemoryByte(int n) {
        if ((n &= 0xFFFFFFF) > this.totMemSize) {
            return 0;
        }
        if ((n & 1) != 0) {
            return this.mainMemory[n / 2] & 0xFF;
        }
        return this.mainMemory[n / 2] >>> 8 & 0xFF;
    }

    public final int readMemoryByteSigned(int n) {
        if ((n &= 0xFFFFFFF) > this.totMemSize) {
            return 0;
        }
        int n2 = this.mainMemory[n / 2];
        if ((n & 1) == 0) {
            n2 >>>= 8;
        }
        if (((n2 &= 0xFF) & 0x80) != 0) {
            return n2 | 0xFFFFFF00;
        }
        return n2;
    }

    public final int readMemoryWord(int n) {
        if ((n &= 0xFFFFFFF) > this.totMemSize) {
            return 0;
        }
        return this.mainMemory[n / 2] & 0xFFFF;
    }

    public final int readMemoryWordSigned(int n) {
        if ((n &= 0xFFFFFFF) > this.totMemSize) {
            return 0;
        }
        return this.mainMemory[n / 2];
    }

    public final int readMemoryWordPC() {
        return this.mainMemory[this.pc_reg] & 0xFFFF;
    }

    public final int readMemoryWordPCInc() {
        return this.mainMemory[this.pc_reg++] & 0xFFFF;
    }

    public final int readMemoryWordPCSigned() {
        return this.mainMemory[this.pc_reg];
    }

    public final int readMemoryWordPCSignedInc() {
        return this.mainMemory[this.pc_reg++];
    }

    public final short readMemoryShort(int n) {
        if ((n &= 0xFFFFFFF) > this.totMemSize) {
            return 0;
        }
        return this.mainMemory[n / 2];
    }

    public final int readMemoryLong(int n) {
        if ((n &= 0xFFFFFFF) > this.totMemSize - 2) {
            return 0;
        }
        return this.mainMemory[n /= 2] << 16 | this.mainMemory[n + 1] & 0xFFFF;
    }

    public final int readMemoryLongPC() {
        return this.mainMemory[this.pc_reg] << 16 | this.mainMemory[this.pc_reg + 1] & 0xFFFF;
    }

    public final int readMemoryLongPCinc() {
        int n = (this.mainMemory[this.pc_reg++] & 0xFFFF) << 16;
        return n | this.mainMemory[this.pc_reg++] & 0xFFFF;
    }

    public void writeMemoryByte(int n, int n2) {
        if ((n &= 0xFFFFFFF) > this.totMemSize) {
            return;
        }
        int n3 = n / 2;
        int n4 = n2;
        short s = this.mainMemory[n3];
        if ((n & 1) != 0) {
            s = (short)(s & 0xFF00);
            n2 &= 0xFF;
        } else {
            s = (short)(s & 0xFF);
            n2 = n2 << 8 & 0xFF00;
        }
        this.mainMemory[n3] = (short)(n2 |= s);
        if (n >= this.screenStart) {
            this.screen.writeByteToScreen(n, n4, n2);
        }
    }

    public void writeMemoryWord(int n, int n2) {
        if ((n &= 0xFFFFFFF) > this.totRamSizeForWord) {
            return;
        }
        this.mainMemory[n / 2] = (short)n2;
        if (n >= this.screenStart) {
            this.screen.writeWordToScreen(n, n2);
        }
    }

    public void writeMemoryShort(int n, short s) {
        if ((n &= 0xFFFFFFF) > this.totRamSizeForWord) {
            return;
        }
        this.mainMemory[n / 2] = s;
        if (n >= this.screenStart) {
            this.screen.writeWordToScreen(n, s);
        }
    }

    public void writeMemoryLong(int n, int n2) {
        if ((n &= 0xFFFFFFF) > this.totRamSizeForLong) {
            return;
        }
        int n3 = n / 2;
        this.mainMemory[n3] = (short)(n2 >>> 16);
        this.mainMemory[n3 + 1] = (short)n2;
        if (n >= this.screenStart) {
            this.screen.writeLongToScreen(n, n2);
        }
    }

    private void debugMem(int n) {
        if ((n & 1) != 0) {
            // empty if block
        }
    }

    public int memBoundsOK(int n, int n2) {
        int n3 = n & 0xFFFFFFF;
        if (n >= this.screenStart && n < this.screenStop) {
            return -1;
        }
        if (n + 64 > this.totMemSize) {
            return -1;
        }
        return n / 2;
    }

    public void reset() {
        this.reg_sr = 9984;
        this.pc_reg = 0;
        Arrays.fill(this.addr_regs, 0);
        Arrays.fill(this.data_regs, 0);
        this.reg_ssp = 0;
        this.reg_usp = 0;
        this.stopNow = 0;
    }

    public void raiseException(int n) {
        int n2 = (n & 0xFF) << 2;
        if (n > 32 && n < 36) {
            this.trapDispatcher.resetCounter();
        }
        int n3 = this.reg_sr;
        if ((this.reg_sr & 0x2000) == 0) {
            this.reg_sr |= 0x2000;
            this.reg_usp = this.addr_regs[7];
            this.addr_regs[7] = this.reg_ssp;
        }
        this.addr_regs[7] = this.addr_regs[7] - 4;
        this.writeMemoryLong(this.addr_regs[7], this.pc_reg * 2);
        this.addr_regs[7] = this.addr_regs[7] - 2;
        this.writeMemoryWord(this.addr_regs[7], n3);
        this.reg_sr &= 0xFFFF7FFF;
        this.traceFlag = false;
        int n4 = this.readMemoryLong(n2);
        if (n4 == 0 && (n4 = this.readMemoryLong(60)) == 0) {
            throw new IllegalArgumentException("Interrupt vector not set for uninitialised interrupt vector while trapping uninitialised vector " + n);
        }
        this.pc_reg = n4 / 2;
    }

    public void raiseSRException() {
        int n = 32;
        int n2 = this.reg_sr;
        if ((this.reg_sr & 0x2000) == 0) {
            this.reg_sr |= 0x2000;
            this.reg_usp = this.addr_regs[7];
            this.addr_regs[7] = this.reg_ssp;
        }
        this.addr_regs[7] = this.addr_regs[7] - 4;
        this.writeMemoryLong(this.addr_regs[7], this.currentInstructionAddress);
        this.addr_regs[7] = this.addr_regs[7] - 2;
        this.writeMemoryWord(this.addr_regs[7], n2);
        int n3 = this.readMemoryLong(n);
        if (n3 == 0 && (n3 = this.readMemoryLong(60)) == 0) {
            throw new IllegalArgumentException("Interrupt vector not set for uninitialised interrupt vector while trapping uninitialised vector 8");
        }
        this.pc_reg = n3 / 2;
        this.traceFlag = (this.reg_sr & 0x8000) != 0;
    }

    public void setSR(int n) {
        if ((this.reg_sr & 0x2000 ^ n & 0x2000) != 0) {
            if ((n & 0x2000) != 0) {
                this.reg_usp = this.addr_regs[7];
                this.addr_regs[7] = this.reg_ssp;
            } else {
                this.reg_ssp = this.addr_regs[7];
                this.addr_regs[7] = this.reg_usp;
            }
        }
        this.reg_sr = n;
        this.traceFlag = (this.reg_sr & 0x8000) != 0;
    }

    public void testTrace() {
        this.traceFlag = (this.reg_sr & 0x8000) != 0;
    }

    public static final int signExtendByte(int n) {
        if ((n & 0x80) != 0) {
            return n | 0xFFFFFF00;
        }
        return n & 0xFF;
    }

    public static final int signExtendWord(int n) {
        if ((n & 0x8000) != 0) {
            return n | 0xFFFF0000;
        }
        return n & 0xFFFF;
    }

    public boolean isSupervisorMode() {
        return (this.reg_sr & 0x2000) != 0;
    }

    public final int getDisplacement() {
        int n;
        int n2 = this.readMemoryWordPCSignedInc();
        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
        if ((n2 & 0x8000) != 0) {
            int n4 = this.addr_regs[n2 >> 12 & 7];
            if ((n2 & 0x800) == 0) {
                return n + ((n4 & 0x8000) != 0 ? n4 | 0xFFFF0000 : n4 & 0xFFFF);
            }
            return n + n4;
        }
        int n5 = this.data_regs[n2 >> 12 & 7];
        if ((n2 & 0x800) == 0) {
            return n + ((n5 & 0x8000) != 0 ? n5 | 0xFFFF0000 : n5 & 0xFFFF);
        }
        return n + n5;
    }

    private void loadInstructionSet() {
        new JMP1().register(this);
        new JMP2().register(this);
        new JMP3().register(this);
        new JMP4().register(this);
        new JMP5().register(this);
        new JMP6().register(this);
        new JMP7().register(this);
        new JSR1().register(this);
        new JSR2().register(this);
        new JSR3().register(this);
        new JSR4().register(this);
        new JSR5().register(this);
        new JSR6().register(this);
        new JSR7().register(this);
        new JavaComm().register(this);
        new ILLEGALQmon().register(this);
        new ABCD().register(this);
        new ADD_Dn().register(this);
        new ADD_An().register(this);
        new smsqmulator.cpu.instructions.ADD2Dn.ADD_AnContent().register(this);
        new ADD_AnPlus().register(this);
        new smsqmulator.cpu.instructions.ADD2Dn.ADD_MinusAn().register(this);
        new smsqmulator.cpu.instructions.ADD2Dn.ADD_d16An().register(this);
        new ADD_d8AnXn().register(this);
        new ADD_W().register(this);
        new ADD_L().register(this);
        new ADD_I().register(this);
        new ADD_d16PC().register(this);
        new ADD_d8PCXn().register(this);
        new ADD_AnContent().register(this);
        new smsqmulator.cpu.instructions.ADD2EA.ADD_AnPlus().register(this);
        new ADD_MinusAn().register(this);
        new ADD_d16An().register(this);
        new smsqmulator.cpu.instructions.ADD2EA.ADD_d8AnXn().register(this);
        new smsqmulator.cpu.instructions.ADD2EA.ADD_W().register(this);
        new smsqmulator.cpu.instructions.ADD2EA.ADD_L().register(this);
        new ADDQ_Dn().register(this);
        new ADDQ_An().register(this);
        new ADDQ_AnPtr().register(this);
        new ADDQ_AnPlus().register(this);
        new ADDQ_MinusAn().register(this);
        new ADDQ_d16An().register(this);
        new ADDQ_d8AnXn().register(this);
        new ADDQ_W().register(this);
        new ADDQ_L().register(this);
        new ADDI().register(this);
        new ADDXreg().register(this);
        new ADDXmem().register(this);
        new ANDreg().register(this);
        new ANDmem().register(this);
        new ANDI().register(this);
        new ANDI_SR().register(this);
        new ANDI_CCR().register(this);
        new ASLreg().register(this);
        new ASLimm().register(this);
        new ASLmem().register(this);
        new ASRimm().register(this);
        new ASRreg().register(this);
        new ASRmem().register(this);
        new Bcc().register(this);
        new BRA().register(this);
        new BSR().register(this);
        new BCHGimm().register(this);
        new BCHGreg().register(this);
        new BCLRimm().register(this);
        new BCLRreg().register(this);
        new BSETimm().register(this);
        new BSETreg().register(this);
        new BTST_Dn().register(this);
        new BTST_AnContent().register(this);
        new BTST_AnPlus().register(this);
        new BTST_MinusAn().register(this);
        new BTST_d16An().register(this);
        new BTST_d8AnXn().register(this);
        new BTST_W().register(this);
        new BTST_L().register(this);
        new BTST_d16PC().register(this);
        new BTST_d8PCXn().register(this);
        new CHK().register(this);
        new CLR_Dn().register(this);
        new CLR_AnContent().register(this);
        new CLR_AnPlus().register(this);
        new CLR_MinusAn().register(this);
        new CLR_d16An().register(this);
        new CLR_d8AnXn().register(this);
        new CLR_W().register(this);
        new CLR_L().register(this);
        new CMP_Dn().register(this);
        new CMP_An().register(this);
        new CMP_AnContent().register(this);
        new CMP_AnPlus().register(this);
        new CMP_MinusAn().register(this);
        new CMP_d16An().register(this);
        new CMP_d8AnXn().register(this);
        new CMP_W().register(this);
        new CMP_L().register(this);
        new CMP_I().register(this);
        new CMP_d16PC().register(this);
        new CMP_d8PCXn().register(this);
        new CMPI_Dn().register(this);
        new CMPI_AnContent().register(this);
        new CMPI_AnPlus().register(this);
        new CMPI_MinusAn().register(this);
        new CMPI_d16An().register(this);
        new CMPI_d8AnXn().register(this);
        new CMPI_W().register(this);
        new CMPI_L().register(this);
        new CMPM().register(this);
        new DBcc().register(this);
        new DIVSW().register(this);
        new DIVUW().register(this);
        new EOR().register(this);
        new EORI().register(this);
        new EORI_CCR().register(this);
        new EORI_SR().register(this);
        new EXG().register(this);
        new EXT().register(this);
        new ILLEGAL().register(this);
        new LEA_An().register(this);
        new LEA_d16An().register(this);
        new LEA_d8AnXn().register(this);
        new LEA_W().register(this);
        new LEA_L().register(this);
        new LEA_d16PC().register(this);
        new LEA_d8PCXn().register(this);
        new LINK().register(this);
        new LSLreg().register(this);
        new LSLimm().register(this);
        new LSLmem().register(this);
        new LSRreg().register(this);
        new LSRimm().register(this);
        new LSRmem().register(this);
        new MOVEDn1().register(this);
        new MOVEDn2().register(this);
        new MOVEDn3().register(this);
        new MOVEDn4().register(this);
        new MOVEDn5().register(this);
        new MOVEDn6().register(this);
        new MOVEDn7().register(this);
        new MOVEDn8().register(this);
        new MOVEAn1().register(this);
        new MOVEAn2bis().register(this);
        new MOVEAn2().register(this);
        new MOVEAn3().register(this);
        new MOVEAn4().register(this);
        new MOVEAn5().register(this);
        new MOVEAn6().register(this);
        new MOVEAn7().register(this);
        new MOVEAn8().register(this);
        new MOVEAnC1().register(this);
        new MOVEAnC2().register(this);
        new MOVEAnC3().register(this);
        new MOVEAnC4().register(this);
        new MOVEAnC5().register(this);
        new MOVEAnC6().register(this);
        new MOVEAnC7().register(this);
        new MOVEAnC8().register(this);
        new MOVEAnP1().register(this);
        new MOVEAnP2().register(this);
        new MOVEAnP3().register(this);
        new MOVEAnP4().register(this);
        new MOVEAnP5().register(this);
        new MOVEAnP6().register(this);
        new MOVEAnP7().register(this);
        new MOVEAnP8().register(this);
        new MOVEAnM1().register(this);
        new MOVEAnM2().register(this);
        new MOVEAnM3().register(this);
        new MOVEAnM4().register(this);
        new MOVEAnM5().register(this);
        new MOVEAnM6().register(this);
        new MOVEAnM7().register(this);
        new MOVEAnM8().register(this);
        new MOVEAnD1().register(this);
        new MOVEAnD2().register(this);
        new MOVEAnD3().register(this);
        new MOVEAnD4().register(this);
        new MOVEAnD5().register(this);
        new MOVEAnD6().register(this);
        new MOVEAnD7().register(this);
        new MOVEAnD8().register(this);
        new MOVEAnI1().register(this);
        new MOVEAnI2().register(this);
        new MOVEAnI3().register(this);
        new MOVEAnI4().register(this);
        new MOVEAnI5().register(this);
        new MOVEAnI6().register(this);
        new MOVEAnI7().register(this);
        new MOVEAnI8().register(this);
        new MOVEAnW1().register(this);
        new MOVEAnW2().register(this);
        new MOVEAnW3().register(this);
        new MOVEAnW4().register(this);
        new MOVEAnW5().register(this);
        new MOVEAnW6().register(this);
        new MOVEAnW7().register(this);
        new MOVEAnW8().register(this);
        new MOVEAnL1().register(this);
        new MOVEAnL2().register(this);
        new MOVEAnL3().register(this);
        new MOVEAnL4().register(this);
        new MOVEAnL5().register(this);
        new MOVEAnL6().register(this);
        new MOVEAnL7().register(this);
        new MOVEAnL8().register(this);
        new MOVEAnT1().register(this);
        new MOVEAnT2().register(this);
        new MOVEAnT3().register(this);
        new MOVEAnT4().register(this);
        new MOVEAnT5().register(this);
        new MOVEAnT6().register(this);
        new MOVEAnT7().register(this);
        new MOVEAnT8().register(this);
        new MOVEAnY1().register(this);
        new MOVEAnY2().register(this);
        new MOVEAnY3().register(this);
        new MOVEAnY4().register(this);
        new MOVEAnY5().register(this);
        new MOVEAnY6().register(this);
        new MOVEAnY7().register(this);
        new MOVEAnY8().register(this);
        new MOVEAnX1().register(this);
        new MOVEAnX2().register(this);
        new MOVEAnX3().register(this);
        new MOVEAnX4().register(this);
        new MOVEAnX5().register(this);
        new MOVEAnX6().register(this);
        new MOVEAnX7().register(this);
        new MOVEAnX8().register(this);
        new MOVEA1().register(this);
        new MOVEA2().register(this);
        new MOVEA3().register(this);
        new MOVEA4().register(this);
        new MOVEA5().register(this);
        new MOVEA6().register(this);
        new MOVEA7().register(this);
        new MOVEA8().register(this);
        new MOVEA9().register(this);
        new MOVEA10().register(this);
        new MOVEA11().register(this);
        new MOVEA12().register(this);
        new MOVEM2Mem1().register(this);
        new MOVEM2Mem2().register(this);
        new MOVEM2Mem3().register(this);
        new MOVEM2Mem4().register(this);
        new MOVEM2Mem5().register(this);
        new MOVEM2Mem6().register(this);
        new MOVEM2Reg1().register(this);
        new MOVEM2Reg2().register(this);
        new MOVEM2Reg3().register(this);
        new MOVEM2Reg4().register(this);
        new MOVEM2Reg5().register(this);
        new MOVEM2Reg6().register(this);
        new MOVEM2Reg7().register(this);
        new MOVEM2Reg8().register(this);
        new MOVEQ().register(this);
        new MOVEPr2m().register(this);
        new MOVEPm2r().register(this);
        new MOVE_USP().register(this);
        new MOVE_FROM_CCR().register(this);
        new MOVE_TO_CCR().register(this);
        new MOVE_FROM_SR().register(this);
        new MOVE_TO_SR().register(this);
        new MULSW().register(this);
        new MULUW().register(this);
        new NBCD().register(this);
        new NEG().register(this);
        new NEGX().register(this);
        new NOT().register(this);
        new NOP().register(this);
        new ORreg().register(this);
        new ORmem().register(this);
        new ORI().register(this);
        new ORI_SR().register(this);
        new ORI_CCR().register(this);
        new PEA().register(this);
        new RORreg().register(this);
        new RORimm().register(this);
        new RORmem().register(this);
        new ROLreg().register(this);
        new ROLimm().register(this);
        new ROLmem().register(this);
        new ROXLreg().register(this);
        new ROXLimm().register(this);
        new ROXLmem().register(this);
        new ROXRreg().register(this);
        new ROXRimm().register(this);
        new ROXRmem().register(this);
        new RTS().register(this);
        new RTE().register(this);
        new RTR().register(this);
        new RESET().register(this);
        new SBCD().register(this);
        new SCC().register(this);
        new STOP().register(this);
        new SUB_Dn().register(this);
        new SUB_An().register(this);
        new smsqmulator.cpu.instructions.SUB2Dn.SUB_AnContent().register(this);
        new SUB_AnPlus().register(this);
        new SUB_MinusAn().register(this);
        new smsqmulator.cpu.instructions.SUB2Dn.SUB_d16An().register(this);
        new SUB_d8AnXn().register(this);
        new smsqmulator.cpu.instructions.SUB2Dn.SUB_W().register(this);
        new smsqmulator.cpu.instructions.SUB2Dn.SUB_L().register(this);
        new SUB_I().register(this);
        new SUB_d16PC().register(this);
        new SUB_d8PCXn().register(this);
        new SUB_AnContent().register(this);
        new smsqmulator.cpu.instructions.SUB2EA.SUB_AnPlus().register(this);
        new smsqmulator.cpu.instructions.SUB2EA.SUB_MinusAn().register(this);
        new SUB_d16An().register(this);
        new smsqmulator.cpu.instructions.SUB2EA.SUB_d8AnXn().register(this);
        new SUB_W().register(this);
        new SUB_L().register(this);
        new SUBI().register(this);
        new SUBQ_Dn().register(this);
        new SUBQ_An().register(this);
        new SUBQ_AnPtr().register(this);
        new SUBQ_AnPlus().register(this);
        new SUBQ_MinusAn().register(this);
        new SUBQ_d16An().register(this);
        new SUBQ_d8AnXn().register(this);
        new SUBQ_W().register(this);
        new SUBQ_L().register(this);
        new SUBXmem().register(this);
        new SUBXreg().register(this);
        new SWAP().register(this);
        new TAS().register(this);
        new TRAP().register(this);
        new TRAPV().register(this);
        new TST_Dn().register(this);
        new TST_AnContent().register(this);
        new TST_AnPlus().register(this);
        new TST_MinusAn().register(this);
        new TST_d16An().register(this);
        new TST_d8AnXn().register(this);
        new TST_W().register(this);
        new TST_L().register(this);
        new UNLK().register(this);
        new NULL().register(this.i_table, this);
    }

    public void addInstruction(int n, Instruction instruction) {
        if (this.i_table[n] == null) {
            this.i_table[n] = instruction;
        }
    }

    public DisassembledOperand disassembleSrcEA(int n, int n2, int n3, Size size) {
        return this.disassembleEA(n, n2, n3, size, true);
    }

    public DisassembledOperand disassembleDstEA(int n, int n2, int n3, Size size) {
        return this.disassembleEA(n, n2, n3, size, false);
    }

    protected DisassembledOperand disassembleEA(int n, int n2, int n3, Size size, boolean bl) {
        int n4 = 0;
        int n5 = 0;
        this.disasmBuffer.delete(0, this.disasmBuffer.length());
        block0 : switch (n2) {
            case 0: {
                this.disasmBuffer.append("d").append(n3);
                break;
            }
            case 1: {
                this.disasmBuffer.append("a").append(n3);
                break;
            }
            case 2: {
                this.disasmBuffer.append("(a").append(n3).append(")");
                break;
            }
            case 3: {
                this.disasmBuffer.append("(a").append(n3).append(")+");
                break;
            }
            case 4: {
                this.disasmBuffer.append("-(a").append(n3).append(")");
                break;
            }
            case 5: {
                n5 = this.readMemoryWordSigned(n);
                this.disasmBuffer.append(String.format("$%04x", (short)n5)).append("(a").append(n3).append(")");
                n4 = 2;
                break;
            }
            case 6: {
                n5 = this.readMemoryWord(n);
                int n6 = MC68000Cpu.signExtendByte(n5);
                this.disasmBuffer.append(String.format("$%02x", (byte)n6)).append("(a").append(n3).append(",");
                this.disasmBuffer.append((n5 & 0x8000) != 0 ? "a" : "d").append(n5 >> 12 & 7).append((n5 & 0x800) != 0 ? ".l" : ".w").append(")");
                n4 = 2;
                break;
            }
            case 7: {
                switch (n3) {
                    case 0: {
                        n5 = this.readMemoryWord(n);
                        this.disasmBuffer.append(String.format("$%04x", n5));
                        n4 = 2;
                        break block0;
                    }
                    case 1: {
                        n5 = this.readMemoryLong(n);
                        this.disasmBuffer.append(String.format("$%08x", n5));
                        n4 = 4;
                        break block0;
                    }
                    case 2: {
                        n5 = this.readMemoryWordSigned(n);
                        this.disasmBuffer.append(String.format("$%04x(pc)", (short)n5));
                        n4 = 2;
                        break block0;
                    }
                    case 3: {
                        n5 = this.readMemoryWord(n);
                        int n7 = MC68000Cpu.signExtendByte(n5);
                        this.disasmBuffer.append(String.format("$%02x(pc,", (byte)n7));
                        this.disasmBuffer.append((n5 & 0x8000) != 0 ? "a" : "d").append(n5 >> 12 & 7).append((n5 & 0x800) != 0 ? ".l" : ".w").append(")");
                        n4 = 2;
                        break block0;
                    }
                    case 4: {
                        if (bl) {
                            if (size == Size.Long) {
                                n5 = this.readMemoryLong(n);
                                n4 = 4;
                                this.disasmBuffer.append(String.format("#$%08x", n5));
                                break block0;
                            }
                            n5 = this.readMemoryWord(n);
                            n4 = 2;
                            this.disasmBuffer.append(String.format("#$%04x", n5));
                            if (size != Size.Byte) break block0;
                            n5 &= 0xFF;
                            break block0;
                        }
                        if (size == Size.Byte) {
                            this.disasmBuffer.append("ccr");
                            break block0;
                        }
                        this.disasmBuffer.append("sr");
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid reg specified for mode 7: " + n3);
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Invalid mode specified: " + n2);
            }
        }
        return new DisassembledOperand(this.disasmBuffer.toString(), n4, n5);
    }

    public Instruction getInstructionFor(int n) {
        return this.i_table[n];
    }

    public int[] getScreenAddresses() {
        int[] nArray = new int[]{this.screenStart, this.screenStop};
        return nArray;
    }

    public void moveBlock() {
        int n;
        int n2;
        if (this.data_regs[1] != 0 && this.copyMem(n2 = this.addr_regs[4], n = this.addr_regs[5]) && n >= this.screenStart && n < this.screenStop) {
            try {
                boolean bl = n2 >= this.screenStart && n2 < this.screenStop;
                this.screen.moveBlock(this, bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.pc_reg = this.readMemoryLong(this.addr_regs[7]) / 2;
        this.addr_regs[7] = this.addr_regs[7] + 4;
        this.data_regs[0] = 0;
        this.reg_sr |= 4;
    }

    private boolean copyMem(int n, int n2) {
        int n3 = this.data_regs[1] >>> 16 & 0xFFFF;
        int n4 = this.data_regs[1] & 0xFFFF;
        if ((n3 & 0x8000) != 0) {
            return false;
        }
        if ((n4 & 0x8000) != 0) {
            return false;
        }
        int n5 = this.data_regs[2] >>> 16 & 0xFFFF;
        int n6 = this.data_regs[2] & 0xFFFF;
        int n7 = this.data_regs[3] >>> 16 & 0xFFFF;
        int n8 = this.data_regs[3] & 0xFFFF;
        int n9 = this.addr_regs[2];
        int n10 = this.addr_regs[3];
        int n11 = this.screen.getDivisor();
        if (n11 == 2 && ((n7 & 1) != 0 || (n5 & 1) != 0 || (n & 1) != 0 || (n2 & 1) != 0 || (n9 & 1) != 0 || (n10 & 1) != 0 || (n3 & 1) != 0)) {
            n11 = n11 == 1 ? 2 : 1;
            n3 *= n11;
            if ((n += n6 * (n9 *= n11) + (n5 *= n11)) > (n2 += n8 * (n10 *= n11) + (n7 *= n11))) {
                for (int i = 0; i < n4; ++i) {
                    int n12 = n2;
                    int n13 = n;
                    while (n13 < n + n3) {
                        this.writeMemoryByte(n2, this.readMemoryByteSigned(n13));
                        ++n13;
                        ++n2;
                    }
                    n += n9;
                    n2 = n12 + n10;
                }
            } else {
                n += (n4 - 1) * n9;
                n2 += (n4 - 1) * n10;
                for (int i = 0; i < n4; ++i) {
                    int n14 = n2;
                    int n15 = n;
                    while (n15 < n + n3) {
                        this.writeMemoryByte(n2, this.readMemoryByteSigned(n15));
                        ++n15;
                        ++n2;
                    }
                    n -= n9;
                    n2 = n14 - n10;
                }
            }
        } else {
            n3 /= n11;
            n += n9 * n6 + (n5 /= n11) * 2;
            n2 += n10 * n8 + (n7 /= n11) * 2;
            n9 /= 2;
            n10 /= 2;
            if ((n /= 2) > (n2 /= 2)) {
                for (int i = 0; i < n4; ++i) {
                    System.arraycopy(this.mainMemory, n, this.mainMemory, n2, n3);
                    n += n9;
                    n2 += n10;
                }
            } else {
                n += (n4 - 1) * n9;
                n2 += (n4 - 1) * n10;
                for (int i = 0; i < n4; ++i) {
                    System.arraycopy(this.mainMemory, n, this.mainMemory, n2, n3);
                    n -= n9;
                    n2 -= n10;
                }
            }
        }
        return true;
    }

    public void combineBlocks() {
        if (this.addr_regs[5] != this.screenStart) {
            this.data_regs[0] = -14;
            return;
        }
        this.screen.combineBlocks(this);
    }

    public void setCopyScreen(int n, int n2) {
        this.data_regs[0] = -19;
        this.reg_sr &= 0xFFFFFFFB;
    }

    public String readSmsqeString(int n) {
        if ((n &= 0xFFFFFFF) > this.totMemSize) {
            return "";
        }
        int n2 = this.mainMemory[n / 2];
        if (n2 == 0 || n + n2 + 2 > this.totMemSize) {
            return "";
        }
        n /= 2;
        ++n;
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        while (n3 < n2) {
            short s = this.mainMemory[n];
            stringBuilder.append(Helper.convertToJava((byte)(s >>> 8)));
            stringBuilder.append(Helper.convertToJava((byte)(s & 0xFF)));
            n3 += 2;
            ++n;
        }
        if ((n2 & 1) == 1) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public void writeSmsqeString(int n, String string, int n2) {
        this.writeSmsqeString(n, string, true, n2);
    }

    public void writeSmsqeString(int n, String string, boolean bl, int n2) {
        short s;
        boolean bl2;
        n &= 0xFFFFFFF;
        if (string == null) {
            return;
        }
        if (string.isEmpty()) {
            if (bl) {
                this.mainMemory[n / 2] = 0;
            }
            return;
        }
        int n3 = string.length();
        if (n2 != -1 && n3 > n2) {
            n3 = n2;
        }
        if (n3 > 32200) {
            n3 = 32200;
        }
        if (2 + n + n3 > this.totMemSize) {
            return;
        }
        n /= 2;
        boolean bl3 = bl2 = (n3 & 1) == 1;
        if (bl) {
            this.mainMemory[n++] = (short)n3;
        }
        n3 &= 0xFFFFFFFE;
        int n4 = 0;
        while (n4 < n3) {
            s = Helper.convertToSMSQE(string.charAt(n4));
            s = (short)(s << 8);
            short s2 = Helper.convertToSMSQE(string.charAt(n4 + 1));
            this.mainMemory[n] = s = (short)(s | s2 & 0xFF);
            n4 += 2;
            ++n;
        }
        if (bl2) {
            n3 = Helper.convertToSMSQE(string.charAt(string.length() - 1));
            s = this.mainMemory[n];
            s = (short)(s & 0xFF);
            this.mainMemory[n] = (short)((n3 <<= 8) | s);
        }
    }

    public int writeToFile(int n, int n2, FileChannel fileChannel) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if ((n &= 0xFFFFFFF) + n2 > this.totMemSize && (n2 = this.totMemSize - n) < 1) {
            return 0;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if ((n & 1) == 1) {
            int n3 = 0;
            while (n3 < n2) {
                byteBuffer.put(n3, (byte)this.readMemoryByte(n));
                ++n3;
                ++n;
            }
        } else {
            n /= 2;
            int n4 = 0;
            while (n4 < n2 - 1) {
                byteBuffer.putShort(n4, this.mainMemory[n]);
                n4 += 2;
                ++n;
            }
            if ((n2 & 1) == 1) {
                byteBuffer.put(n2 - 1, (byte)(this.mainMemory[n] >> 8));
            }
        }
        return fileChannel.write(byteBuffer);
    }

    public ByteBuffer writeToBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.data_regs[2] + n);
        if (this.writeToBuffer(byteBuffer, n) == 0) {
            return null;
        }
        return byteBuffer;
    }

    public int writeToBuffer(ByteBuffer byteBuffer, int n) {
        int n2 = this.addr_regs[1];
        if ((n2 & 1) == 1) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[67], null);
            return 0;
        }
        int n3 = this.data_regs[2];
        if (n3 + n > byteBuffer.capacity()) {
            return 0;
        }
        if (n2 + n3 + n > this.totMemSize && (n3 = this.totMemSize - this.addr_regs[1]) < n) {
            return 0;
        }
        n3 /= 2;
        n2 /= 2;
        byteBuffer.position(n);
        int n4 = 0;
        while (n4 < n3) {
            byteBuffer.putShort(n4 * 2 + n, this.mainMemory[n2]);
            ++n4;
            ++n2;
        }
        n3 = this.data_regs[2];
        if ((n3 & 1) == 1) {
            byteBuffer.put(n + n3 - 1, (byte)(this.mainMemory[n2] >> 8));
        }
        return n3;
    }

    public int writeToBuffer(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer.position() + n2 > byteBuffer.capacity()) {
            return -1;
        }
        int n3 = n2--;
        byteBuffer.limit(byteBuffer.capacity());
        if ((n & 1) != 0) {
            byteBuffer.put((byte)this.readMemoryByte(n++));
            if (n2 == 0) {
                return 1;
            }
        }
        boolean bl = (n2 & 1) != 0;
        int n4 = n + n2 - 1;
        n2 /= 2;
        n /= 2;
        int n5 = 0;
        while (n5 < n2) {
            byteBuffer.putShort(this.mainMemory[n]);
            ++n5;
            ++n;
        }
        if (bl) {
            byteBuffer.put((byte)this.readMemoryByte(n4));
        }
        return n3;
    }

    public int readFromFile(int n, int n2, FileChannel fileChannel) throws IOException {
        return this.readFromFile(n, n2, fileChannel, false);
    }

    private int readFromFile(int n, int n2, FileChannel fileChannel, boolean bl) throws IOException {
        if (n2 < 1) {
            return 0;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if ((n2 = fileChannel.read(byteBuffer)) < 0) {
            return -1;
        }
        return this.readFromBuffer(n, n2, byteBuffer, 0, bl);
    }

    protected int readFromBuffer(int n, int n2, ByteBuffer byteBuffer, int n3, boolean bl) {
        short s;
        int n4;
        if (n2 < 1) {
            return 0;
        }
        n &= 0xFFFFFFF;
        if (bl ? n + n2 > this.totMemSize && (n2 = this.totMemSize - n) < 1 : n + n2 > this.totRamSize && (n2 = this.ramSize - n) < 1) {
            return 0;
        }
        boolean bl2 = false;
        if ((n >= this.screenStart && n <= this.screenStop || n + n2 >= this.screenStart && n + n2 <= this.screenStop) && !bl) {
            bl2 = true;
        }
        int n5 = n;
        byteBuffer.limit(byteBuffer.capacity());
        if (n2 + n3 > byteBuffer.capacity()) {
            n2 = byteBuffer.capacity() - n3;
        }
        boolean bl3 = (n & 1) == 1;
        n /= 2;
        if (bl3) {
            --n2;
            n4 = (short)(this.mainMemory[n] & 0xFF00);
            s = (short)(byteBuffer.get(n3) & 0xFF);
            this.mainMemory[n] = (short)(n4 | s);
            ++n;
            ++n3;
        }
        n4 = n3;
        while (n4 < n2 + n3 - 1) {
            this.mainMemory[n] = byteBuffer.getShort(n4);
            n4 += 2;
            ++n;
        }
        if ((n2 & 1) == 1) {
            s = this.mainMemory[n];
            s = (short)(s & 0xFF);
            this.mainMemory[n] = s = (short)(s | byteBuffer.get(n4) << 8);
        }
        if (bl3) {
            ++n2;
        }
        if (bl2) {
            this.screen.displayRegion(this, n5, n2);
        }
        return n2;
    }

    public int readFromBuffer(int n, int n2, ByteBuffer byteBuffer, int n3) {
        return this.readFromBuffer(n, n2, byteBuffer, n3, false);
    }

    public int findInMemory(int n, int n2, String string) {
        byte[] byArray = string.getBytes();
        if ((byArray.length & 1) != 0) {
            return -1;
        }
        short[] sArray = new short[byArray.length / 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < sArray.length) {
            short s = (short)(byArray[n3++] << 8);
            sArray[n4] = s = (short)(s | (short)byArray[n3]);
            ++n4;
            ++n3;
        }
        return this.findInMemory(n, n2, sArray);
    }

    public int findInMemory(int n, int n2, short[] sArray, String string) {
        byte[] byArray = string.getBytes();
        if ((byArray.length & 1) != 0) {
            return -1;
        }
        int n3 = sArray.length;
        short[] sArray2 = new short[n3 + byArray.length / 2];
        System.arraycopy(sArray, 0, sArray2, 0, n3);
        int n4 = 0;
        int n5 = n3;
        while (n5 < sArray2.length) {
            short s = (short)(byArray[n4++] << 8);
            sArray2[n5] = s = (short)(s | (short)byArray[n4]);
            ++n5;
            ++n4;
        }
        return this.findInMemory(n, n2, sArray2);
    }

    public int findInMemory(int n, int n2, short[] sArray) {
        int n3 = sArray.length;
        if (n3 == 0 || n < 0 || n2 > this.totMemSize) {
            return 0;
        }
        short s = sArray[0];
        n /= 2;
        n2 = n2 / 2 - n3;
        while (n < n2) {
            if (this.mainMemory[n++] != s) continue;
            boolean bl = true;
            int n4 = n;
            for (int i = 1; i < n3; ++i) {
                if (this.mainMemory[n4++] == sArray[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return --n * 2;
        }
        return -1;
    }

    public void setTrapDispatcher(TrapDispatcher trapDispatcher) {
        this.trapDispatcher = trapDispatcher;
    }

    public void setKeyrow(int n, int n2) {
        int n3 = this.readMemoryLong(1024);
        n3 = this.readMemoryLong(n3 + 232) + 34 + n;
        int n4 = this.readMemoryByte(n3);
        n2 = 1 << n2;
        this.writeMemoryByte(n3, n4 |= n2);
    }

    public void removeKeyrow(int n, int n2) {
        int n3 = this.readMemoryLong(1024);
        n3 = this.readMemoryLong(n3 + 232) + 34 + n;
        try {
            int n4 = this.readMemoryByte(n3);
            n2 = 1 << n2;
            this.writeMemoryByte(n3, n4 &= ~n2);
        }
        catch (Exception exception) {
            try {
                int n5 = this.readMemoryByte(n3);
                n2 = 1 << n2;
                this.writeMemoryByte(n3, n5 &= ~n2);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public IniFile getInifile() {
        return this.iniFile;
    }

    public void setScreenMode(int n) {
        this.screen.setMode(n);
    }

    public void setEmuScreenMode(int n) {
        this.screen.setEmuMode(n);
    }

    public int readableSize() {
        return this.totMemSize;
    }

    public int getLinkageBlock() {
        return this.ramSize;
    }

    public boolean isRomLoadedOk() {
        return this.romLoadedOK;
    }

    public void setupSMSQE(boolean bl) {
        int n;
        this.reset();
        int n2 = this.totRamSize / 2;
        if (bl) {
            for (n = 0; n < n2; ++n) {
                this.mainMemory[n] = 0;
            }
        }
        if (!this.romLoadedOK) {
            return;
        }
        this.writeMemoryLong(65546, 1198484580);
        this.pc_reg = this.totRamSize / 2;
        this.writeMemoryLong(this.ramSize - 4, this.ramSize);
        this.reg_ssp = this.ramSize - 8;
        this.addr_regs[7] = this.ramSize - 8;
        this.writeMemoryLong(4, this.ramSize);
        String string = this.iniFile.getOptionValue("NFA_USE");
        if (!string.isEmpty()) {
            n = Helper.convertUsageName(string);
            this.writeMemoryLong(this.ramSize + 38, n);
        }
        if (!(string = this.iniFile.getOptionValue("SFA_USE")).isEmpty()) {
            n = Helper.convertUsageName(string);
            this.writeMemoryLong(this.ramSize + 42, n);
        }
        if (!(string = this.iniFile.getOptionValue("WIN_USE")).isEmpty()) {
            n = Helper.convertUsageName(string);
            this.writeMemoryLong(this.ramSize + 46, n);
        }
        if (!(string = this.iniFile.getOptionValue("FLP_USE")).isEmpty()) {
            n = Helper.convertUsageName(string);
            this.writeMemoryLong(this.ramSize + 50, n);
        }
        if (!(string = this.iniFile.getOptionValue("MEM_USE")).isEmpty()) {
            n = Helper.convertUsageName(string);
            this.writeMemoryLong(this.ramSize + 54, n);
        }
        this.writeMemoryLong(this.ramSize + 34, 1464421937);
        int n3 = (int)(System.currentTimeMillis() / 1000L + (long)Monitor.TIME_OFFSET);
        this.writeMemoryLong(this.ramSize + 4, n3);
        n3 = this.randomNumber.nextInt(65535);
        this.writeMemoryWord(this.ramSize + 58, n3);
        this.newInterruptGenerated = false;
        n2 = this.findInMemory(this.totRamSize, this.totRamSize + 1000, "SMSQXqXq");
        if (n2 == -1) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[103], null);
            this.romLoadedOK = false;
            return;
        }
        int n4 = this.readMemoryLong(n2 + 8);
        if (n4 < Helper.convertStringToInt("3.32")) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[103], null);
            this.romLoadedOK = false;
            return;
        }
        if (n4 == Helper.convertStringToInt("3.32") && (n4 = this.readMemoryLong(n2 + 12)) < Helper.convertStringToInt("0001")) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[103], null);
            this.romLoadedOK = false;
            return;
        }
        if ((n2 = this.findInMemory(n2, this.totMemSize, Types.SMSQMULATOR_CONFIG_FLAG, "WIN0")) != -1) {
            n3 = n2 + Types.SMSQMULATOR_CONFIG_FLAG.length * 2 + 4;
            n = this.mainMemory[n3 /= 2] & 0xFF;
            if (this.iniFile.getTrueOrFalse("DISABLE-WIN-DEVICE")) {
                n += 256;
            }
            this.mainMemory[n3] = (short)(n & 0xFFFF);
        }
        if ((n2 = this.findInMemory(n2, this.totMemSize, Types.SMSQMULATOR_CONFIG_FLAG, "MEM0")) != -1) {
            n3 = n2 + Types.SMSQMULATOR_CONFIG_FLAG.length * 2 + 4;
            n = this.mainMemory[n3 /= 2] & 0xFF;
            if (this.iniFile.getTrueOrFalse("DISABLE-MEM-DEVICE")) {
                n += 256;
            }
            this.mainMemory[n3] = (short)(n & 0xFFFF);
        }
        if ((n2 = this.findInMemory(n2, this.totMemSize, Types.SMSQMULATOR_CONFIG_FLAG, "NFA0")) != -1) {
            n3 = n2 + Types.SMSQMULATOR_CONFIG_FLAG.length * 2 + 4;
            n = this.mainMemory[n3 /= 2] & 0xFF;
            if (this.iniFile.getTrueOrFalse("DISABLE-NFA-DEVICE")) {
                n += 256;
            }
            this.mainMemory[n3] = (short)(n & 0xFFFF);
        }
        if ((n2 = this.findInMemory(n2, this.totMemSize, Types.SMSQMULATOR_CONFIG_FLAG, "SFA0")) != -1) {
            n3 = n2 + Types.SMSQMULATOR_CONFIG_FLAG.length * 2 + 4;
            n = this.mainMemory[n3 /= 2] & 0xFF;
            if (this.iniFile.getTrueOrFalse("DISABLE-SFA-DEVICE")) {
                n += 256;
            }
            this.mainMemory[n3] = (short)(n & 0xFFFF);
        }
        if ((n2 = this.findInMemory(n2, this.totMemSize, Types.SMSQMULATOR_CONFIG_FLAG, "FLP0")) != -1) {
            n3 = n2 + Types.SMSQMULATOR_CONFIG_FLAG.length * 2 + 4;
            n = this.mainMemory[n3 /= 2] & 0xFF;
            if (this.iniFile.getTrueOrFalse("DISABLE-FLP-DEVICE")) {
                n += 256;
            }
            this.mainMemory[n3] = (short)(n & 0xFFFF);
        }
        if (this.screen != null) {
            this.screen.clearScreen();
            this.writeMemoryLong(this.ramSize + 20, this.screenStart);
            this.writeMemoryLong(this.ramSize + 24, this.screen.getScreenSizeInBytes());
            this.mainMemory[(this.ramSize + 28) / 2] = (short)this.screen.getLineSize();
            this.mainMemory[(this.ramSize + 30) / 2] = (short)this.screen.getXSize();
            this.mainMemory[(this.ramSize + 32) / 2] = (short)this.screen.getYSize();
            n = this.screen.getMode();
            switch (n) {
                case 0: 
                case 8: {
                    n = 0;
                    break;
                }
                case 16: {
                    n = 2;
                    break;
                }
                case 32: {
                    n = 3;
                }
            }
            n2 = this.findInMemory(this.totRamSize, this.totMemSize, Types.SMSQMULATOR_CONFIG_FLAG, "SMSQ");
            if (n2 == -1) {
                Helper.reportError(Localization.Texts[45], Localization.Texts[103], null);
                this.romLoadedOK = false;
                return;
            }
            n3 = n2 + Types.SMSQMULATOR_CONFIG_FLAG.length * 2 + 4 + 12 + 10;
            n = this.mainMemory[n3 /= 2] & 65280 + n;
            this.mainMemory[n3] = (short)(n & 0xFFFF);
            n = this.iniFile.getOptionAsInt("LESS-CPU-WHEN-IDLE", 1) << 8;
            n3 = n2 + Types.SMSQMULATOR_CONFIG_FLAG.length * 2 + 4 + 12 + 22;
            n = this.mainMemory[n3 /= 2] & 0xFF | n;
            this.mainMemory[n3] = (short)(n & 0xFFFF);
            this.romLoadedOK = true;
        } else {
            this.romLoadedOK = false;
        }
    }

    public boolean loadRomImage(String string, URL uRL) {
        RandomAccessFile randomAccessFile = null;
        if (string == null) {
            string = this.romFile;
        }
        this.romLoadedOK = false;
        Arrays.fill(this.mainMemory, (short)0);
        try {
            this.romFile = string;
            randomAccessFile = new RandomAccessFile(string, "r");
            FileChannel fileChannel = randomAccessFile.getChannel();
            int n = (int)fileChannel.size();
            this.readFromFile(this.totRamSize, n, fileChannel, true);
            randomAccessFile.close();
            this.romLoadedOK = true;
            this.setupSMSQE(false);
            return this.romLoadedOK;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[108], null);
            return false;
        }
        catch (Exception exception) {
            try {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                InputStream inputStream = uRL.openStream();
                int n = 350000;
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n2 != -1) {
                    n2 = inputStream.read(byArray, n3, n - n3);
                    n3 += n2;
                }
                inputStream.close();
                for (int i = 0; i < n3 + 3; i += 2) {
                    this.mainMemory[(this.totRamSize + i) / 2] = (short)(byArray[i] << 8 | byArray[i + 1] & 0xFF);
                }
                this.romLoadedOK = true;
                this.setupSMSQE(false);
                return this.romLoadedOK;
            }
            catch (Exception exception2) {
                Helper.reportError(Localization.Texts[45], Localization.Texts[50], null, exception2);
                return false;
            }
        }
    }

    public Screen getScreen() {
        return this.screen;
    }

    public String getRomFile() {
        return this.romFile;
    }

    public short[] getMemory() {
        return this.mainMemory;
    }
}

