/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class Bcc
implements InstructionSet {
    protected static final String[] names = new String[]{"bra", "bsr", "bhi", "bls", "bcc", "bcs", "bne", "beq", "bvc", "bvs", "bpl", "bmi", "bge", "blt", "bgt", "ble"};

    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 24576;
        Instruction instruction = new Instruction(){
            private static final int C_FLAG = 1;
            private static final int V_FLAG = 2;
            private static final int Z_FLAG = 4;
            private static final int N_FLAG = 8;
            private static final int C_Z_FLAGS = 5;
            private static final int N_V_FLAGS = 10;
            private static final int N_V_Z_FLAGS = 14;

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2;
                int n3 = mC68000Cpu.reg_sr;
                switch (n >> 8 & 0xF) {
                    case 2: {
                        if ((n3 & 5) == 0) break;
                        return;
                    }
                    case 3: {
                        if ((n3 & 5) != 0) break;
                        return;
                    }
                    case 4: {
                        if ((n3 & 1) == 0) break;
                        return;
                    }
                    case 5: {
                        if ((n3 & 1) != 0) break;
                        return;
                    }
                    case 6: {
                        if ((n3 & 4) == 0) break;
                        return;
                    }
                    case 7: {
                        if ((n3 & 4) != 0) break;
                        return;
                    }
                    case 8: {
                        if ((n3 & 2) == 0) break;
                        return;
                    }
                    case 9: {
                        if ((n3 & 2) != 0) break;
                        return;
                    }
                    case 10: {
                        if ((n3 & 8) == 0) break;
                        return;
                    }
                    case 11: {
                        if ((n3 & 8) != 0) break;
                        return;
                    }
                    case 12: {
                        n2 = n3 & 0xA;
                        if (n2 == 0 || n2 == 10) break;
                        return;
                    }
                    case 13: {
                        n2 = n3 & 0xA;
                        if (n2 == 8 || n2 == 2) break;
                        return;
                    }
                    case 14: {
                        n2 = n3 & 0xE;
                        if (n2 == 0 || n2 == 10) break;
                        return;
                    }
                    case 15: {
                        n2 = n3 & 0xE;
                        if ((n2 & 4) != 0 || n2 == 8 || n2 == 2) break;
                        return;
                    }
                }
                n2 = n & 0xFF;
                if ((n2 & 0x80) != 0) {
                    n2 -= 256;
                }
                mC68000Cpu.pc_reg += n2 / 2;
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                return Bcc.this.disassembleOp(n, n2, mC68000Cpu);
            }
        };
        Instruction instruction2 = new Instruction(){
            private static final int C_FLAG = 1;
            private static final int V_FLAG = 2;
            private static final int Z_FLAG = 4;
            private static final int N_FLAG = 8;
            private static final int C_Z_FLAGS = 5;
            private static final int N_V_FLAGS = 10;
            private static final int N_V_Z_FLAGS = 14;

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = mC68000Cpu.reg_sr;
                int n3 = mC68000Cpu.readMemoryWordPCSigned();
                switch (n >> 8 & 0xF) {
                    case 2: {
                        mC68000Cpu.pc_reg = (n2 & 5) == 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 3: {
                        mC68000Cpu.pc_reg = (n2 & 5) != 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 4: {
                        mC68000Cpu.pc_reg = (n2 & 1) == 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 5: {
                        mC68000Cpu.pc_reg = (n2 & 1) != 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 6: {
                        mC68000Cpu.pc_reg = (n2 & 4) == 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 7: {
                        mC68000Cpu.pc_reg = (n2 & 4) != 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 8: {
                        mC68000Cpu.pc_reg = (n2 & 2) == 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 9: {
                        mC68000Cpu.pc_reg = (n2 & 2) != 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 10: {
                        mC68000Cpu.pc_reg = (n2 & 8) == 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 11: {
                        mC68000Cpu.pc_reg = (n2 & 8) != 0 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 12: {
                        int n4 = n2 & 0xA;
                        mC68000Cpu.pc_reg = n4 == 0 || n4 == 10 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 13: {
                        int n5 = n2 & 0xA;
                        mC68000Cpu.pc_reg = n5 == 8 || n5 == 2 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 14: {
                        int n6 = n2 & 0xE;
                        mC68000Cpu.pc_reg = n6 == 0 || n6 == 10 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                    case 15: {
                        int n7 = n2 & 0xE;
                        mC68000Cpu.pc_reg = (n7 & 4) != 0 || n7 == 8 || n7 == 2 ? (mC68000Cpu.pc_reg += n3 / 2) : ++mC68000Cpu.pc_reg;
                        return;
                    }
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                return Bcc.this.disassembleOp(n, n2, mC68000Cpu);
            }
        };
        for (int i = 2; i < 16; ++i) {
            mC68000Cpu.addInstruction(n + (i << 8), instruction2);
            for (int j = 1; j < 256; ++j) {
                mC68000Cpu.addInstruction(n + (i << 8) + j, instruction);
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, MC68000Cpu mC68000Cpu) {
        String string;
        DisassembledOperand disassembledOperand;
        int n3 = n2 >> 8 & 0xF;
        int n4 = n2 & 0xFF;
        if ((n4 & 0x80) != 0) {
            n4 |= 0xFFFFFF00;
        }
        if (n4 != 0) {
            disassembledOperand = new DisassembledOperand(String.format("$%08x", n4 + n + 2));
            string = names[n3] + ".s";
        } else {
            n4 = mC68000Cpu.readMemoryWordSigned(n + 2);
            disassembledOperand = new DisassembledOperand(String.format("$%08x", n4 + n + 2), 2, n4);
            string = names[n3] + ".w";
        }
        return new DisassembledInstruction(n, n2, string, disassembledOperand);
    }
}

