/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.CMPI;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class CMPI_AnPlus
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 3096;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = mC68000Cpu.readMemoryWordPCInc() & 0xFF;
                        if ((n2 & 0x80) != 0) {
                            n2 |= 0xFFFFFF00;
                        }
                        int n3 = n & 7;
                        int n4 = mC68000Cpu.readMemoryByteSigned(mC68000Cpu.addr_regs[n3]);
                        if (n3 == 7) {
                            int n5 = n3;
                            mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 2;
                        } else {
                            int n6 = n3;
                            mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] + 1;
                        }
                        if ((n4 & 0x80) != 0) {
                            n4 |= 0xFFFFFF00;
                        }
                        int n7 = n4 - n2;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl2 = n2 < 0;
                        boolean bl3 = n4 < 0;
                        boolean bl4 = bl = n7 < 0;
                        if (n7 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMPI_AnPlus.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 3160;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n3 = n & 7;
                        int n4 = mC68000Cpu.readMemoryWordSigned(mC68000Cpu.addr_regs[n3]);
                        if ((n4 & 0x8000) != 0) {
                            n4 |= 0xFFFF0000;
                        }
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 2;
                        int n6 = n4 - n2;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl2 = n2 < 0;
                        boolean bl3 = n4 < 0;
                        boolean bl4 = bl = n6 < 0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMPI_AnPlus.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 3224;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        boolean bl;
                        int n2 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        int n3 = n & 7;
                        int n4 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n3]);
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 4;
                        int n6 = n4 - n2;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        boolean bl2 = n2 < 0;
                        boolean bl3 = n4 < 0;
                        boolean bl4 = bl = n6 < 0;
                        if (n6 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (bl) {
                            mC68000Cpu.reg_sr += 8;
                        }
                        if (!bl2 && bl3 && !bl || bl2 && !bl3 && bl) {
                            mC68000Cpu.reg_sr += 2;
                        }
                        if (bl2 && !bl3 || bl && !bl3 || bl2 && bl) {
                            ++mC68000Cpu.reg_sr;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return CMPI_AnPlus.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                mC68000Cpu.addInstruction(n + j, instruction);
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        String string;
        int n3;
        int n4;
        switch (size) {
            case Byte: {
                n4 = mC68000Cpu.readMemoryWord(n + 2);
                n3 = 2;
                string = String.format("#$%02x", n4 & 0xFF);
                break;
            }
            case Word: {
                n4 = mC68000Cpu.readMemoryWord(n + 2);
                n3 = 2;
                string = String.format("#$%04x", n4 & 0xFFFF);
                break;
            }
            case Long: {
                n4 = mC68000Cpu.readMemoryLong(n + 2);
                n3 = 4;
                string = String.format("#$%08x", n4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid size for CMPI");
            }
        }
        DisassembledOperand disassembledOperand = new DisassembledOperand(string, n3, n4);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2 + n3, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "cmpi" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

