/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class EXT
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = n & 7;
                int n3 = mC68000Cpu.data_regs[n2];
                mC68000Cpu.reg_sr &= 0xFFFF0;
                switch (n & 0x1C0) {
                    case 128: {
                        if ((n3 & 0x80) != 0) {
                            n3 |= 0xFF00;
                            mC68000Cpu.reg_sr |= 8;
                        } else {
                            n3 &= 0xFFFF00FF;
                        }
                        mC68000Cpu.data_regs[n2] = n3;
                        if ((n3 & 0xFFFF) == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        }
                        return;
                    }
                    case 192: {
                        if ((n3 & 0x8000) != 0) {
                            n3 |= 0xFFFF0000;
                            mC68000Cpu.reg_sr |= 8;
                        } else {
                            n3 &= 0xFFFF;
                        }
                        mC68000Cpu.data_regs[n2] = n3;
                        if (n3 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        }
                        return;
                    }
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = new DisassembledOperand("d" + (n2 & 7));
                switch (n2 & 0x1C0) {
                    case 128: {
                        return new DisassembledInstruction(n, n2, "ext.b", disassembledOperand);
                    }
                    case 192: {
                        return new DisassembledInstruction(n, n2, "ext.w", disassembledOperand);
                    }
                }
                return new DisassembledInstruction(n, n2, "ext.l", disassembledOperand);
            }
        };
        int n2 = 18560;
        for (n = 0; n < 8; ++n) {
            mC68000Cpu.addInstruction(n2 + n, instruction);
        }
        n2 = 18624;
        for (n = 0; n < 8; ++n) {
            mC68000Cpu.addInstruction(n2 + n, instruction);
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2) {
        DisassembledOperand disassembledOperand;
        DisassembledOperand disassembledOperand2;
        switch (n2 & 0xF8) {
            case 64: {
                disassembledOperand2 = new DisassembledOperand("d" + (n2 >> 9 & 7));
                disassembledOperand = new DisassembledOperand("d" + (n2 & 7));
                break;
            }
            case 72: {
                disassembledOperand2 = new DisassembledOperand("a" + (n2 >> 9 & 7));
                disassembledOperand = new DisassembledOperand("a" + (n2 & 7));
                break;
            }
            case 136: {
                disassembledOperand2 = new DisassembledOperand("d" + (n2 >> 9 & 7));
                disassembledOperand = new DisassembledOperand("a" + (n2 & 7));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid exg type specified");
            }
        }
        return new DisassembledInstruction(n, n2, "exg", disassembledOperand2, disassembledOperand);
    }
}

