/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class LINK
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 20048;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
                mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.addr_regs[n & 7]);
                mC68000Cpu.addr_regs[n & 7] = mC68000Cpu.addr_regs[7];
                mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] + mC68000Cpu.readMemoryWordPCSignedInc();
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = new DisassembledOperand("a" + (n2 & 7));
                int n3 = mC68000Cpu.readMemoryWordSigned(n + 2);
                DisassembledOperand disassembledOperand2 = new DisassembledOperand(String.format("#$%04x", n3), 2, n3);
                return new DisassembledInstruction(n, n2, "link", disassembledOperand, disassembledOperand2);
            }
        };
        for (int i = 0; i < 8; ++i) {
            mC68000Cpu.addInstruction(n + i, instruction);
        }
    }
}

