/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.LSL;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class LSLmem
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n;
        int n2;
        int n3 = 58304;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = 0;
                int n3 = n & 7;
                block0 : switch (n >> 3 & 7) {
                    case 2: {
                        n2 = mC68000Cpu.addr_regs[n3];
                        break;
                    }
                    case 3: {
                        n2 = mC68000Cpu.addr_regs[n3];
                        int n4 = n3;
                        mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] + 2;
                        break;
                    }
                    case 4: {
                        int n5 = n3;
                        mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] - 2;
                        n2 = mC68000Cpu.addr_regs[n3];
                        break;
                    }
                    case 5: {
                        n2 = mC68000Cpu.addr_regs[n3] + mC68000Cpu.readMemoryWordPCSignedInc();
                        break;
                    }
                    case 6: {
                        n2 = this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n3];
                        break;
                    }
                    case 7: {
                        switch (n & 7) {
                            case 0: {
                                n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                                break block0;
                            }
                            case 1: {
                                n2 = mC68000Cpu.readMemoryLongPC();
                                mC68000Cpu.pc_reg += 2;
                            }
                        }
                    }
                }
                int n6 = mC68000Cpu.readMemoryWord(n2);
                int n7 = n6 & 0x8000;
                mC68000Cpu.writeMemoryWord(n2, n6 <<= 1);
                mC68000Cpu.reg_sr &= 0xFFE0;
                if ((n6 & 0x8000) != 0) {
                    mC68000Cpu.reg_sr += 8;
                } else if (n6 == 0) {
                    mC68000Cpu.reg_sr += 4;
                }
                if (n7 != 0) {
                    mC68000Cpu.reg_sr |= 0x11;
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Word);
                return new DisassembledInstruction(n, n2, "lsl" + Size.Word.ext(), disassembledOperand);
            }

            protected int getDisplacement(MC68000Cpu mC68000Cpu) {
                int n;
                int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                return n;
            }
        };
        for (n2 = 2; n2 < 7; ++n2) {
            n = n2 << 3;
            for (int i = 0; i < 8; ++i) {
                mC68000Cpu.addInstruction(n3 + n + i, instruction);
            }
        }
        n = 56;
        for (n2 = 0; n2 < 2; ++n2) {
            mC68000Cpu.addInstruction(n3 + n + n2, instruction);
        }
    }
}

