/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.MOVE;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class MOVEAn2bis
implements InstructionSet {
    @Override
    public final void register(final MC68000Cpu mC68000Cpu) {
        Instruction instruction = new Instruction(){
            private MC68000Cpu cpu;
            {
                this.cpu = mC68000Cpu;
            }

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu2) {
                int n2 = mC68000Cpu2.addr_regs[0];
                if (mC68000Cpu2.addr_regs[2] != 16) {
                    mC68000Cpu2.writeMemoryLong(mC68000Cpu2.addr_regs[2], n2);
                }
                mC68000Cpu2.reg_sr &= 0xFFF0;
                if (n2 == 0) {
                    mC68000Cpu2.reg_sr += 4;
                } else if (n2 < 0) {
                    mC68000Cpu2.reg_sr += 8;
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu2) {
                return MOVEAn2bis.this.disassembleOp(n, n2, Size.Long, mC68000Cpu2);
            }
        };
        mC68000Cpu.addInstruction(9352, instruction);
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2 + disassembledOperand.bytes, n2 >> 6 & 7, n2 >> 9 & 7, size);
        return new DisassembledInstruction(n, n2, "move" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

