/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.MOVE;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class MOVEAnW6
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 4536;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                        n3 = mC68000Cpu.readMemoryByte(n3);
                        int n4 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n5 = n2 = (n4 & 0x80) != 0 ? n4 | 0xFFFFFF00 : n4 & 0xFF;
                        n2 = (n4 & 0x8000) != 0 ? ((n4 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n4 >> 12 & 7])) : (n2 += mC68000Cpu.addr_regs[n4 >> 12 & 7])) : ((n4 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n4 >> 12 & 7])) : (n2 += mC68000Cpu.data_regs[n4 >> 12 & 7]));
                        mC68000Cpu.writeMemoryByte(mC68000Cpu.addr_regs[n >> 9 & 7] + n2, n3);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n3 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if ((n3 & 0x80) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnW6.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 12728;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                        n3 = mC68000Cpu.readMemoryWord(n3);
                        int n4 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n5 = n2 = (n4 & 0x80) != 0 ? n4 | 0xFFFFFF00 : n4 & 0xFF;
                        n2 = (n4 & 0x8000) != 0 ? ((n4 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n4 >> 12 & 7])) : (n2 += mC68000Cpu.addr_regs[n4 >> 12 & 7])) : ((n4 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n4 >> 12 & 7])) : (n2 += mC68000Cpu.data_regs[n4 >> 12 & 7]));
                        mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[n >> 9 & 7] + n2, n3);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n3 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if ((n3 & 0x8000) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnW6.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 8632;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                        n3 = mC68000Cpu.readMemoryLong(n3);
                        int n4 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n5 = n2 = (n4 & 0x80) != 0 ? n4 | 0xFFFFFF00 : n4 & 0xFF;
                        n2 = (n4 & 0x8000) != 0 ? ((n4 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n4 >> 12 & 7])) : (n2 += mC68000Cpu.addr_regs[n4 >> 12 & 7])) : ((n4 & 0x800) == 0 ? (n2 += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n4 >> 12 & 7])) : (n2 += mC68000Cpu.data_regs[n4 >> 12 & 7]));
                        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[n >> 9 & 7] + n2, n3);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n3 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (n3 < 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEAnW6.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                mC68000Cpu.addInstruction(n + (j << 9), instruction);
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2 + disassembledOperand.bytes, n2 >> 6 & 7, n2 >> 9 & 7, size);
        return new DisassembledInstruction(n, n2, "move" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

