/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class MOVEPr2m
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 2; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 392;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.data_regs[n >> 9 & 7];
                        int n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                        mC68000Cpu.writeMemoryByte(n3, n2 >>> 8 & 0xFF);
                        mC68000Cpu.writeMemoryByte(n3 + 2, n2 & 0xFF);
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEPr2m.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 456;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.data_regs[n >> 9 & 7];
                        int n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                        mC68000Cpu.writeMemoryByte(n3, n2 >>> 24 & 0xFF);
                        mC68000Cpu.writeMemoryByte(n3 + 2, n2 >>> 16 & 0xFF);
                        mC68000Cpu.writeMemoryByte(n3 + 4, n2 >>> 8 & 0xFF);
                        mC68000Cpu.writeMemoryByte(n3 + 6, n2 & 0xFF);
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEPr2m.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                int n2 = j << 9;
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + n2 + k, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        int n3 = mC68000Cpu.readMemoryWordSigned(n + 2);
        DisassembledOperand disassembledOperand = new DisassembledOperand("d" + (n2 >> 9 & 7));
        DisassembledOperand disassembledOperand2 = new DisassembledOperand(String.format("#$%04x(a%d)", n3, n2 & 7), 2, n3);
        return new DisassembledInstruction(n, n2, "movep" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

