/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class NBCD
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = 0;
                block0 : switch (n >> 3 & 7) {
                    case 0: {
                        int n3 = n & 7;
                        int n4 = this.doCalc(n, mC68000Cpu.data_regs[n3] & 0xFF, mC68000Cpu);
                        int n5 = n3;
                        mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] & 0xFFFFFF00;
                        int n6 = n3;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | n4;
                        return;
                    }
                    case 2: {
                        n2 = mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 3: {
                        int n7 = n & 7;
                        n2 = mC68000Cpu.addr_regs[n7];
                        if (n7 == 7) {
                            int n8 = n & 7;
                            mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] + 2;
                            break;
                        }
                        int n9 = n & 7;
                        mC68000Cpu.addr_regs[n9] = mC68000Cpu.addr_regs[n9] + 1;
                        break;
                    }
                    case 4: {
                        int n10 = n & 7;
                        if (n10 == 7) {
                            int n11 = n & 7;
                            mC68000Cpu.addr_regs[n11] = mC68000Cpu.addr_regs[n11] - 2;
                        } else {
                            int n12 = n & 7;
                            mC68000Cpu.addr_regs[n12] = mC68000Cpu.addr_regs[n12] - 1;
                        }
                        n2 = mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 5: {
                        n2 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                        break;
                    }
                    case 6: {
                        n2 = this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                        break;
                    }
                    case 7: {
                        switch (n & 7) {
                            case 0: {
                                n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                                break block0;
                            }
                            case 1: {
                                n2 = mC68000Cpu.readMemoryLongPC();
                                ++mC68000Cpu.pc_reg;
                            }
                        }
                    }
                }
                int n13 = mC68000Cpu.readMemoryByte(n2);
                mC68000Cpu.writeMemoryByte(n2, this.doCalc(n, n13, mC68000Cpu));
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                DisassembledOperand disassembledOperand = mC68000Cpu.disassembleDstEA(n + 2, n2 >> 3 & 7, n2 & 7, Size.Byte);
                return new DisassembledInstruction(n, n2, "nbcd", disassembledOperand);
            }

            protected final int getDisplacement(MC68000Cpu mC68000Cpu) {
                int n;
                int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                return n;
            }

            protected final int doCalc(int n, int n2, MC68000Cpu mC68000Cpu) {
                int n3;
                int n4 = (mC68000Cpu.reg_sr & 0x10) == 0 ? 0 : 1;
                int n5 = 10 - (n2 & 0xF) - n4;
                if (n5 < 10) {
                    n3 = 1;
                } else {
                    n5 = 0;
                    n3 = 0;
                }
                int n6 = 10 - (n2 >> 4 & 0xF) - n3;
                if (n6 < 10) {
                    n3 = 1;
                } else {
                    n3 = 0;
                    n6 = 0;
                }
                int n7 = (n6 << 4) + n5;
                mC68000Cpu.reg_sr = n3 == 0 ? (mC68000Cpu.reg_sr &= 0xFFEE) : (mC68000Cpu.reg_sr |= 0x11);
                if ((n7 &= 0xFF) != 0) {
                    mC68000Cpu.reg_sr &= 0xFFFB;
                }
                return n7;
            }
        };
        int n = 18432;
        for (int i = 0; i < 8; ++i) {
            if (i == 1) continue;
            int n2 = i << 3;
            for (int j = 0; j < 8 && !(i == 7 & j > 1); ++j) {
                mC68000Cpu.addInstruction(n + n2 + j, instruction);
            }
        }
    }
}

