/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.ROX;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class ROXLreg
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 57648;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.data_regs[n >> 9 & 7] & 0x3F;
                        int n3 = mC68000Cpu.data_regs[n & 7] & 0xFF;
                        int n4 = 0;
                        int n5 = (mC68000Cpu.reg_sr & 0x10) == 0 ? 0 : 1;
                        for (int i = 0; i < n2; ++i) {
                            n4 = n3 & 0x80;
                            n3 <<= 1;
                            if (n5 != 0) {
                                n3 |= 1;
                            }
                            n5 = n4;
                        }
                        int n6 = n & 7;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] & 0xFFFFFF00;
                        int n7 = n & 7;
                        mC68000Cpu.data_regs[n7] = mC68000Cpu.data_regs[n7] | (n3 &= 0xFF);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if ((n3 & 0x80) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        } else if (n3 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        }
                        if (n2 != 0) {
                            mC68000Cpu.reg_sr = n4 != 0 ? (mC68000Cpu.reg_sr |= 0x11) : (mC68000Cpu.reg_sr &= 0xFFFFFFEF);
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ROXLreg.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 57712;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.data_regs[n >> 9 & 7] & 0x3F;
                        int n3 = mC68000Cpu.data_regs[n & 7] & 0xFFFF;
                        int n4 = 0;
                        int n5 = (mC68000Cpu.reg_sr & 0x10) == 0 ? 0 : 1;
                        for (int i = 0; i < n2; ++i) {
                            n4 = n3 & 0x8000;
                            n3 <<= 1;
                            if (n5 != 0) {
                                n3 |= 1;
                            }
                            n5 = n4;
                        }
                        int n6 = n & 7;
                        mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] & 0xFFFF0000;
                        int n7 = n & 7;
                        mC68000Cpu.data_regs[n7] = mC68000Cpu.data_regs[n7] | (n3 &= 0xFFFF);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if ((n3 & 0x8000) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        } else if (n3 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        }
                        if (n2 != 0) {
                            mC68000Cpu.reg_sr = n4 != 0 ? (mC68000Cpu.reg_sr |= 0x11) : (mC68000Cpu.reg_sr &= 0xFFFFFFEF);
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ROXLreg.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 57776;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.data_regs[n >> 9 & 7] & 0x3F;
                        int n3 = mC68000Cpu.data_regs[n & 7];
                        int n4 = 0;
                        int n5 = (mC68000Cpu.reg_sr & 0x10) == 0 ? 0 : 1;
                        for (int i = 0; i < n2; ++i) {
                            n4 = n3 & Integer.MIN_VALUE;
                            n3 <<= 1;
                            if (n5 != 0) {
                                n3 |= 1;
                            }
                            n5 = n4;
                        }
                        mC68000Cpu.data_regs[n & 7] = n3;
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if ((n3 & 0x80) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        } else if (n3 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        }
                        if (n2 != 0) {
                            mC68000Cpu.reg_sr = n4 != 0 ? (mC68000Cpu.reg_sr |= 0x11) : (mC68000Cpu.reg_sr &= 0xFFFFFFEF);
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return ROXLreg.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    mC68000Cpu.addInstruction(n + (j << 9) + k, instruction);
                }
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = new DisassembledOperand("d" + (n2 >> 9 & 7));
        DisassembledOperand disassembledOperand2 = new DisassembledOperand("d" + (n2 & 7));
        return new DisassembledInstruction(n, n2, "roxl" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

