/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.TST;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class TST_MinusAn
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 18976;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = n & 7;
                        if (n2 == 7) {
                            int n3 = n2;
                            mC68000Cpu.addr_regs[n3] = mC68000Cpu.addr_regs[n3] - 2;
                        } else {
                            int n4 = n2;
                            mC68000Cpu.addr_regs[n4] = mC68000Cpu.addr_regs[n4] - 1;
                        }
                        int n5 = mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[n2]);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n5 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if ((n5 & 0x80) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return TST_MinusAn.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu);
                    }
                };
            } else if (i == 1) {
                n = 19040;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = n2 = n & 7;
                        mC68000Cpu.addr_regs[n3] = mC68000Cpu.addr_regs[n3] - 2;
                        int n4 = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[n2]);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n4 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if ((n4 & 0x8000) != 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return TST_MinusAn.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 19104;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = n2 = n & 7;
                        mC68000Cpu.addr_regs[n3] = mC68000Cpu.addr_regs[n3] - 4;
                        int n4 = mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[n2]);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n4 == 0) {
                            mC68000Cpu.reg_sr += 4;
                        } else if (n4 < 0) {
                            mC68000Cpu.reg_sr += 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return TST_MinusAn.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                mC68000Cpu.addInstruction(n + j, instruction);
            }
        }
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 2, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "tst" + size.ext(), disassembledOperand);
    }
}

