/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.util.HashMap;
import smsqmulator.IPReadAheadBuffer;
import smsqmulator.IPTypes;
import smsqmulator.cpu.MC68000Cpu;

public class IPSocket {
    private Socket socket;
    private ServerSocket serverSocket;
    private DatagramSocket udpSocket;
    public InputStream rawIn;
    private IPReadAheadBuffer inBuffer;
    public OutputStream rawOut;
    private int type;
    private IPTypes.CONN_STATUS status;
    private int errorNumber;
    private int port;
    private int backlog;
    private int family;
    private InetAddress ina;
    private static final int TIMEOUT = 1;
    private static final int SERVERTIMEOUT = 5;

    public IPSocket(MC68000Cpu mC68000Cpu, HashMap<Integer, IPSocket> hashMap) {
        switch (mC68000Cpu.data_regs[7]) {
            case 1396919135: 
            case 1413697631: {
                this.type = mC68000Cpu.data_regs[7];
                break;
            }
            default: {
                mC68000Cpu.data_regs[0] = -7;
                return;
            }
        }
        int n = mC68000Cpu.data_regs[3];
        if (n > 2) {
            mC68000Cpu.data_regs[0] = -15;
            return;
        }
        if (this.type == 1430540383 || this.type == 1413697631) {
            if (n < 0) {
                mC68000Cpu.data_regs[0] = -15;
                return;
            }
            String string = mC68000Cpu.readSmsqeString(mC68000Cpu.readMemoryLong(mC68000Cpu.addr_regs[7] + 8));
            string = string.length() == 4 ? "" : string.substring(4);
            String[] stringArray = string.split(":");
            if (n != 0 && (stringArray == null || stringArray.length != 2 || stringArray[0].length() < 1 || stringArray[1].length() < 1)) {
                mC68000Cpu.data_regs[0] = -15;
                return;
            }
            if (this.type == 1413697631) {
                this.status = IPTypes.CONN_STATUS.NOT_CONNECTED;
                if (n != 0) {
                    try {
                        this.port = Integer.parseInt(stringArray[1]);
                        this.socket = new Socket(stringArray[0], this.port);
                        this.ina = this.socket.getInetAddress();
                        this.rawIn = this.socket.getInputStream();
                        this.inBuffer = new IPReadAheadBuffer(this.rawIn);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.rawIn);
                        boolean bl = bufferedInputStream.markSupported();
                        this.rawOut = this.socket.getOutputStream();
                        this.type = 1413697631;
                        this.status = IPTypes.CONN_STATUS.CONNECTED;
                        mC68000Cpu.data_regs[0] = 0;
                    }
                    catch (Exception exception) {
                        mC68000Cpu.data_regs[0] = -15;
                    }
                } else {
                    mC68000Cpu.data_regs[0] = 0;
                }
            } else if (this.type == 1430540383) {
                mC68000Cpu.data_regs[0] = -7;
            }
        } else if (n > -1) {
            this.status = IPTypes.CONN_STATUS.NOT_CONNECTED;
            mC68000Cpu.data_regs[0] = 0;
        } else {
            IPSocket iPSocket = hashMap.get(-n);
            if (iPSocket == null || iPSocket.status != IPTypes.CONN_STATUS.LISTENING || iPSocket.type != 1413697631) {
                mC68000Cpu.data_regs[0] = -6;
                return;
            }
            ServerSocket serverSocket = iPSocket.getServerSocket();
            if (serverSocket == null) {
                mC68000Cpu.data_regs[0] = -6;
                return;
            }
            try {
                this.type = 1413697631;
                this.errorNumber = 0;
                this.socket = serverSocket.accept();
                this.socket.setSoTimeout(1);
                this.rawIn = this.socket.getInputStream();
                this.inBuffer = new IPReadAheadBuffer(this.rawIn);
                this.rawOut = this.socket.getOutputStream();
                this.port = this.socket.getLocalPort();
                this.ina = this.socket.getLocalAddress();
                this.status = IPTypes.CONN_STATUS.CONNECTED;
                mC68000Cpu.data_regs[0] = 0;
            }
            catch (SocketTimeoutException | IllegalBlockingModeException exception) {
                mC68000Cpu.data_regs[0] = -1;
            }
            catch (Exception exception) {
                mC68000Cpu.data_regs[0] = -6;
            }
        }
    }

    public void close() {
        try {
            this.rawIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.rawOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            } else if (this.serverSocket != null) {
                this.serverSocket.close();
            } else if (this.udpSocket != null) {
                this.udpSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IPTypes.CONN_STATUS getConnectionStatus() {
        return this.status;
    }

    public void setConnectionStatus(IPTypes.CONN_STATUS cONN_STATUS) {
        this.status = cONN_STATUS;
    }

    public int getSocketType() {
        return this.type;
    }

    public void setSocketType(int n) {
        this.type = n;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public int getLastError() {
        return this.errorNumber;
    }

    public void setLastError(int n) {
        this.errorNumber = n;
    }

    public int bind(MC68000Cpu mC68000Cpu) {
        switch (this.type) {
            case 1396919135: {
                this.errorNumber = 2;
                return -6;
            }
            case 1413697631: 
            case 1430540383: {
                this.port = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[2] + 2);
                this.family = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[2]);
                byte[] byArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byArray[i] = (byte)mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[2] + 4 + i);
                }
                try {
                    this.ina = InetAddress.getByAddress(byArray);
                }
                catch (UnknownHostException unknownHostException) {
                    this.errorNumber = 4;
                    return -15;
                }
                catch (Exception exception) {
                    this.errorNumber = 4;
                    return -15;
                }
                this.errorNumber = 0;
                return 0;
            }
        }
        this.errorNumber = 1;
        return -6;
    }

    public int connect(MC68000Cpu mC68000Cpu) {
        switch (this.type) {
            case 1413697631: {
                if (this.status == IPTypes.CONN_STATUS.CONNECTED) {
                    this.errorNumber = 3;
                    return -9;
                }
                int n = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[2] + 2);
                this.family = mC68000Cpu.readMemoryWord(mC68000Cpu.addr_regs[2]);
                byte[] byArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byArray[i] = (byte)mC68000Cpu.readMemoryByte(mC68000Cpu.addr_regs[2] + 4 + i);
                }
                try {
                    this.ina = InetAddress.getByAddress(byArray);
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(this.ina, n);
                    Socket socket = new Socket();
                    socket.connect(inetSocketAddress, 200);
                    this.socket = socket;
                    this.port = this.socket.getLocalPort();
                    this.ina = this.socket.getLocalAddress();
                    this.rawIn = this.socket.getInputStream();
                    this.inBuffer = new IPReadAheadBuffer(this.rawIn);
                    this.rawOut = this.socket.getOutputStream();
                    this.socket.setSoTimeout(1);
                    this.type = 1413697631;
                    this.status = IPTypes.CONN_STATUS.CONNECTED;
                    break;
                }
                catch (NullPointerException | UnknownHostException exception) {
                    this.errorNumber = 4;
                    return -15;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.errorNumber = 5;
                    return -15;
                }
                catch (SecurityException securityException) {
                    this.errorNumber = 7;
                    return -15;
                }
                catch (ConnectException connectException) {
                    this.errorNumber = 15;
                    return -23;
                }
                catch (IOException iOException) {
                    this.errorNumber = 6;
                    return -15;
                }
                catch (Exception exception) {
                    this.errorNumber = 8;
                    return -15;
                }
            }
            case 1396919135: {
                this.errorNumber = 2;
                return -6;
            }
            default: {
                this.errorNumber = 1;
                return -6;
            }
        }
        this.errorNumber = 0;
        return 0;
    }

    public int listen(MC68000Cpu mC68000Cpu) {
        switch (this.type) {
            case 1413697631: {
                if (this.status == IPTypes.CONN_STATUS.CONNECTED) {
                    this.errorNumber = 3;
                    return -9;
                }
                if (this.socket != null) {
                    this.errorNumber = 12;
                    return -9;
                }
                try {
                    this.backlog = mC68000Cpu.data_regs[1];
                    if (this.serverSocket == null) {
                        this.serverSocket = new ServerSocket(this.port, this.backlog, this.ina);
                        this.serverSocket.setSoTimeout(5);
                    }
                    this.type = 1413697631;
                    this.status = IPTypes.CONN_STATUS.LISTENING;
                    this.errorNumber = 0;
                    break;
                }
                catch (UnknownHostException unknownHostException) {
                    this.errorNumber = 4;
                    return -15;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.errorNumber = 5;
                    return -15;
                }
                catch (SecurityException securityException) {
                    this.errorNumber = 7;
                    return -15;
                }
                catch (ClosedChannelException closedChannelException) {
                    this.errorNumber = 13;
                    return -15;
                }
                catch (BindException bindException) {
                    this.errorNumber = 16;
                    return -9;
                }
                catch (IOException iOException) {
                    this.errorNumber = 6;
                    return -15;
                }
                catch (Exception exception) {
                    this.errorNumber = 8;
                    return -15;
                }
            }
            case 1396919135: {
                this.errorNumber = 2;
                return -6;
            }
            default: {
                this.errorNumber = 1;
                return -6;
            }
        }
        this.errorNumber = 0;
        return 0;
    }

    public int send(MC68000Cpu mC68000Cpu, int n) {
        if (n == 0) {
            return 0;
        }
        switch (this.type) {
            case 1413697631: {
                if (this.status != IPTypes.CONN_STATUS.CONNECTED) {
                    this.errorNumber = 9;
                    return -10;
                }
                byte[] byArray = new byte[n];
                int n2 = mC68000Cpu.addr_regs[1];
                if ((n2 & 1) == 0) {
                    this.fastRead(mC68000Cpu, byArray, n2, n);
                } else {
                    for (int i = 0; i < n; ++i) {
                        byArray[i] = (byte)mC68000Cpu.readMemoryByte(n2++);
                    }
                }
                try {
                    this.rawOut.write(byArray, 0, n);
                    this.rawOut.flush();
                    mC68000Cpu.addr_regs[1] = mC68000Cpu.addr_regs[1] + n;
                    this.errorNumber = 0;
                    return n;
                }
                catch (IOException iOException) {
                    this.errorNumber = 10;
                    return -13;
                }
                catch (Exception exception) {
                    this.errorNumber = 8;
                    return -13;
                }
            }
            case 1396919135: 
            case 1430540383: {
                this.errorNumber = 2;
                return -6;
            }
        }
        this.errorNumber = 1;
        return -6;
    }

    public int sendTo(MC68000Cpu mC68000Cpu, int n) {
        if (n == 0) {
            mC68000Cpu.data_regs[1] = 0;
            return 0;
        }
        if (this.type == 1413697631) {
            return this.send(mC68000Cpu, n);
        }
        this.errorNumber = 2;
        return -6;
    }

    public int send1Byte(MC68000Cpu mC68000Cpu, int n) {
        this.errorNumber = 0;
        switch (this.type) {
            case 1413697631: {
                if (this.status != IPTypes.CONN_STATUS.CONNECTED) {
                    this.errorNumber = 9;
                    return -10;
                }
                try {
                    this.rawOut.write(n);
                    this.rawOut.flush();
                    break;
                }
                catch (IOException iOException) {
                    this.errorNumber = 10;
                    return -13;
                }
                catch (Exception exception) {
                    this.errorNumber = 8;
                    return -13;
                }
            }
            case 1396919135: {
                this.errorNumber = 2;
                return -6;
            }
            default: {
                this.errorNumber = 1;
                return -6;
            }
        }
        return 0;
    }

    private void fastRead(MC68000Cpu mC68000Cpu, byte[] byArray, int n, int n2) {
        short[] sArray = mC68000Cpu.getMemory();
        n /= 2;
        for (int i = 0; i < n2 - 1; i += 2) {
            int n3 = sArray[n++] & 0xFFFF;
            byArray[i] = (byte)(n3 >>> 8);
            byArray[i + 1] = (byte)(n3 & 0xFF);
        }
        if ((n2 & 1) != 0) {
            byArray[i] = (byte)mC68000Cpu.readMemoryByte(n * 2);
        }
    }

    public int receive(MC68000Cpu mC68000Cpu, int n, boolean bl, byte[] byArray) {
        this.errorNumber = 0;
        switch (this.type) {
            case 1413697631: {
                if (this.status != IPTypes.CONN_STATUS.CONNECTED) {
                    this.errorNumber = 9;
                    return -10;
                }
                if (byArray == null) {
                    byArray = new byte[n];
                }
                int n2 = mC68000Cpu.addr_regs[1];
                try {
                    int n3 = bl ? this.inBuffer.read(byArray, (mC68000Cpu.data_regs[1] & 2) != 0) : this.inBuffer.read(byArray, false);
                    if (n3 > 0) {
                        if ((n2 & 1) == 0) {
                            this.fastWrite(mC68000Cpu, byArray, n2, n3);
                        } else {
                            for (int i = 0; i < n3; ++i) {
                                mC68000Cpu.writeMemoryByte(n2++, byArray[i]);
                            }
                        }
                        return n3;
                    }
                    return 0;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.errorNumber = 11;
                    return -1;
                }
                catch (IOException iOException) {
                    this.errorNumber = 11;
                    return -13;
                }
                catch (Exception exception) {
                    this.errorNumber = 8;
                    return -13;
                }
            }
            case 1396919135: {
                this.errorNumber = 2;
                return -6;
            }
        }
        this.errorNumber = 1;
        return -6;
    }

    private void fastWrite(MC68000Cpu mC68000Cpu, byte[] byArray, int n, int n2) {
        short[] sArray = mC68000Cpu.getMemory();
        n /= 2;
        for (int i = 0; i < n2 - 1; i += 2) {
            int n3 = byArray[i] << 8;
            sArray[n++] = (short)(n3 |= byArray[i + 1] & 0xFF);
        }
        if ((n2 & 1) != 0) {
            mC68000Cpu.writeMemoryByte(n * 2, byArray[n2 - 1]);
        }
    }

    public int receive1Byte(MC68000Cpu mC68000Cpu, byte[] byArray) {
        this.errorNumber = 0;
        if (byArray == null || byArray.length != 1) {
            return -10;
        }
        switch (this.type) {
            case 1413697631: {
                if (this.status != IPTypes.CONN_STATUS.CONNECTED) {
                    this.errorNumber = 9;
                    return -10;
                }
                try {
                    int n = this.inBuffer.read(byArray, false);
                    if (n < 1) {
                        return -1;
                    }
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.errorNumber = 11;
                    return -1;
                }
                catch (SocketException socketException) {
                    this.errorNumber = 11;
                    return -10;
                }
                catch (IOException iOException) {
                    this.errorNumber = 11;
                    return -13;
                }
                catch (Exception exception) {
                    this.errorNumber = 8;
                    return -13;
                }
            }
            case 1396919135: {
                this.errorNumber = 2;
                return -6;
            }
            default: {
                this.errorNumber = 1;
                return -6;
            }
        }
        return 0;
    }

    public int getRemote(MC68000Cpu mC68000Cpu) {
        if (mC68000Cpu.data_regs[2] < 2) {
            return -4;
        }
        mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[1], this.family);
        if (mC68000Cpu.data_regs[2] < 4) {
            mC68000Cpu.data_regs[1] = 2;
            return 0;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.socket.getRemoteSocketAddress();
        mC68000Cpu.writeMemoryWord(mC68000Cpu.addr_regs[1] + 2, inetSocketAddress.getPort());
        if (mC68000Cpu.data_regs[2] < 8) {
            mC68000Cpu.data_regs[1] = 4;
            return 0;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        byte[] byArray = inetAddress.getAddress();
        if (byArray.length != 4) {
            return -19;
        }
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            n |= byArray[i] & 0xFF;
            n <<= 8;
        }
        mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[1] + 4, n |= byArray[3] & 0xFF);
        mC68000Cpu.data_regs[1] = 8;
        return 0;
    }

    public String getRemoteChanName() {
        if (this.status == IPTypes.CONN_STATUS.CONNECTED) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.socket.getRemoteSocketAddress();
            return inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
        }
        return "";
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this.type) {
            case 1430540383: {
                stringBuilder.append("UDP_");
                break;
            }
            case 1396919135: {
                stringBuilder.append("SCK_");
                break;
            }
            case 1413697631: {
                stringBuilder.append("TCP_");
                break;
            }
            default: {
                stringBuilder.append("???_IP_???_");
            }
        }
        if (this.socket != null) {
            stringBuilder.append(this.ina.getHostAddress());
            stringBuilder.append(":").append(this.port);
        } else {
            if (this.ina != null) {
                stringBuilder.append(this.ina.getHostAddress());
            }
            stringBuilder.append(":").append(this.port);
        }
        switch (this.status) {
            case NOT_CONNECTED: {
                stringBuilder.append(" (nc)");
                break;
            }
            case CONNECTING: {
                stringBuilder.append(" (ci)");
                break;
            }
            case CONNECTED: {
                stringBuilder.append(" (c)");
                break;
            }
            case LISTENING: {
                stringBuilder.append(" (l)");
            }
        }
        return stringBuilder.toString();
    }

    private static String stripSite(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase().endsWith(".site") && string.length() > 5 ? string.substring(0, string.length() - 5) : string;
    }
}

