/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;
import smsqmulator.DoNothingException;
import smsqmulator.IncorrectFiletypeException;
import smsqmulator.Localization;
import smsqmulator.MemDriver;
import smsqmulator.Warnings;
import smsqmulator.WinDir;
import smsqmulator.WinDrive;
import smsqmulator.cpu.MC68000Cpu;

public class MemDrive
extends WinDrive {
    private ByteBuffer totalFile;
    public static final int MAX_FILESIZE = 524288000;
    private int fileSize;
    private boolean isLocal = false;

    public MemDrive(MC68000Cpu mC68000Cpu, String string, MemDriver memDriver, int n, Warnings warnings) throws FileNotFoundException, IOException, ArrayIndexOutOfBoundsException, ProtocolException, DoNothingException, IncorrectFiletypeException {
        super(mC68000Cpu, warnings);
        this.driveName = string;
        this.driver = memDriver;
        this.driveNumber = n;
        this.readFAT(this.driveName);
        this.readMainDir();
        if (this.mainDir == null) {
            throw new ProtocolException(Localization.Texts[56] + "\n(" + string + ")");
        }
    }

    private void readFAT(String string) throws FileNotFoundException, IOException, ArrayIndexOutOfBoundsException, DoNothingException, IncorrectFiletypeException {
        int n;
        int n2;
        Object object;
        InputStream inputStream = null;
        long l = 0L;
        try {
            object = new File(string);
            inputStream = new FileInputStream((File)object);
            l = ((File)object).length();
            if (l > 524288000L) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n2 = -1;
            } else {
                n2 = (int)l + 2;
            }
            this.isLocal = true;
        }
        catch (Exception exception) {
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
                n2 = 0x100000;
            }
            catch (Exception exception2) {
                throw new FileNotFoundException();
            }
        }
        if (n2 == -1) {
            throw new IOException(Localization.Texts[115] + ":\n" + string + "\n(" + l + Localization.Texts[116]);
        }
        object = new byte[n2];
        this.fileSize = 0;
        try {
            n = 0;
            while (n != -1) {
                n = inputStream.read((byte[])object, this.fileSize, n2 - this.fileSize);
                this.fileSize += n;
                if (n2 - this.fileSize > 0) continue;
                if ((n2 += 0x100000) > 524288000) {
                    n2 = -1;
                    break;
                }
                object = Arrays.copyOf((byte[])object, n2);
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            throw new IOException(Localization.Texts[117]);
        }
        if (n2 == -1) {
            throw new IOException(Localization.Texts[115] + ":\n" + string + "\n(" + l + Localization.Texts[116]);
        }
        ++this.fileSize;
        this.totalFile = ByteBuffer.wrap((byte[])object);
        if (this.totalFile.getInt(0) != 1363957569) {
            throw new IncorrectFiletypeException();
        }
        this.clusterSize = 512 * (this.totalFile.getShort(34) & 0xFFFF);
        this.fatClusterChain = new ArrayList();
        this.fatClusterChain.add(0);
        n = this.totalFile.getShort(64) & 0xFFFF;
        try {
            while (n != 0) {
                this.fatClusterChain.add(n);
                n = this.totalFile.getShort(64 + n * 2) & 0xFFFF;
            }
        }
        catch (Exception exception) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.totalFile.getShort(46) & 0xFFFF;
        int n4 = n3 / (this.totalFile.getShort(34) & 0xFFFF);
        if (n3 % (this.totalFile.getShort(34) & 0xFFFF) != 0) {
            ++n4;
        }
        if (n4 != this.fatClusterChain.size()) {
            int n5;
            if (this.warnings.warnIfQXLDriveNotCompliant) {
                Toolkit.getDefaultToolkit().beep();
                n5 = JOptionPane.showConfirmDialog(null, Localization.Texts[74] + this.driver.getName(this.driveNumber - 49) + Localization.Texts[75] + "\n" + Localization.Texts[76] + "\n" + Localization.Texts[77] + "WIN" + (this.driveNumber - 48) + "_ " + Localization.Texts[78] + "\n", Localization.Texts[73], 2, 0);
                if (n5 != 0) {
                    throw new DoNothingException();
                }
            }
            for (n5 = 1; n5 < n4; ++n5) {
                this.fatClusterChain.add(n5);
            }
        }
        this.driveFAT = ByteBuffer.allocate(this.clusterSize * this.fatClusterChain.size());
        this.driveFAT.position(0);
        this.driveFAT.limit(this.driveFAT.capacity());
        this.totalFile.position(0);
        this.totalFile.limit(this.driveFAT.capacity());
        this.driveFAT.put(this.totalFile);
        this.totalFile.limit(this.totalFile.capacity());
        this.driveFAT.position(0);
        this.totalFile.position(0);
    }

    private void readMainDir() {
        ArrayList<Integer> arrayList;
        int n = this.driveFAT.getShort(52) & 0xFFFF;
        int n2 = this.driveFAT.getInt(54);
        ByteBuffer byteBuffer = this.readFile(n2, n, arrayList = new ArrayList<Integer>());
        if (byteBuffer != null) {
            this.mainDir = new WinDir(this, null, 0, byteBuffer, arrayList, null, null);
        }
    }

    private void writeFAT() throws IOException {
        this.writeFile(this.driveFAT, this.fatClusterChain);
        this.driveFAT.limit(this.driveFAT.capacity());
        this.driveFAT.position(0);
    }

    @Override
    public ByteBuffer readFile(int n, int n2, ArrayList<Integer> arrayList) {
        if (n < 1 || arrayList == null) {
            return null;
        }
        int n3 = n / this.clusterSize;
        if (n % this.clusterSize != 0) {
            ++n3;
        }
        arrayList.clear();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 * this.clusterSize);
        if (this.readFile(n, n2, byteBuffer, arrayList)) {
            return byteBuffer;
        }
        return null;
    }

    private boolean readFile(int n, int n2, ByteBuffer byteBuffer, ArrayList<Integer> arrayList) {
        if (byteBuffer.capacity() < n) {
            return false;
        }
        int n3 = 0;
        try {
            do {
                arrayList.add(n2);
                int n4 = Math.min(this.clusterSize, n);
                byteBuffer.limit(n3 + n4);
                byteBuffer.position(n3);
                int n5 = n2 * this.clusterSize;
                this.totalFile.limit(n5 + n4);
                this.totalFile.position(n5);
                byteBuffer.put(this.totalFile);
                if ((n -= n4) <= 0 || n4 != this.clusterSize) {
                    n2 = 0;
                    continue;
                }
                n3 += this.clusterSize;
                n2 = this.driveFAT.getShort(n2 * 2 + 64) & 0xFFFF;
            } while (n2 != 0);
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            this.totalFile.position(0);
            this.totalFile.limit(this.totalFile.capacity());
            return true;
        }
        catch (Exception exception) {
            this.totalFile.position(0);
            this.totalFile.limit(this.totalFile.capacity());
            return false;
        }
    }

    @Override
    public void writeFile(ByteBuffer byteBuffer, ArrayList<Integer> arrayList) throws IOException {
        int n = 0;
        int n2 = this.clusterSize;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        for (int n5 : arrayList) {
            byteBuffer.limit(n2);
            byteBuffer.position(n);
            int n6 = n5 * this.clusterSize;
            this.totalFile.limit(n6 + this.clusterSize);
            this.totalFile.position(n6);
            this.totalFile.put(byteBuffer);
            n += this.clusterSize;
            if ((n2 += this.clusterSize) <= byteBuffer.capacity()) continue;
            n2 = byteBuffer.capacity();
        }
        byteBuffer.limit(n4);
        byteBuffer.position(n3);
        this.totalFile.position(0);
        this.totalFile.limit(this.totalFile.capacity());
    }

    @Override
    public void writePartOfFile(ByteBuffer byteBuffer, ArrayList<Integer> arrayList, int n, int n2) throws IOException {
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        int n5 = n / this.clusterSize;
        int n6 = (n + n2) / this.clusterSize;
        for (int i = n5; i < n6 + 1; ++i) {
            int n7 = arrayList.get(i);
            byteBuffer.limit((i + 1) * this.clusterSize);
            byteBuffer.position(i * this.clusterSize);
            int n8 = n7 * this.clusterSize;
            this.totalFile.limit(n8 + this.clusterSize);
            this.totalFile.position(n8);
            this.totalFile.put(byteBuffer);
        }
        byteBuffer.limit(n4);
        byteBuffer.position(n3);
        this.totalFile.position(0);
        this.totalFile.limit(this.totalFile.capacity());
    }

    @Override
    public int readBytes(int n, ByteBuffer byteBuffer, long l) {
        if (byteBuffer.capacity() < n) {
            return -1;
        }
        try {
            byteBuffer.limit(n);
            byteBuffer.position(0);
            this.totalFile.position((int)l);
            this.totalFile.limit((int)l + n);
            byteBuffer.put(this.totalFile);
            this.totalFile.limit(this.totalFile.capacity());
            this.totalFile.position(0);
            return n;
        }
        catch (Exception exception) {
            this.totalFile.position(0);
            this.totalFile.limit(this.totalFile.capacity());
            return -1;
        }
    }

    @Override
    public int writeBytes(int n, ByteBuffer byteBuffer, long l, int n2) {
        if (byteBuffer.capacity() < n + n2) {
            return -1;
        }
        try {
            int n3 = byteBuffer.position();
            int n4 = byteBuffer.limit();
            byteBuffer.limit(n + n2);
            byteBuffer.position(n2);
            this.totalFile.limit((int)l + n);
            this.totalFile.position((int)l);
            this.totalFile.put(byteBuffer);
            this.totalFile.position(0);
            this.totalFile.limit(this.totalFile.capacity());
            byteBuffer.limit(n4);
            byteBuffer.position(n3);
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void writeBack(String string) {
        if (!this.isLocal) {
            this.cpu.data_regs[0] = -20;
        } else {
            try {
                File file = new File(string);
                this.raFile = new RandomAccessFile(file, "rw");
                this.ioChannel = this.raFile.getChannel();
                this.totalFile.limit(this.totalFile.capacity());
                this.totalFile.position(0);
                this.ioChannel.write(this.totalFile);
                this.raFile.close();
                this.cpu.data_regs[0] = 0;
                this.totalFile.position(0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.cpu.data_regs[0] = -7;
            }
            catch (IOException iOException) {
                this.cpu.data_regs[0] = -20;
            }
        }
    }
}

