/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import smsqmulator.Monitor;
import smsqmulator.QL50HzInterrupt;
import smsqmulator.TrapDispatcher;
import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.MC68000Cpu;

public class MonitorGoThread
extends Thread {
    private final MC68000Cpu cpu;
    private final Monitor monitor;
    private QL50HzInterrupt ih = null;
    private final TrapDispatcher trapDispatcher;
    private int iterations;
    private int deduct = 1;
    private boolean stopNow;
    private boolean logInstructions = false;
    private DebugList dbl = null;
    private String instructionsListFilename = "/home/wolf/debugSmsqmulator.txt";
    private boolean excludeSuper = false;
    private final StringBuilder sBuilder;
    private final ArrayList<Integer> breakpoints;
    private boolean watchBreakpoints = false;
    private int provbkp = -1;
    private boolean goFast = false;
    private int conditionDataReg = -1;
    private int conditionAddressReg = -1;
    private int conditionValue;
    private boolean conditionIsContent;
    private int conditionAddress = -1;
    private boolean signalDeath = true;
    private int upperLimit = 0;
    private int oldval = 0;
    private boolean ckmem = false;
    private int memWatched = 0;
    private boolean oldSupervisor = false;

    public MonitorGoThread(int n, MC68000Cpu mC68000Cpu, ArrayList<Integer> arrayList, Monitor monitor, String string, boolean bl, boolean bl2, QL50HzInterrupt qL50HzInterrupt, boolean bl3, TrapDispatcher trapDispatcher, int n2, boolean bl4, int n3, int n4, boolean bl5) {
        if (n != 0) {
            this.iterations = n;
            this.deduct = 1;
        } else {
            this.iterations = 1;
            this.deduct = 0;
        }
        this.cpu = mC68000Cpu;
        this.breakpoints = arrayList;
        this.monitor = monitor;
        if (string != null && !string.isEmpty()) {
            this.instructionsListFilename = string;
        }
        this.dbl = new DebugList(50020);
        this.logInstructions = bl2;
        this.watchBreakpoints = bl;
        this.ih = qL50HzInterrupt;
        this.goFast = bl3;
        this.trapDispatcher = trapDispatcher;
        this.sBuilder = new StringBuilder(400);
        this.upperLimit = n2;
        this.ckmem = bl4;
        this.memWatched = n3;
        this.provbkp = n4;
        this.excludeSuper = bl5;
    }

    @Override
    public void run() {
        boolean bl = false;
        this.dbl.clear();
        this.oldval = this.cpu.readMemoryLong(this.memWatched);
        this.cpu.setTrapDispatcher(this.trapDispatcher);
        if (this.ih != null) {
            this.ih.startInterrruptHandler();
        }
        String string = "";
        if (this.goFast) {
            this.cpu.executeContinuous();
            this.stopNow = true;
        }
        while (this.iterations > 0 && !this.stopNow) {
            try {
                int n;
                int n2;
                if (!(!this.logInstructions || this.excludeSuper && this.cpu.isSupervisorMode())) {
                    if (this.upperLimit != 0) {
                        n2 = this.cpu.pc_reg * 2;
                        if (n2 < this.upperLimit) {
                            this.saveInstruction();
                        }
                    } else {
                        this.saveInstruction();
                    }
                }
                if (this.cpu.pc_reg * 2 == this.conditionAddress) {
                    bl = true;
                }
                if ((n = this.cpu.execute()) < 0) {
                    if (n == -10) {
                        this.stopNow = true;
                        string = "Hard breakpoint";
                        break;
                    }
                    if (n == -20) {
                        this.stopNow = true;
                        string = "ILLEGAL instruction!";
                        break;
                    }
                    if (n == -30) {
                        this.saveInstruction();
                        this.dbl.saveToFile("/home/wolf/smsqe/DEBUG.txt");
                        this.cpu.stopNow = 0;
                    } else {
                        this.trapDispatcher.dispatchTrap(-n, this.cpu);
                    }
                }
                n2 = this.cpu.pc_reg * 2;
                this.cpu.stopNow = 0;
                if (this.upperLimit != 0) {
                    if (n2 < this.upperLimit) {
                        this.iterations -= this.deduct;
                    }
                } else {
                    this.iterations -= this.deduct;
                }
                if (this.ckmem && (this.cpu.readMemoryLong(this.memWatched) != this.oldval || n2 > 18688 && n2 < 73728)) {
                    this.stopNow = true;
                    this.oldval = this.cpu.readMemoryLong(this.memWatched);
                    string = "Memory changed!";
                }
                if (this.provbkp != -1 && n2 == this.provbkp) {
                    this.stopNow = true;
                    string = "Provisional Breakpoint hhit";
                    break;
                }
                if (this.watchBreakpoints && this.breakpoints != null && this.breakpoints.contains(n2)) {
                    this.stopNow = true;
                    string = "Permanent breakpoint hit";
                    break;
                }
                if (!this.checkConditon(bl)) continue;
                this.stopNow = true;
                string = "Condition met";
            }
            catch (Exception exception) {
                this.stopNow = true;
            }
        }
        this.done(string);
    }

    public void done(String string) {
        if (this.ih != null) {
            this.ih.stopInterruptHandler();
        }
        this.provbkp = -1;
        if (this.signalDeath) {
            this.monitor.showInfo(true, null);
            this.monitor.goThreadStopped(string);
        }
        if (this.logInstructions) {
            this.dbl.saveToFile(this.instructionsListFilename);
        }
    }

    public synchronized void stopThread() {
        this.stopNow = true;
        this.interrupt();
    }

    public synchronized void switchLogging(boolean bl) {
        this.logInstructions = bl;
        if (!bl) {
            this.dbl.saveToFile(this.instructionsListFilename);
        } else {
            this.dbl.clear();
        }
    }

    public synchronized void switchSuper(boolean bl) {
        this.excludeSuper = bl;
    }

    private void saveInstruction() {
        int n;
        int n2;
        this.sBuilder.setLength(0);
        ListElement listElement = new ListElement();
        int n3 = this.cpu.pc_reg * 2;
        listElement.memaddress = String.format("%08x ", n3);
        if (n3 < 0) {
            this.sBuilder.append(String.format("%08x   ????", n3));
        } else {
            n2 = this.cpu.readMemoryWord(n3);
            Instruction instruction = this.cpu.getInstructionFor(n2);
            DisassembledInstruction disassembledInstruction = instruction.disassemble(n3, n2, this.cpu);
            boolean bl = false;
            if (bl) {
                disassembledInstruction.formatInstruction(this.sBuilder);
            } else {
                disassembledInstruction.shortFormat(this.sBuilder);
            }
            this.sBuilder.append(String.format("  %08x ", this.cpu.readMemoryLong(n3)));
        }
        listElement.instruction = this.sBuilder.toString();
        n2 = this.cpu.addr_regs[7] & 0xFFFFFFFE;
        this.sBuilder.setLength(0);
        this.sBuilder.append(String.format("A7: %08x  ", n2));
        for (n = 0; n < 4; ++n) {
            this.sBuilder.append(String.format("    %08x  ", this.cpu.readMemoryLong(n2 + n * 4)));
        }
        listElement.memcontent = this.sBuilder.toString();
        this.sBuilder.setLength(0);
        for (n = 0; n < 8; ++n) {
            this.sBuilder.append(String.format("D" + n + ": %08x  ", this.cpu.data_regs[n]));
        }
        listElement.regContentsData = this.sBuilder.toString();
        this.sBuilder.setLength(0);
        for (n = 0; n < 8; ++n) {
            this.sBuilder.append(String.format("A" + n + ": %08x  ", this.cpu.addr_regs[n]));
        }
        listElement.regContentsAddr = this.sBuilder.toString();
        if (this.cpu.isSupervisorMode() != this.oldSupervisor) {
            this.oldSupervisor = !this.oldSupervisor;
            listElement.supervisor = "New Supervisor state = " + this.oldSupervisor;
        } else {
            listElement.supervisor = "";
        }
        this.dbl.add(listElement);
    }

    private boolean checkConditon(boolean bl) {
        if (this.conditionIsContent) {
            if (this.conditionAddressReg == -1) {
                return false;
            }
            if (!bl) {
                return false;
            }
            int n = this.cpu.readMemoryLong(this.cpu.addr_regs[this.conditionAddressReg]);
            return n == this.conditionValue;
        }
        if (this.conditionAddressReg != -1) {
            return this.cpu.addr_regs[this.conditionAddressReg] == this.conditionValue;
        }
        return this.conditionDataReg != -1 && this.cpu.data_regs[this.conditionDataReg] == this.conditionValue;
    }

    public synchronized void setCondition(int n, int n2, int n3, boolean bl, int n4) {
        this.conditionValue = n3;
        this.conditionDataReg = n;
        this.conditionAddressReg = n2;
        this.conditionIsContent = bl;
        this.conditionAddress = n4;
    }

    public synchronized void signalDeath(boolean bl) {
        this.signalDeath = bl;
    }

    public synchronized void setckmem(boolean bl) {
        this.ckmem = bl;
    }

    public synchronized void setmemWatched(int n) {
        this.oldval = this.cpu.readMemoryLong(n);
        this.memWatched = n;
    }

    public synchronized void setUpperLimit(int n) {
        this.upperLimit = n;
    }

    private class DebugList {
        private int last;
        private final int maxsize;
        private final ListElement[] elmts;

        public DebugList(int n) {
            this.maxsize = n;
            this.elmts = new ListElement[n];
        }

        public void clear() {
            this.last = -1;
        }

        public void add(ListElement listElement) {
            if (this.last != -1 && listElement.memaddress.equals(this.elmts[this.last].memaddress)) {
                return;
            }
            ++this.last;
            if (this.last >= this.maxsize) {
                this.last = 0;
            }
            this.elmts[this.last] = listElement;
        }

        public void saveToFile(String string) {
            block7: {
                PrintWriter printWriter = null;
                PrintWriter printWriter2 = null;
                int n = 0;
                try {
                    printWriter = new PrintWriter(new FileWriter(string));
                    printWriter2 = new PrintWriter(new FileWriter(string + "2"));
                    int n2 = this.last + 1;
                    if (n2 >= this.maxsize) {
                        n2 = 0;
                    }
                    while (n2 != this.last) {
                        n = this.printElement(printWriter, printWriter2, this.elmts[n2], n);
                        if (++n2 < this.maxsize) continue;
                        n2 = 0;
                    }
                    this.printElement(printWriter, printWriter2, this.elmts[this.last], n);
                    printWriter.close();
                    printWriter2.close();
                }
                catch (Exception exception) {
                    if (printWriter == null) break block7;
                    try {
                        printWriter.close();
                        if (printWriter2 != null) {
                            printWriter2.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }

        private int printElement(PrintWriter printWriter, PrintWriter printWriter2, ListElement listElement, int n) {
            if (listElement == null) {
                return n;
            }
            String string = "                                                                                                                                           ";
            String string2 = n > 0 && n < string.length() - 1 ? string.substring(0, n) : "";
            printWriter.println(string2 + "                                            " + listElement.regContentsData);
            printWriter.println(string2 + "                                            " + listElement.regContentsAddr);
            printWriter.println(string2 + "                                            " + listElement.memcontent);
            printWriter2.println(string2 + listElement.instruction);
            printWriter.println(string2 + listElement.instruction);
            if (!listElement.supervisor.isEmpty()) {
                printWriter.println("  SUPERVISOR CHANGE " + listElement.supervisor);
                printWriter2.println("  SUPERVISOR CHANGE " + listElement.supervisor);
            }
            if (listElement.instruction.contains("bsr") || listElement.instruction.contains("jsr")) {
                n += 2;
            }
            if (listElement.instruction.contains("rts") || listElement.instruction.contains("rte")) {
                n -= 2;
            }
            if (n < 0) {
                n = 0;
            }
            return n;
        }
    }

    private class ListElement {
        public ListElement next = null;
        public String instruction = "";
        public String memaddress = "";
        public String memcontent = "";
        public String regContentsData = "";
        public String regContentsAddr = "";
        public String supervisor;

        private ListElement() {
        }
    }
}

