/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import smsqmulator.Helper;
import smsqmulator.Localization;
import smsqmulator.Warnings;
import smsqmulator.cpu.MC68000Cpu;

public class SampledSound {
    private SourceDataLine sourceDataLine;
    private PlayThread playThread;
    private final ArrayList<byte[]> queue;
    private boolean stopSound;
    private FloatControl volume;
    private volatile boolean isAsleep;
    private boolean reSample;
    private static final double RATE = 0.09297052154195011;
    private double adjustFreq;
    private int start;
    private int end;
    private int bufferSize;
    private int qsize;
    private static final boolean BIG_ENDIAN = true;
    private static final int CHANNELS = 2;
    private static final int BITS = 8;
    private static final boolean SIGNED = false;

    public SampledSound(MC68000Cpu mC68000Cpu, int n, Warnings warnings, String string) {
        block9: {
            AudioFormat audioFormat;
            this.queue = new ArrayList();
            this.stopSound = false;
            this.isAsleep = false;
            this.reSample = false;
            this.qsize = 0;
            if (string != null && string.equals("20")) {
                audioFormat = new AudioFormat(20000.0f, 8, 2, false, true);
            } else {
                this.reSample = true;
                audioFormat = new AudioFormat(22050.0f, 8, 2, false, true);
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            try {
                this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                this.sourceDataLine.open(audioFormat, 30720);
                this.bufferSize = this.sourceDataLine.available();
                this.playThread = new PlayThread();
                this.playThread.setName("SampledSound play thread");
                this.playThread.setDaemon(true);
                this.playThread.start();
            }
            catch (LineUnavailableException lineUnavailableException) {
                if (warnings.warnIfSoundProblem) {
                    Helper.reportError(Localization.Texts[45], Localization.Texts[72] + ":\n", null, lineUnavailableException);
                    mC68000Cpu.data_regs[0] = -1;
                }
                this.sourceDataLine = null;
                return;
            }
            try {
                this.volume = (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.VOLUME);
                this.setVolume(n);
            }
            catch (Exception exception) {
                try {
                    this.volume = (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
                    this.setVolume(n);
                }
                catch (Exception exception2) {
                    if (!warnings.warnIfSoundProblem) break block9;
                    Helper.reportError(Localization.Texts[45], Localization.Texts[72] + ":\n", null, exception);
                    mC68000Cpu.data_regs[0] = -1;
                }
            }
        }
    }

    public void fillPointers(MC68000Cpu mC68000Cpu) {
        if (this.sourceDataLine == null) {
            return;
        }
        this.sourceDataLine.flush();
        this.start = mC68000Cpu.addr_regs[2];
        this.end = mC68000Cpu.addr_regs[1];
        mC68000Cpu.data_regs[0] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getFromQueue() {
        ArrayList<byte[]> arrayList = this.queue;
        synchronized (arrayList) {
            if (this.queue.isEmpty()) {
                return null;
            }
            byte[] byArray = this.queue.get(0);
            this.qsize -= byArray.length;
            if (this.qsize < 0) {
                this.qsize = 0;
            }
            this.queue.remove(0);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueIsEmpty() {
        ArrayList<byte[]> arrayList = this.queue;
        synchronized (arrayList) {
            return this.queue.isEmpty();
        }
    }

    public void setVolume(int n) {
        if (this.volume == null) {
            return;
        }
        float f = this.volume.getMaximum();
        float f2 = this.volume.getMinimum();
        float f3 = f - f2;
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        f3 = n == 0 ? f2 : f3 * ((float)n / 100.0f) + f2;
        try {
            this.volume.setValue(f3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killSound(MC68000Cpu mC68000Cpu) {
        if (this.playThread != null) {
            this.playThread.stopNow();
        }
        ArrayList<byte[]> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.clear();
            this.qsize = 0;
        }
        mC68000Cpu.data_regs[0] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSample(MC68000Cpu mC68000Cpu) {
        mC68000Cpu.data_regs[0] = 0;
        if (this.sourceDataLine != null) {
            if (this.volume.getValue() == this.volume.getMinimum()) {
                return;
            }
            if (this.playThread != null) {
                byte[] byArray = this.resample(mC68000Cpu);
                if (byArray != null) {
                    ArrayList<byte[]> arrayList = this.queue;
                    synchronized (arrayList) {
                        this.queue.add(byArray);
                        this.qsize += byArray.length;
                    }
                }
                if (this.isAsleep) {
                    this.playThread.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunk(byte[] byArray) {
        if ((byArray = this.resample(byArray)) != null) {
            ArrayList<byte[]> arrayList = this.queue;
            synchronized (arrayList) {
                this.queue.add(byArray);
                this.qsize += byArray.length;
            }
        }
        if (this.playThread != null && this.isAsleep) {
            this.playThread.interrupt();
        }
    }

    private byte[] resample(byte[] byArray) {
        if (!this.reSample) {
            return byArray;
        }
        int n = byArray.length;
        ArrayList<Byte> arrayList = new ArrayList<Byte>(n + n / 9);
        for (int i = 0; i < n - 1; i += 2) {
            arrayList.add(byArray[i]);
            arrayList.add(byArray[i + 1]);
            if (this.adjustFreq < 1.0) {
                this.adjustFreq += 0.09297052154195011;
                continue;
            }
            arrayList.add(byArray[i]);
            arrayList.add(byArray[i + 1]);
            this.adjustFreq -= 1.0;
        }
        return this.convertArrayList(arrayList);
    }

    private byte[] convertArrayList(ArrayList<Byte> arrayList) {
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = arrayList.get(i);
        }
        return byArray;
    }

    private byte[] resample(MC68000Cpu mC68000Cpu) {
        short[] sArray = mC68000Cpu.getMemory();
        int n = mC68000Cpu.addr_regs[1];
        int n2 = n - this.start;
        if (n2 == 0) {
            return null;
        }
        if (!this.reSample) {
            int n3 = 0;
            byte[] byArray = new byte[n2];
            for (int i = this.start / 2; i < n / 2; ++i) {
                short s = sArray[i];
                byArray[n3] = (byte)(s >>> 8);
                byArray[++n3] = (byte)s;
                ++n3;
            }
            return byArray;
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>(n2 + n2 / 9);
        for (int i = this.start / 2; i < n / 2; ++i) {
            short s = sArray[i];
            arrayList.add((byte)(s >>> 8));
            arrayList.add((byte)s);
            if (this.adjustFreq < 1.0) {
                this.adjustFreq += 0.09297052154195011;
                continue;
            }
            arrayList.add((byte)(s >>> 8));
            arrayList.add((byte)s);
            this.adjustFreq -= 1.0;
        }
        byte[] byArray = this.convertArrayList(arrayList);
        return byArray;
    }

    public int queryVolume() {
        if (this.sourceDataLine != null && this.sourceDataLine.isRunning()) {
            float f = this.sourceDataLine.getLevel();
            if (f < -1.0f) {
                return 1;
            }
            return (int)((double)f * 25.0);
        }
        return -1;
    }

    public final int getSample() {
        return this.bufferSize - this.sourceDataLine.available() + this.qsize;
    }

    public void closeSound(boolean bl) {
        this.stopSound = bl;
    }

    public synchronized boolean querySoundClose() {
        return this.stopSound;
    }

    public boolean isStillPlaying(MC68000Cpu mC68000Cpu) {
        return !this.queueIsEmpty();
    }

    class PlayThread
    extends Thread {
        private final int sleepPeriod = 2;
        private final int waitPeriod = 3500;
        private boolean stopNow = false;

        PlayThread() {
        }

        @Override
        public void run() {
            int n = 0;
            while (true) {
                try {
                    while (true) {
                        byte[] byArray;
                        if (this.stopNow) {
                            SampledSound.this.sourceDataLine.flush();
                            SampledSound.this.sourceDataLine.stop();
                            this.stopNow = false;
                            SampledSound.this.isAsleep = true;
                            Thread.sleep(2000000000L);
                            SampledSound.this.isAsleep = false;
                            SampledSound.this.sourceDataLine.start();
                        }
                        if ((byArray = SampledSound.this.getFromQueue()) != null) {
                            if (!this.stopNow) {
                                SampledSound.this.sourceDataLine.write(byArray, 0, byArray.length);
                                PlayThread.sleep(1L);
                            }
                            n = 0;
                            continue;
                        }
                        if (SampledSound.this.querySoundClose()) {
                            n = this.waitPeriod;
                            SampledSound.this.closeSound(false);
                            SampledSound.this.sourceDataLine.drain();
                        }
                        if (++n >= this.waitPeriod) {
                            n = 0;
                            if (!SampledSound.this.queueIsEmpty()) continue;
                            SampledSound.this.isAsleep = true;
                            SampledSound.this.sourceDataLine.stop();
                            SampledSound.this.sourceDataLine.flush();
                            Thread.sleep(2000000000L);
                            SampledSound.this.isAsleep = false;
                            SampledSound.this.sourceDataLine.start();
                            continue;
                        }
                        this.getClass();
                        Thread.sleep(2L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    SampledSound.this.isAsleep = false;
                    SampledSound.this.sourceDataLine.start();
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        public void stopNow() {
            this.stopNow = true;
        }
    }
}

