/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import javax.swing.JPanel;
import smsqmulator.Monitor;
import smsqmulator.cpu.MC68000Cpu;

public abstract class Screen
extends JPanel {
    protected int startAddress;
    protected int stopAddress;
    protected int xsize = 512;
    protected int ysize = 256;
    protected int mode = 0;
    public volatile boolean isDirty = false;
    protected boolean isDouble = false;
    protected BufferedImage screenImage;
    protected WritableRaster raster;
    protected DataBufferInt dataBuffer;
    protected int nbrOfBytesPerLine;
    protected boolean vibrantColours = false;
    protected int divisior = 1;
    protected Monitor monitor;
    protected boolean isMac;
    private int oldX = -1;
    private int oldY = -1;
    private boolean isFullSize = false;
    private final Cursor myCursor;
    private boolean ignoreMoveEvent = false;
    private boolean mouseIsInScreen = true;
    private int mouseButtons = 0;
    private int mouseClickDelay = 0;
    private static final int[] CONV_CHAR = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 181, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 171, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 139, 157, 158, 159, 160, 179, 157, 96, 183, 158, 166, 182, 168, 127, 170, 184, 172, 173, 174, 175, 186, 177, 178, 179, 159, 176, 182, 183, 184, 185, 186, 185, 188, 189, 190, 180, 192, 193, 162, 161, 160, 197, 170, 168, 200, 163, 202, 203, 204, 205, 206, 207, 208, 169, 210, 211, 212, 165, 164, 215, 166, 217, 218, 219, 167, 221, 222, 156, 141, 140, 142, 129, 128, 130, 138, 136, 144, 131, 145, 143, 148, 147, 149, 146, 240, 137, 151, 150, 152, 133, 132, 187, 134, 154, 153, 155, 135, 253, 254, 255};
    protected final int[] pixelmask4 = new int[]{257, 514, 1028, 2056, 4112, 8224, 16448, 32896};
    protected final int[] pixelmask8 = new int[]{515, 2060, 8240, 32960};
    protected final int black;
    protected final int blue;
    protected final int red;
    protected final int green;
    protected final int magenta;
    protected final int yellow;
    protected final int orange;
    protected final int white;
    protected final int cyan;
    protected int copyMode;
    protected int QLmode;
    protected static int totsize;
    private static final int[][] KEYROW;
    private int[][] keyrowTable;
    private int mouseWheelAccel;

    public Screen(int n, int n2, Monitor monitor, boolean bl) {
        this.xsize = n;
        this.ysize = n2;
        totsize = n * n2;
        this.screenImage = new BufferedImage(n, n2, 1);
        this.raster = this.screenImage.getRaster();
        this.dataBuffer = (DataBufferInt)this.raster.getDataBuffer();
        Dimension dimension = new Dimension(n, n2);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.isDirty = true;
        this.monitor = monitor;
        this.isMac = bl;
        byte[] byArray = new byte[]{};
        Point point = new Point(0, 0);
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        this.myCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, point, "invisible_cursor");
        this.setMouseAndKeys();
        this.setupKeyrowArray();
        this.black = Color.black.getRGB();
        this.red = Color.red.getRGB();
        this.green = Color.green.getRGB();
        this.white = Color.white.getRGB();
        this.cyan = Color.cyan.getRGB();
        this.blue = Color.blue.getRGB();
        this.magenta = Color.magenta.getRGB();
        this.yellow = Color.yellow.getRGB();
        this.orange = Color.orange.getRGB();
        this.mouseWheelAccel = 1;
    }

    private void setupKeyrowArray() {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 8; ++n) {
                if (KEYROW[n2][n] <= n3) continue;
                n3 = KEYROW[n2][n];
            }
        }
        this.keyrowTable = new int[n3 + 1][2];
        for (n2 = 0; n2 < n3 + 1; ++n2) {
            this.keyrowTable[n2][0] = -1;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            n = 0;
            while (n < 8) {
                n3 = KEYROW[n2][n];
                this.keyrowTable[n3][0] = n2;
                this.keyrowTable[n3][1] = n++;
            }
        }
    }

    private void setMouseAndKeys() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Screen.this.screenPanelKeyTyped(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Screen.this.screenPanelKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Screen.this.screenPanelKeyReleased(keyEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Screen.this.requestFocusInWindow();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Screen.this.screenPanelMouseEntered(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Screen.this.screenPanelMouseExited(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Screen.this.screenPanelMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Screen.this.screenPanelMouseReleased(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Screen.this.screenPanelMouseMoved(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Screen.this.screenPanelMouseMoved(mouseEvent);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                int n2 = mouseWheelEvent.getWheelRotation();
                if (n2 == 0) {
                    return;
                }
                if (n2 < 0) {
                    n = mouseWheelEvent.isControlDown() ? 0xC10000 : 0xD10000;
                    n2 *= -1;
                } else {
                    n = mouseWheelEvent.isControlDown() ? 0xC90000 : 0xD90000;
                }
                n2 *= Screen.this.mouseWheelAccel;
                Screen.this.monitor.inputMouseWheel(--n2 + n);
                mouseWheelEvent.consume();
            }
        });
    }

    public void screenPanelKeyTyped(KeyEvent keyEvent) {
        if (this.monitor != null) {
            int n;
            if (this.isMac && ((n = keyEvent.getKeyCode()) == 17 || n == 18 || n == 152)) {
                keyEvent.consume();
                return;
            }
            n = keyEvent.getKeyChar();
            boolean bl = !this.isMac ? keyEvent.isAltDown() : keyEvent.isMetaDown();
            switch (n) {
                case 8: {
                    n = 194;
                    if (bl) {
                        bl = false;
                        n = 195;
                    }
                    if (!keyEvent.isShiftDown()) break;
                    n += 4;
                    break;
                }
                case 9: {
                    if (!keyEvent.isShiftDown()) break;
                    if (bl && keyEvent.isControlDown()) {
                        this.monitor.reset();
                        return;
                    }
                    n = 253;
                    break;
                }
                case 27: {
                    return;
                }
                case 32: {
                    if (keyEvent.isControlDown()) {
                        n = -1;
                    }
                    if (!keyEvent.isShiftDown()) break;
                    n = 252;
                    break;
                }
                case 127: {
                    n = 202;
                    if (bl) {
                        bl = false;
                        ++n;
                    }
                    if (!keyEvent.isShiftDown()) break;
                    n += 4;
                    break;
                }
                case 178: {
                    n = 35;
                    break;
                }
                case 8364: {
                    n = 181;
                    break;
                }
                case 65535: {
                    if (!this.isMac || !keyEvent.isControlDown()) break;
                    n = -1;
                    break;
                }
                default: {
                    if (n <= -1 || n >= 256) break;
                    n = CONV_CHAR[n];
                }
            }
            if (bl) {
                if (n == 202) {
                    n = 203;
                } else {
                    int n2 = n << 8;
                    n = n2 + 255;
                }
            }
            if (n < 27 && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
                n += 160;
            }
            this.monitor.inputKey(n);
            keyEvent.consume();
        }
    }

    public void screenPanelKeyPressed(KeyEvent keyEvent) {
        int n = 0;
        int n2 = keyEvent.getKeyCode();
        this.monitor.stopThrottle();
        if (n2 == 523) {
            n2 = 92;
        }
        this.setKeyrow(n2);
        switch (n2) {
            case 18: {
                keyEvent.consume();
                return;
            }
            case 27: {
                n = 27;
                break;
            }
            case 19: {
                n = -1;
                break;
            }
            case 145: {
                n = 249;
                break;
            }
            case 40: {
                n = 216;
                break;
            }
            case 38: {
                n = 208;
                break;
            }
            case 37: {
                n = 192;
                break;
            }
            case 39: {
                n = 200;
                break;
            }
            case 112: {
                n = 232;
                break;
            }
            case 113: {
                n = 236;
                break;
            }
            case 114: {
                n = 240;
                break;
            }
            case 115: {
                n = 244;
                break;
            }
            case 116: {
                n = 248;
                break;
            }
            case 117: {
                n = 234;
                break;
            }
            case 118: {
                n = 238;
                break;
            }
            case 119: {
                n = 242;
                break;
            }
            case 120: {
                n = 246;
                break;
            }
            case 121: {
                n = 250;
                break;
            }
            case 123: {
                n = 8447;
                break;
            }
            case 36: {
                n = 193;
                break;
            }
            case 35: {
                n = 201;
                break;
            }
            case 33: {
                n = 212;
                break;
            }
            case 34: {
                n = 220;
                break;
            }
            case 20: {
                try {
                    this.monitor.setCapsLockStatus(Toolkit.getDefaultToolkit().getLockingKeyState(20));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            case 10: {
                if (!keyEvent.isShiftDown()) break;
                n = 254;
                break;
            }
            default: {
                if (this.isMac && (keyEvent.isAltDown() || keyEvent.isControlDown()) || keyEvent.isMetaDown()) {
                    int n3 = keyEvent.getKeyChar();
                    n = keyEvent.getKeyCode();
                    if (n3 == 0 || n == 18 || n == 17 || n == 157) {
                        keyEvent.consume();
                        return;
                    }
                    if (!keyEvent.isShiftDown()) {
                        n3 = Character.toLowerCase((char)n3);
                        n = Character.toLowerCase(n);
                    } else {
                        n3 = Character.toUpperCase((char)n3);
                        n = Character.toUpperCase(n);
                    }
                    if (keyEvent.isControlDown() && n3 == 99 && !keyEvent.isShiftDown()) {
                        n3 = 3;
                    }
                    keyEvent.setKeyChar((char)n3);
                    keyEvent.setKeyCode(n);
                    this.screenPanelKeyTyped(keyEvent);
                    return;
                }
                return;
            }
        }
        switch (n) {
            case 232: 
            case 236: 
            case 240: 
            case 244: 
            case 248: {
                if (keyEvent.isControlDown()) {
                    ++n;
                }
                if (!keyEvent.isShiftDown()) break;
                n += 2;
                break;
            }
            case 192: 
            case 200: 
            case 208: 
            case 216: {
                if (keyEvent.isControlDown()) {
                    n += 2;
                }
                if (!keyEvent.isShiftDown()) break;
                n += 4;
            }
        }
        if (keyEvent.isAltDown()) {
            switch (n) {
                case 192: 
                case 194: 
                case 196: 
                case 200: 
                case 202: 
                case 204: 
                case 208: 
                case 210: 
                case 212: 
                case 216: 
                case 218: 
                case 220: {
                    ++n;
                    break;
                }
                case 8447: {
                    break;
                }
                default: {
                    if (n >= 256) break;
                    int n4 = n << 8;
                    n = n4 + 255;
                }
            }
        }
        this.monitor.inputKey(n);
    }

    public void screenPanelKeyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 523) {
            n = 92;
        }
        if (n < this.keyrowTable.length && this.keyrowTable[n][0] != -1) {
            this.monitor.removeKeyrow(this.keyrowTable[n][0], this.keyrowTable[n][1]);
        }
    }

    private void setKeyrow(int n) {
        if (n < this.keyrowTable.length && this.keyrowTable[n][0] != -1) {
            this.monitor.setKeyrow(this.keyrowTable[n][0], this.keyrowTable[n][1]);
        }
    }

    public void screenPanelMouseMoved(MouseEvent mouseEvent) {
        if (this.ignoreMoveEvent) {
            this.ignoreMoveEvent = false;
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.oldX < 0 || this.oldY < 0) {
            this.oldX = n;
            this.oldY = n2;
            return;
        }
        if (n != this.oldX || n2 != this.oldY) {
            int n3 = n - this.oldX;
            this.oldX = n;
            int n4 = n2 - this.oldY;
            this.oldY = n2;
            if (this.isDouble) {
                this.monitor.inputMouse(n3 / 2, n4 / 2, this.oldX / 2, this.oldY / 2);
            } else {
                this.monitor.inputMouse(n3, n4, this.oldX, this.oldY);
            }
        }
    }

    public boolean setMousePosition(int n, int n2) {
        if (this.mouseIsInScreen) {
            if (this.isDouble) {
                this.oldX = n * 2;
                this.oldY = n2 * 2;
            } else {
                this.oldX = n;
                this.oldY = n2;
            }
            this.ignoreMoveEvent = true;
        }
        return this.isDouble;
    }

    public void screenPanelMouseEntered(MouseEvent mouseEvent) {
        this.setCursor(this.myCursor);
        this.mouseIsInScreen = true;
    }

    public void screenPanelMouseExited(MouseEvent mouseEvent) {
        this.mouseIsInScreen = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.monitor.inputMouseButton(0);
    }

    public void screenPanelMousePressed(MouseEvent mouseEvent) {
        int n;
        switch (mouseEvent.getButton()) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.mouseButtons |= n;
        this.monitor.inputMouseButton(this.mouseButtons);
        if (this.mouseClickDelay != 0) {
            try {
                Thread.sleep(this.mouseClickDelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void screenPanelMouseReleased(MouseEvent mouseEvent) {
        int n;
        switch (mouseEvent.getButton()) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.mouseButtons &= ~n;
        this.monitor.inputMouseButton(this.mouseButtons);
    }

    public void setIsMac(boolean bl) {
        this.isMac = bl;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void setMouseClickDelay(int n) {
        this.mouseClickDelay = n;
    }

    public abstract void writeByteToScreen(int var1, int var2, int var3);

    public abstract void writeWordToScreen(int var1, int var2);

    public abstract void writeLongToScreen(int var1, int var2);

    public void setMode(int n) {
    }

    public void setEmuMode(int n) {
        this.QLmode = n == 8 ? 8 : 4;
    }

    public abstract void clearScreen();

    public abstract void xorBlock(MC68000Cpu var1, boolean var2);

    public abstract void fillBlock(MC68000Cpu var1, boolean var2);

    public abstract void moveBlock(MC68000Cpu var1, boolean var2);

    public abstract void combineBlocks(MC68000Cpu var1);

    public abstract void displayRegion(MC68000Cpu var1, int var2, int var3);

    public abstract void setVramBase(int var1);

    public abstract void setVibrantColours(boolean var1, short[] var2);

    public abstract int getScreenSizeInBytes();

    public abstract boolean isQLScreen();

    public final void setQLEmulationMode(int n) {
        this.copyMode = n;
    }

    public int getDivisor() {
        return this.divisior;
    }

    public boolean isVibrantColours() {
        return this.vibrantColours;
    }

    public final int getScreenBase() {
        return this.startAddress;
    }

    public final int getScreenTop() {
        return this.stopAddress;
    }

    public final int getXSize() {
        return this.xsize;
    }

    public final int getYSize() {
        return this.ysize;
    }

    public final int getLineSize() {
        return this.nbrOfBytesPerLine;
    }

    public final int getMode() {
        return this.mode;
    }

    @Override
    public final Dimension getPreferredSize() {
        if (this.isFullSize) {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        if (this.isDouble) {
            return new Dimension(this.screenImage.getWidth() * 2, this.screenImage.getHeight() * 2);
        }
        return new Dimension(this.screenImage.getWidth(), this.screenImage.getHeight());
    }

    public final Dimension getImageSize() {
        return new Dimension(this.screenImage.getWidth(), this.screenImage.getHeight());
    }

    public final void setDoubleSize(boolean bl) {
        this.isDouble = bl;
    }

    public boolean mouseInScreen() {
        return this.mouseIsInScreen;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.isDirty = false;
        graphics.drawImage(this.screenImage, 0, 0, dimension.width, dimension.height, null);
    }

    public final void fillScreen(Color color) {
        this.fillScreen(color.getRGB());
    }

    public final void fillScreen(int n) {
        int[] nArray = new int[this.xsize * this.ysize];
        for (int i = 0; i < this.xsize * this.ysize; ++i) {
            nArray[i] = n;
        }
        this.raster.setDataElements(0, 0, this.xsize, this.ysize, nArray);
        this.isDirty = true;
    }

    public final void setFullSize(boolean bl) {
        this.isFullSize = bl;
    }

    public void copyScreen(MC68000Cpu mC68000Cpu, int n, int n2) {
        if (this.xsize < 512 || this.ysize < 256) {
            return;
        }
        int n3 = (n -= 131072) / 128;
        int n4 = n - n3 * 128;
        int n5 = this.copyMode == -1 ? this.QLmode : this.copyMode;
        n4 = n5 == 4 ? (n4 *= 4) : (n4 *= 2);
        this.setPixels(n4, n3, n2, n5);
        this.isDirty = true;
    }

    protected void setPixels(int n, int n2, int n3, int n4) {
        n2 *= this.xsize;
        switch (n4) {
            case 4: {
                n += 7;
                for (int i = 0; i < 8; ++i) {
                    int n5;
                    int n6 = (n3 & this.pixelmask4[i]) >>> i;
                    switch (n6) {
                        case 0: {
                            n5 = this.black;
                            break;
                        }
                        case 1: {
                            n5 = this.red;
                            break;
                        }
                        case 256: {
                            n5 = this.green;
                            break;
                        }
                        case 257: {
                            n5 = this.white;
                            break;
                        }
                        default: {
                            n5 = this.blue;
                        }
                    }
                    this.dataBuffer.setElem(n + n2, n5);
                    --n;
                }
                break;
            }
            case 8: {
                n += 3;
                for (int i = 0; i < 4; ++i) {
                    int n7;
                    int n8 = (n3 & this.pixelmask8[i]) >>> i * 2;
                    switch (n8) {
                        case 0: {
                            n7 = this.black;
                            break;
                        }
                        case 1: {
                            n7 = this.blue;
                            break;
                        }
                        case 2: {
                            n7 = this.red;
                            break;
                        }
                        case 3: {
                            n7 = this.magenta;
                            break;
                        }
                        case 512: {
                            n7 = this.green;
                            break;
                        }
                        case 513: {
                            n7 = this.cyan;
                            break;
                        }
                        case 514: {
                            n7 = this.yellow;
                            break;
                        }
                        case 515: {
                            n7 = this.white;
                            break;
                        }
                        default: {
                            n7 = this.orange;
                        }
                    }
                    this.dataBuffer.setElem(n * 2 + n2, n7);
                    this.dataBuffer.setElem(n * 2 + n2 + 1, n7);
                    --n;
                }
                break;
            }
        }
    }

    public final void setDisplayRegion(int n, int n2, short[] sArray) {
        int n3;
        int n4;
        int n5 = (n &= 0xFFFFFFFE) - 131072;
        int n6 = n5 / 128;
        int n7 = n5 - n6 * 128;
        int n8 = this.copyMode == -1 ? this.QLmode : this.copyMode;
        if (n8 == 4) {
            n7 *= 4;
            n4 = 512;
            n3 = 8;
        } else {
            n7 *= 2;
            n4 = 256;
            n3 = 4;
        }
        int n9 = n2 / 128 + n6;
        n /= 2;
        while (n6 < n9) {
            while (n7 < n4) {
                int n10 = sArray[n++] & 0xFFFF;
                this.setPixels(n7, n6, n10, n8);
                n7 += n3;
            }
            n7 = 0;
            ++n6;
        }
    }

    public void setMousewheelAccel(int n) {
        this.mouseWheelAccel = n;
    }

    static {
        KEYROW = new int[][]{{115, 112, 53, 113, 114, 116, 52, 55}, {10, 37, 38, 27, 39, 92, 32, 40}, {93, 90, 46, 67, 66, 515, 77, 222}, {91, 20, 75, 83, 70, 61, 71, 59}, {76, 51, 72, 49, 65, 80, 68, 74}, {57, 87, 73, 9, 82, 45, 89, 79}, {56, 50, 54, 81, 69, 512, 84, 85}, {16, 17, 18, 88, 86, 47, 78, 44}};
    }
}

