/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import smsqmulator.Monitor;
import smsqmulator.Screen;
import smsqmulator.cpu.MC68000Cpu;

public class Screen16
extends Screen {
    private final byte[] vramBuffer;
    private static final int[] clut = new int[]{0, 0x200020, 8192, 0x202020, 72, 2097256, 8264, 2105448, 0x480000, 6815776, 4726784, 6823968, 0x480048, 0x680068, 4726856, 6824040, 18432, 2115616, 26624, 2123808, 18504, 2115688, 26696, 2123880, 0x484800, 6834208, 4745216, 6842400, 0x484848, 0x684868, 0x486848, 0x686868, 144, 0x2000B0, 8336, 0x2020B0, 216, 2097400, 8408, 2105592, 4718736, 6815920, 4726928, 6824112, 4718808, 6815992, 4727000, 6824184, 18576, 2115760, 26768, 2123952, 18648, 2115832, 26840, 2124024, 4737168, 6834352, 4745360, 6842544, 0x4848D8, 6834424, 4745432, 0x6868F8, 0x900000, 0xB00020, 0x902000, 0xB02020, 9437256, 11534440, 9445448, 11542632, 0xD80000, 16252960, 14163968, 16261152, 14155848, 16253032, 14164040, 16261224, 9455616, 11552800, 9463808, 11560992, 9455688, 11552872, 9463880, 11561064, 14174208, 16271392, 14182400, 16279584, 0xD84848, 16271464, 14182472, 0xF86868, 0x900090, 0xB000B0, 0x902090, 0xB020B0, 9437400, 11534584, 9445592, 11542776, 14155920, 16253104, 14164112, 16261296, 0xD800D8, 0xF800F8, 14164184, 16261368, 9455760, 11552944, 9463952, 11561136, 9455832, 11553016, 9464024, 11561208, 14174352, 16271536, 14182544, 16279728, 0xD848D8, 0xF848F8, 0xD868D8, 0xF868F8, 36864, 0x209020, 45056, 0x20B020, 36936, 2134120, 45128, 2142312, 4755456, 6852640, 4763648, 6860832, 4755528, 6852712, 4763720, 6860904, 55296, 2152480, 63488, 2160672, 55368, 2152552, 63560, 2160744, 4773888, 6871072, 4782080, 6879264, 0x48D848, 0x68D868, 0x48F848, 0x68F868, 37008, 2134192, 45200, 0x20B0B0, 37080, 2134264, 45272, 2142456, 4755600, 6852784, 4763792, 6860976, 4755672, 6852856, 4763864, 6861048, 55440, 2152624, 63632, 2160816, 55512, 2152696, 63704, 2160888, 4774032, 6871216, 4782224, 6879408, 0x48D8D8, 6871288, 4782296, 0x68F8F8, 0x909000, 11571232, 0x90B000, 0xB0B020, 9474120, 11571304, 9482312, 11579496, 14192640, 16289824, 14200832, 16298016, 14192712, 16289896, 14200904, 16298088, 9492480, 11589664, 9500672, 11597856, 9492552, 11589736, 9500744, 11597928, 0xD8D800, 16308256, 14219264, 16316448, 0xD8D848, 16308328, 14219336, 0xF8F868, 0x909090, 0xB090B0, 0x90B090, 0xB0B0B0, 9474264, 11571448, 9482456, 11579640, 14192784, 16289968, 14200976, 16298160, 14192856, 16290040, 14201048, 16298232, 9492624, 11589808, 9500816, 11598000, 9492696, 11589880, 9500888, 11598072, 14211216, 16308400, 14219408, 16316592, 0xD8D8D8, 0xF8D8F8, 0xD8F8D8, 0xF8F8F8};
    private static final short[] rgb2aur_tab = new short[]{0, 0, 4, 5, 32, 33, 36, 37, 2, 2, 6, 7, 34, 35, 38, 39, 16, 16, 20, 21, 48, 49, 52, 53, 18, 18, 22, 23, 50, 51, 54, 55, 128, 128, 132, 133, 160, 161, 164, 165, 130, 130, 134, 135, 162, 163, 166, 167, 144, 144, 148, 149, 176, 177, 180, 181, 146, 146, 150, 151, 178, 179, 182, 183, 1, 1, 4, 5, 32, 33, 36, 37, 3, 3, 6, 7, 34, 35, 38, 39, 17, 17, 20, 21, 48, 49, 52, 53, 19, 19, 22, 23, 50, 51, 54, 55, 129, 129, 132, 133, 160, 161, 164, 165, 131, 131, 134, 135, 162, 163, 166, 167, 145, 145, 148, 149, 176, 177, 180, 181, 147, 147, 150, 151, 178, 179, 182, 183, 8, 8, 12, 5, 40, 33, 44, 37, 10, 10, 14, 7, 42, 35, 46, 39, 24, 24, 28, 21, 56, 49, 60, 53, 26, 26, 30, 23, 58, 51, 62, 55, 136, 136, 140, 133, 168, 161, 172, 165, 138, 138, 142, 135, 170, 163, 174, 167, 152, 152, 156, 149, 184, 177, 188, 181, 154, 154, 158, 151, 186, 179, 190, 183, 9, 9, 9, 13, 40, 41, 44, 45, 11, 11, 11, 15, 42, 43, 46, 47, 25, 25, 25, 29, 56, 57, 60, 61, 27, 27, 27, 31, 58, 59, 62, 63, 137, 137, 137, 141, 168, 169, 172, 173, 139, 139, 139, 143, 170, 171, 174, 175, 153, 153, 153, 157, 184, 185, 188, 189, 155, 155, 155, 159, 186, 187, 190, 191, 64, 64, 68, 68, 96, 41, 100, 45, 66, 66, 70, 70, 98, 43, 102, 47, 80, 80, 84, 84, 112, 57, 116, 61, 82, 82, 86, 86, 114, 59, 118, 63, 192, 192, 196, 196, 224, 169, 228, 173, 194, 194, 198, 198, 226, 171, 230, 175, 208, 208, 212, 212, 240, 185, 244, 189, 210, 210, 214, 214, 242, 187, 246, 191, 65, 65, 65, 69, 69, 97, 100, 101, 67, 67, 67, 71, 71, 99, 102, 103, 81, 81, 81, 85, 85, 113, 116, 117, 83, 83, 83, 87, 87, 115, 118, 119, 193, 193, 193, 197, 197, 225, 228, 229, 195, 195, 195, 199, 199, 227, 230, 231, 209, 209, 209, 213, 213, 241, 244, 245, 211, 211, 211, 215, 215, 243, 246, 247, 72, 72, 76, 76, 104, 104, 108, 101, 74, 74, 78, 78, 106, 106, 110, 103, 88, 88, 92, 92, 120, 120, 124, 117, 90, 90, 94, 94, 122, 122, 126, 119, 200, 200, 204, 204, 232, 232, 236, 229, 202, 202, 206, 206, 234, 234, 238, 231, 216, 216, 220, 220, 248, 248, 252, 245, 218, 218, 222, 222, 250, 250, 254, 247, 73, 73, 73, 77, 77, 105, 105, 109, 75, 75, 75, 79, 79, 107, 107, 111, 89, 89, 89, 93, 93, 121, 121, 125, 91, 91, 91, 95, 95, 123, 123, 127, 201, 201, 201, 205, 205, 233, 233, 237, 203, 203, 203, 207, 207, 235, 235, 239, 217, 217, 217, 221, 221, 249, 249, 253, 219, 219, 219, 223, 223, 251, 251, 255};

    public Screen16(int n, int n2, int n3, boolean bl, Monitor monitor, boolean bl2) {
        super(n, n2, monitor, bl2);
        this.mode = 16;
        this.divisior = 2;
        this.vibrantColours = bl;
        if (this.vibrantColours) {
            this.makeBrightness(false, null);
        }
        this.stopAddress = n * n2;
        this.nbrOfBytesPerLine = n;
        this.startAddress = n3;
        this.vramBuffer = new byte[n * n2];
    }

    @Override
    public void writeByteToScreen(int n, int n2, int n3) {
        if ((n -= this.startAddress) >= totsize) {
            return;
        }
        n2 = clut[n2 & 0xFF];
        if (this.dataBuffer.getElem(n) != n2) {
            this.dataBuffer.setElem(n, n2);
            this.isDirty = true;
        }
    }

    @Override
    public void writeWordToScreen(int n, int n2) {
        this.writeByteToScreen(n, n2 >>> 8, 0);
        this.writeByteToScreen(++n, n2, 0);
    }

    @Override
    public void writeLongToScreen(int n, int n2) {
        this.writeByteToScreen(n++, n2 >>> 24, 0);
        this.writeByteToScreen(n++, n2 >>> 16, 0);
        this.writeByteToScreen(n++, n2 >>> 8, 0);
        this.writeByteToScreen(n, n2, 0);
    }

    @Override
    public void clearScreen() {
        int[] nArray = new int[this.xsize * this.ysize];
        this.raster.setDataElements(0, 0, this.xsize, this.ysize, nArray);
        this.isDirty = true;
    }

    private static void writeByte(byte n, int n2, short[] sArray) {
        int n3 = n2 / 2;
        short s = sArray[n3];
        int n4 = n;
        if ((n2 & 1) == 1) {
            s = (short)(s & 0xFF00);
            n4 &= 0xFF;
        } else {
            s = (short)(s & 0xFF);
            n4 = n4 << 8 & 0xFF00;
        }
        sArray[n3] = (short)(s | n4);
    }

    private static int readByte(int n, short[] sArray) {
        if ((n & 1) == 1) {
            return sArray[n / 2] & 0xFF;
        }
        return sArray[n / 2] >>> 8 & 0xFF;
    }

    private void getColoursFromStipple(int[] nArray) {
        int n = nArray[0] & 3;
        int n2 = nArray[1];
        int n3 = n2 & 0xFF;
        int n4 = n2 >>> 8 & 0xFF;
        nArray[0] = n2;
        switch (n) {
            case 0: {
                nArray[1] = nArray[1] & 0xFF00;
                nArray[1] = nArray[1] | n4;
                break;
            }
            case 1: {
                nArray[0] = n4 << 8 | n4;
                nArray[1] = n3 << 8 | n3;
                break;
            }
            case 3: {
                nArray[0] = n3 << 8 | n4;
            }
        }
        n2 = (nArray[0] & 0xFFFF) << 16;
        nArray[0] = nArray[0] & 0xFFFF;
        nArray[0] = nArray[0] | n2;
        n2 = (nArray[1] & 0xFFFF) << 16;
        nArray[1] = nArray[1] & 0xFFFF;
        nArray[1] = nArray[1] | n2;
    }

    @Override
    public void fillBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        if (mC68000Cpu.data_regs[1] == 0) {
            return;
        }
        int n = mC68000Cpu.data_regs[2] >>> 16;
        int n2 = mC68000Cpu.data_regs[2] & 0xFFFF;
        int n3 = mC68000Cpu.data_regs[1] >>> 16;
        int n4 = mC68000Cpu.data_regs[1] & 0xFFFF;
        if (n + n3 > this.xsize && (n3 = this.xsize - n - 1) < 1) {
            return;
        }
        if (n2 + n4 > this.ysize && (n4 = this.ysize - n2 - 1) < 1) {
            return;
        }
        short[] sArray = mC68000Cpu.getMemory();
        boolean bl2 = mC68000Cpu.addr_regs[1] >= this.startAddress && mC68000Cpu.addr_regs[1] <= this.stopAddress;
        int[] nArray = new int[]{mC68000Cpu.data_regs[6], mC68000Cpu.data_regs[7]};
        if (bl) {
            this.getColoursFromStipple(nArray);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if ((n & 1) != 0) {
            bl3 = true;
            --n3;
        }
        if ((n3 & 1) != 0) {
            bl4 = true;
            --n3;
        }
        int n5 = n3 / 2;
        boolean bl5 = (n2 & 1) == 0;
        short s = (short)(nArray[0] >>> 8 & 0xFF);
        int n6 = clut[s & 0xFF];
        short s2 = (short)(nArray[0] & 0xFF);
        int n7 = clut[s2 & 0xFF];
        short s3 = (short)(nArray[0] & 0xFFFF);
        short s4 = (short)(nArray[1] >>> 8 & 0xFF);
        int n8 = clut[s4 & 0xFF];
        short s5 = (short)(nArray[1] & 0xFF);
        int n9 = clut[s5 & 0xFF];
        short s6 = (short)(nArray[1] & 0xFFFF);
        int n10 = mC68000Cpu.addr_regs[2];
        int n11 = n2 * n10 + n;
        n11 += mC68000Cpu.addr_regs[1];
        n11 /= 2;
        n10 /= 2;
        n2 *= this.xsize;
        for (int i = 0; i < n4; ++i) {
            int n12;
            int n13 = n + n2;
            int n14 = n11;
            if (bl3) {
                if (bl5) {
                    n12 = sArray[n14] & 0xFF00;
                    sArray[n14++] = (short)((n12 |= s2 & 0xFF) & 0xFFFF);
                    if (bl2) {
                        this.dataBuffer.setElem(n13++, n7);
                    }
                } else {
                    n12 = sArray[n14] & 0xFF00;
                    sArray[n14++] = (short)((n12 |= s5 & 0xFF) & 0xFFFF);
                    if (bl2) {
                        this.dataBuffer.setElem(n13++, n9);
                    }
                }
            }
            for (int j = 0; j < n5; ++j) {
                if (bl5) {
                    sArray[n14++] = s3;
                    if (!bl2) continue;
                    this.dataBuffer.setElem(n13++, n6);
                    this.dataBuffer.setElem(n13++, n7);
                    continue;
                }
                sArray[n14++] = s6;
                if (!bl2) continue;
                this.dataBuffer.setElem(n13++, n8);
                this.dataBuffer.setElem(n13++, n9);
            }
            if (bl4) {
                if (bl5) {
                    n12 = sArray[n14] & 0xFF;
                    sArray[n14++] = (short)((n12 |= s << 8 & 0xFF00) & 0xFFFF);
                    if (bl2) {
                        this.dataBuffer.setElem(n13++, n6);
                    }
                } else {
                    n12 = sArray[n14] & 0xFF;
                    sArray[n14++] = (short)((n12 |= s4 << 8 & 0xFF00) & 0xFFFF);
                    if (bl2) {
                        this.dataBuffer.setElem(n13++, n8);
                    }
                }
            }
            n11 += n10;
            n2 += this.xsize;
            bl5 = !bl5;
        }
        this.isDirty = true;
    }

    @Override
    public void xorBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        int n = mC68000Cpu.data_regs[2] >>> 16;
        int n2 = mC68000Cpu.data_regs[2] & 0xFFFF;
        int n3 = mC68000Cpu.data_regs[1] >>> 16;
        int n4 = mC68000Cpu.data_regs[1] & 0xFFFF;
        if (mC68000Cpu.data_regs[1] == 0) {
            return;
        }
        if (n + n3 > this.xsize && (n3 = this.xsize - n - 1) < 1) {
            return;
        }
        if (n2 + n4 > this.ysize && (n4 = this.ysize - n2 - 1) < 1) {
            return;
        }
        short[] sArray = mC68000Cpu.getMemory();
        boolean bl2 = mC68000Cpu.addr_regs[1] >= this.startAddress && mC68000Cpu.addr_regs[1] < this.stopAddress;
        int[] nArray = new int[]{mC68000Cpu.data_regs[6], mC68000Cpu.data_regs[7]};
        if (bl) {
            this.getColoursFromStipple(nArray);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if ((n & 1) != 0) {
            bl3 = true;
            --n3;
        }
        if ((n3 & 1) != 0) {
            bl4 = true;
            --n3;
        }
        int n5 = n3 / 2;
        boolean bl5 = (n2 & 1) == 0;
        short s = (short)(nArray[0] >>> 8 & 0xFF);
        int n6 = clut[s & 0xFF];
        short s2 = (short)(nArray[0] & 0xFF);
        int n7 = clut[s2 & 0xFF];
        int n8 = nArray[0] & 0xFFFF;
        short s3 = (short)(nArray[1] >>> 8 & 0xFF);
        int n9 = clut[s3 & 0xFF];
        short s4 = (short)(nArray[1] & 0xFF);
        int n10 = clut[s4 & 0xFF];
        int n11 = nArray[1] & 0xFFFF;
        int n12 = mC68000Cpu.addr_regs[2];
        int n13 = n2 * n12 + n;
        n13 += mC68000Cpu.addr_regs[1];
        n13 /= 2;
        n12 /= 2;
        n2 *= this.xsize;
        for (int i = 0; i < n4; ++i) {
            int n14;
            int n15;
            int n16 = n + n2;
            int n17 = n13;
            if (bl3) {
                if (bl5) {
                    n15 = sArray[n17] & 0xFF;
                    n14 = sArray[n17] & 0xFF00;
                    sArray[n17++] = (short)((n14 |= (n15 ^= s2 & 0xFF) & 0xFF) & 0xFFFF);
                    if (bl2) {
                        this.dataBuffer.setElem(n16, this.dataBuffer.getElem(n16++) ^ n7);
                    }
                } else {
                    n15 = sArray[n17] & 0xFF;
                    n14 = sArray[n17] & 0xFF00;
                    sArray[n17++] = (short)((n14 |= (n15 ^= s4 & 0xFF) & 0xFF) & 0xFFFF);
                    if (bl2) {
                        this.dataBuffer.setElem(n16, this.dataBuffer.getElem(n16++) ^ n10);
                    }
                }
            }
            for (int j = 0; j < n5; ++j) {
                if (bl5) {
                    n14 = sArray[n17] ^ n8;
                    sArray[n17++] = (short)n14;
                    if (!bl2) continue;
                    this.dataBuffer.setElem(n16, this.dataBuffer.getElem(n16++) ^ n6);
                    this.dataBuffer.setElem(n16, this.dataBuffer.getElem(n16++) ^ n7);
                    continue;
                }
                n14 = sArray[n17] ^ n11;
                sArray[n17++] = (short)n14;
                if (!bl2) continue;
                this.dataBuffer.setElem(n16, this.dataBuffer.getElem(n16++) ^ n9);
                this.dataBuffer.setElem(n16, this.dataBuffer.getElem(n16++) ^ n10);
            }
            if (bl4) {
                if (bl5) {
                    n15 = sArray[n17] & 0xFF00;
                    n14 = sArray[n17] & 0xFF;
                    sArray[n17++] = (short)((n14 |= (n15 ^= s << 8 & 0xFF00)) & 0xFFFF);
                    if (bl2) {
                        this.dataBuffer.setElem(n16, this.dataBuffer.getElem(n16++) ^ n6);
                    }
                } else {
                    n15 = sArray[n17] & 0xFF00;
                    n14 = sArray[n17] & 0xFF;
                    sArray[n17++] = (short)(n14 |= (n15 ^= s3 << 8 & 0xFF00));
                    if (bl2) {
                        this.dataBuffer.setElem(n16, this.dataBuffer.getElem(n16++) ^ n9);
                    }
                }
            }
            n13 += n12;
            n2 += this.xsize;
            bl5 = !bl5;
        }
        this.isDirty = true;
    }

    @Override
    public void moveBlock(MC68000Cpu mC68000Cpu, boolean bl) {
        if (bl) {
            int n = mC68000Cpu.data_regs[1] >>> 16 & 0xFFFF;
            int n2 = mC68000Cpu.data_regs[1] & 0xFFFF;
            int n3 = mC68000Cpu.data_regs[2] >>> 16 & 0xFFFF;
            int n4 = mC68000Cpu.data_regs[2] & 0xFFFF;
            int n5 = mC68000Cpu.data_regs[3] >>> 16 & 0xFFFF;
            int n6 = mC68000Cpu.data_regs[3] & 0xFFFF;
            int[] nArray = new int[n * n2];
            this.raster.getDataElements(n3, n4, n, n2, nArray);
            this.raster.setDataElements(n5, n6, n, n2, nArray);
            this.isDirty = true;
        } else {
            this.paintBlock(mC68000Cpu.data_regs[1], mC68000Cpu.data_regs[3], mC68000Cpu.getMemory());
        }
    }

    @Override
    public void combineBlocks(MC68000Cpu mC68000Cpu) {
        int n = mC68000Cpu.addr_regs[4];
        int n2 = mC68000Cpu.addr_regs[1];
        int n3 = mC68000Cpu.addr_regs[5];
        if (n3 < this.startAddress || n >= this.startAddress || n2 >= this.startAddress) {
            mC68000Cpu.data_regs[0] = -14;
            return;
        }
        int n4 = mC68000Cpu.data_regs[6] & 0xFF;
        double d = (double)n4 / 255.0;
        int n5 = mC68000Cpu.data_regs[1] >>> 16 & 0xFFFF;
        int n6 = mC68000Cpu.data_regs[1] & 0xFFFF;
        int n7 = mC68000Cpu.data_regs[2] >>> 16 & 0xFFFF;
        int n8 = mC68000Cpu.data_regs[2] & 0xFFFF;
        int n9 = mC68000Cpu.data_regs[3] >>> 16 & 0xFFFF;
        int n10 = mC68000Cpu.data_regs[3] & 0xFFFF;
        int n11 = mC68000Cpu.addr_regs[2];
        n += n8 * n11 + n7;
        int n12 = mC68000Cpu.addr_regs[3];
        n3 = n10 * n12 + n9 + this.startAddress;
        short[] sArray = mC68000Cpu.getMemory();
        n2 += n10 * (n12 + 4) + n9;
        int n13 = mC68000Cpu.data_regs[7];
        for (int i = 0; i < n6; ++i) {
            int n14 = n;
            int n15 = n2;
            for (int j = 0; j < n5; ++j) {
                int n16 = mC68000Cpu.readMemoryByte(n14++);
                int n17 = mC68000Cpu.readMemoryByte(n15++);
                n16 = clut[n16];
                n17 = clut[n17];
                int n18 = n16 >>> 16;
                int n19 = n16 >>> 8 & 0xFF;
                int n20 = n16 & 0xFF;
                int n21 = n17 >>> 16;
                int n22 = n17 >>> 8 & 0xFF;
                int n23 = n17 & 0xFF;
                n21 = (int)((double)n18 * d + (double)n21 * (1.0 - d));
                n22 = (int)((double)n19 * d + (double)n22 * (1.0 - d));
                n23 = (int)((double)n20 * d + (double)n23 * (1.0 - d));
                n21 = (n21 & 0xE0) << 1;
                n22 = n22 >>> 2 & 0x38;
                n23 = n23 >>> 5 & 7;
                n21 |= n22;
                byte by = (byte)(rgb2aur_tab[n21 |= n23] & 0x1FF);
                Screen16.writeByte(by, n3 + j, sArray);
            }
            n += n11;
            n3 += n12;
            n2 += n13;
        }
        this.paintBlock(mC68000Cpu.data_regs[1], mC68000Cpu.data_regs[3], sArray);
        mC68000Cpu.data_regs[0] = 0;
    }

    private void paintBlock(int n, int n2, short[] sArray) {
        int n3 = n >>> 16;
        n &= 0xFFFF;
        int n4 = n2 >>> 16;
        int n5 = (n2 &= 0xFFFF) * this.xsize + n4 + this.startAddress;
        int n6 = 0;
        while (n6 < n) {
            for (int i = n5; i < n3 + n5; ++i) {
                int n7 = Screen16.readByte(i, sArray) & 0xFF;
                this.dataBuffer.setElem(i - this.startAddress, clut[n7]);
            }
            ++n6;
            n5 += this.xsize;
        }
        this.isDirty = true;
    }

    @Override
    public void displayRegion(MC68000Cpu mC68000Cpu, int n, int n2) {
        if (this.stopAddress < n + n2) {
            n2 -= n + n2 - this.stopAddress;
        }
        if (n < this.startAddress) {
            n2 -= this.startAddress - n;
            n = this.startAddress;
        }
        if (n2 < 1) {
            return;
        }
        short[] sArray = mC68000Cpu.getMemory();
        for (int i = n; i < n2 + n; ++i) {
            int n3 = Screen16.readByte(i, sArray);
            this.dataBuffer.setElem(i - this.startAddress, clut[n3]);
        }
        this.isDirty = true;
    }

    @Override
    public synchronized void setVramBase(int n) {
        this.startAddress = n;
        this.stopAddress = n + this.getScreenSizeInBytes();
    }

    @Override
    public void setVibrantColours(boolean bl, short[] sArray) {
        this.vibrantColours = bl;
        this.makeBrightness(true, sArray);
    }

    private void makeBrightness(boolean bl, short[] sArray) {
        int n;
        int n2;
        int n3;
        if (this.vibrantColours) {
            n3 = 459527;
            for (n2 = 0; n2 < clut.length; ++n2) {
                Screen16.clut[n2] = n = clut[n2] | n3;
            }
        } else {
            n3 = 0xF8FCF8;
            for (n2 = 0; n2 < clut.length; ++n2) {
                Screen16.clut[n2] = n = clut[n2] & n3;
            }
        }
        if (bl) {
            for (n3 = 0; n3 < this.xsize * this.ysize; ++n3) {
                n = Screen16.readByte(n3 + this.startAddress, sArray);
                this.dataBuffer.setElem(n3, clut[n]);
            }
        }
    }

    @Override
    public final int getScreenSizeInBytes() {
        return this.xsize * this.ysize;
    }

    @Override
    public boolean isQLScreen() {
        return false;
    }
}

