/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import smsqmulator.Monitor;
import smsqmulator.XfaFileheader;
import smsqmulator.cpu.MC68000Cpu;

public class SfaFileheader
implements XfaFileheader {
    private final ByteBuffer header = ByteBuffer.allocate(68);
    private static final int hOffset = 4;

    public SfaFileheader(File file, String string, FileChannel fileChannel, int n) throws IOException {
        long l = 0L;
        if (fileChannel != null) {
            l = fileChannel.size();
        }
        if (l != 0L) {
            if (l < 68L) {
                throw new IOException();
            }
            fileChannel.read(this.header);
            if (this.header.getInt(0) != 1397113136) {
                throw new IOException();
            }
        } else {
            this.header.putInt(0, 1397113136);
            if (file.isDirectory()) {
                this.header.putInt(4, n);
                this.header.putShort(8, (short)255);
            } else {
                this.header.putInt(4, 0);
                int n2 = (int)(System.currentTimeMillis() / 1000L + (long)Monitor.TIME_OFFSET);
                this.header.putInt(56, n2);
                this.header.putShort(60, (short)0);
                this.header.putShort(62, (short)0);
                this.header.putInt(64, n2);
            }
        }
        this.setSMSQEFilename(string);
    }

    @Override
    public int readFileheader(MC68000Cpu mC68000Cpu, int n, int n2) {
        if (n2 > 64) {
            n2 = 64;
        }
        for (int i = 0; i < n2; ++i) {
            mC68000Cpu.writeMemoryByte(n + i, this.header.get(4 + i));
        }
        return n2;
    }

    @Override
    public int writeFileHeader(MC68000Cpu mC68000Cpu, int n) {
        for (int i = 0; i < 14; ++i) {
            this.header.put(4 + i, (byte)(mC68000Cpu.readMemoryByte(n + i) & 0xFF));
        }
        return 14;
    }

    @Override
    public boolean flushHeader(FileChannel fileChannel, boolean bl) {
        if (fileChannel == null) {
            return false;
        }
        try {
            int n = (int)fileChannel.size();
            if (n != 0) {
                n -= 68;
            }
            this.header.putInt(4, n);
            if (bl) {
                n = (int)(System.currentTimeMillis() / 1000L + (long)Monitor.TIME_OFFSET);
                this.header.putInt(56, n);
            }
            long l = fileChannel.position();
            fileChannel.position(0L);
            this.header.position(0);
            fileChannel.write(this.header);
            this.header.position(0);
            fileChannel.position(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getOffset() {
        return 68;
    }

    @Override
    public String getSMSQEFilename() {
        int n = this.header.getShort(18);
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((char)this.header.get(20 + i));
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSMSQEFilename(String string) {
        int n = string.length() & 0xFF;
        if (n > 34) {
            n = 34;
        }
        this.header.putShort(18, (short)n);
        for (int i = 0; i < n; ++i) {
            this.header.put(20 + i, (byte)string.charAt(i));
        }
    }

    @Override
    public int getDate(int n) {
        return this.header.getInt(56 + 4 * n);
    }

    @Override
    public void setDate(int n, int n2) {
        this.header.putInt(56 + 4 * n, n2);
    }

    @Override
    public int getVersion() {
        return this.header.getShort(60) & 0xFFFF;
    }

    @Override
    public void setVersion(int n) {
        this.header.putShort(60, (short)(n & 0xFFFF));
    }

    @Override
    public void setFileDates(File file) {
    }
}

