/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.util.ArrayList;
import smsqmulator.SampledSound;
import smsqmulator.cpu.MC68000Cpu;

public class SoundDevice {
    private ArrayList<byte[]> buffer;
    private int counter = 0;
    private boolean channelClosed = true;
    private int deviceType;
    private int av;
    private int av1;
    private final SampledSound sam;

    public SoundDevice(SampledSound sampledSound) {
        this.sam = sampledSound;
    }

    public void openChannel(MC68000Cpu mC68000Cpu) {
        if (!this.channelClosed) {
            mC68000Cpu.data_regs[0] = -9;
        } else {
            this.deviceType = mC68000Cpu.data_regs[2] & 0xFF;
            this.buffer = new ArrayList();
            this.counter = 0;
            this.av1 = 128;
            this.av = 128;
            this.channelClosed = false;
            mC68000Cpu.data_regs[0] = 0;
        }
    }

    public void closeChannel() {
        this.channelClosed = true;
    }

    public void doIO(MC68000Cpu mC68000Cpu) {
        if (this.channelClosed) {
            mC68000Cpu.data_regs[0] = -6;
            return;
        }
        switch (mC68000Cpu.data_regs[4]) {
            case 5: {
                byte[] byArray = new byte[]{(byte)mC68000Cpu.data_regs[1]};
                this.buffer.add(byArray);
                break;
            }
            case 7: {
                this.addBytes(mC68000Cpu);
                break;
            }
            case 65: {
                this.sam.killSound(mC68000Cpu);
                break;
            }
            case 67: {
                if (mC68000Cpu.data_regs[1] != 0) {
                    mC68000Cpu.data_regs[0] = -6;
                    return;
                }
                mC68000Cpu.data_regs[1] = 102400;
                break;
            }
            default: {
                mC68000Cpu.data_regs[0] = -19;
            }
        }
    }

    public void addBytes(MC68000Cpu mC68000Cpu) {
        byte[] byArray;
        int n = mC68000Cpu.data_regs[3] == 0 ? mC68000Cpu.data_regs[2] : mC68000Cpu.data_regs[1];
        int n2 = mC68000Cpu.addr_regs[1];
        switch (this.deviceType) {
            default: {
                byArray = new byte[n * 2];
                for (int i = 0; i < n * 2; i += 2) {
                    byte by;
                    byArray[i] = by = (byte)mC68000Cpu.readMemoryByte(n2++);
                    byArray[i + 1] = by;
                }
                break;
            }
            case 2: 
            case 9: {
                byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)mC68000Cpu.readMemoryByte(n2++);
                }
                break;
            }
            case 3: {
                byArray = new byte[n * 4];
                for (int i = 0; i < n; ++i) {
                    byte by;
                    int n3 = mC68000Cpu.readMemoryByte(n2++);
                    this.av = (n3 + this.av) / 2;
                    byArray[i * 4] = by = (byte)this.av;
                    byArray[i * 4 + 1] = by;
                    byArray[i * 4 + 2] = by;
                    byArray[i * 4 + 3] = by;
                }
                break;
            }
            case 4: {
                byArray = new byte[n * 2];
                for (int i = 0; i < n * 2; i += 4) {
                    int n4 = mC68000Cpu.readMemoryByte(n2++);
                    this.av = (n4 + this.av) / 2;
                    byte by = (byte)this.av;
                    n4 = mC68000Cpu.readMemoryByte(n2++);
                    this.av1 = (n4 + this.av1) / 2;
                    byte by2 = (byte)this.av1;
                    byArray[i] = by;
                    byArray[i + 1] = by2;
                    byArray[i + 2] = by;
                    byArray[i + 3] = by2;
                }
                break;
            }
            case 5: {
                byArray = new byte[n];
                for (int i = 0; i < n; i += 2) {
                    byte by;
                    int n5 = mC68000Cpu.readMemoryByte(n2++);
                    this.av = n5 + mC68000Cpu.readMemoryByte(n2++) >>> 1;
                    byArray[i] = by = (byte)this.av;
                    byArray[i + 1] = by;
                }
                break;
            }
            case 6: {
                int n6 = n / 2;
                if ((n6 & 1) == 1) {
                    ++n6;
                }
                byArray = new byte[n6];
                for (int i = 0; i < n6; i += 2) {
                    int n7 = mC68000Cpu.readMemoryByte(n2++);
                    int n8 = mC68000Cpu.readMemoryByte(n2++);
                    this.av = (n7 + mC68000Cpu.readMemoryByte(n2++)) / 2;
                    this.av1 = (n8 + mC68000Cpu.readMemoryByte(n2++)) / 2;
                    byArray[i] = (byte)this.av;
                    byArray[i + 1] = (byte)this.av1;
                }
                break;
            }
            case 7: {
                byArray = new byte[n];
                for (int i = 0; i < n; i += 2) {
                    byte by = (byte)mC68000Cpu.readMemoryByte(n2);
                    n2 += 2;
                    byArray[i] = by;
                    byArray[i + 1] = by;
                }
                break;
            }
            case 8: {
                int n9 = n / 2;
                if ((n9 & 1) == 1) {
                    ++n9;
                }
                byArray = new byte[n9];
                for (int i = 0; i < n9; i += 2) {
                    byArray[i] = (byte)mC68000Cpu.readMemoryByte(n2++);
                    byArray[i + 1] = (byte)mC68000Cpu.readMemoryByte(n2);
                    n2 += 3;
                }
            }
        }
        this.sam.addChunk(byArray);
        mC68000Cpu.addr_regs[1] = n2;
        mC68000Cpu.data_regs[1] = n;
        mC68000Cpu.data_regs[0] = 0;
    }
}

