/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import smsqmulator.Helper;
import smsqmulator.Localization;
import smsqmulator.Monitor;
import smsqmulator.Types;
import smsqmulator.WinDrive;
import smsqmulator.WinFile;
import smsqmulator.cpu.MC68000Cpu;

public class WinDir
extends WinFile {
    public static final int HDR_FLEN = 0;
    public static final int HDR_ACCS = 4;
    public static final int HDR_TYPE = 5;
    public static final int hdrtExe = 1;
    public static final int hdrtRel = 2;
    public static final int hdrtLdr = 3;
    public static final int hdrtDir = 255;
    public static final int hdr_info = 6;
    public static final int hdr_data = 6;
    public static final int hdr_xtra = 10;
    public static final int HDR_NAME = 14;
    public static final int HDRNAMEL = 15;
    public static final int HDRNAME = 16;
    public static final int HDRNMLN = 36;
    public static final int HDR_DATE = 52;
    public static final int HDR_VERS = 56;
    public static final int HDR_FLID = 58;
    public static final int HDR_BKUP = 60;
    public static final int hdr_end = 64;
    public static final int hdrSet = 14;
    public static final int HDRLEN = 64;
    private int[] openChannels;
    private final BitSet fileAccess;
    private final ArrayList<WinDir> dirList = new ArrayList();
    private boolean listDone = false;
    private byte[] name;
    private byte[] normalizedName;

    public WinDir(WinDrive winDrive, WinDir winDir, int n, ByteBuffer byteBuffer, ArrayList<Integer> arrayList, byte[] byArray, byte[] byArray2) {
        super(winDrive, winDir, n, true, byteBuffer, arrayList);
        if (this.dir == null) {
            this.fileSize = this.drive.getIntFromFAT(54);
        }
        this.isDir = true;
        this.name = byArray;
        this.normalizedName = byArray2;
        if (this.normalizedName == null) {
            this.normalizedName = new byte[0];
        }
        if (this.name == null) {
            this.name = new byte[0];
        }
        this.openChannels = new int[this.buffer.capacity() / 64];
        this.fileAccess = new BitSet(this.buffer.capacity() / 64);
    }

    public WinFile openFile(int n, byte[] byArray, int n2, MC68000Cpu mC68000Cpu) {
        int n3 = n / 64;
        switch (n2) {
            case 0: {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ByteBuffer byteBuffer = this.drive.readFile(this.buffer.getInt(n), this.buffer.getShort(n + 58) & 0xFFFF, arrayList);
                WinFile winFile = new WinFile(this.drive, this, n, false, byteBuffer, arrayList);
                int n4 = n3;
                this.openChannels[n4] = this.openChannels[n4] + 1;
                this.fileAccess.set(n3);
                return winFile;
            }
            case 1: 
            case 4: {
                WinFile winFile;
                if (byArray == null || byArray.length == 0) {
                    ArrayList arrayList = (ArrayList)this.clusterchain.clone();
                    ByteBuffer byteBuffer = ByteBuffer.allocate(this.buffer.capacity());
                    this.buffer.position(0);
                    byteBuffer.put(this.buffer);
                    this.buffer.position(this.filePosition);
                    n2 = 4;
                    winFile = new WinFile(this.drive, null, 0, true, byteBuffer, arrayList);
                } else {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    ByteBuffer byteBuffer = this.drive.readFile(this.buffer.getInt(n), this.buffer.getShort(n + 58) & 0xFFFF, arrayList);
                    winFile = new WinFile(this.drive, this, n, true, byteBuffer, arrayList);
                }
                if (n2 == 4) {
                    winFile.setDirStatus(true);
                }
                int n5 = n3;
                this.openChannels[n5] = this.openChannels[n5] + 1;
                return winFile;
            }
            case 2: 
            case 3: {
                int n6;
                n = this.findFreeEntryInDir();
                if (n == -1) {
                    mC68000Cpu.data_regs[0] = -11;
                    return null;
                }
                ArrayList<Integer> arrayList = this.drive.allocateClusters(1);
                if (arrayList == null) {
                    mC68000Cpu.data_regs[0] = -11;
                    return null;
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.drive.getClusterSize());
                if (byteBuffer == null) {
                    mC68000Cpu.data_regs[0] = -3;
                    return null;
                }
                this.buffer.putInt(n, 64);
                for (n6 = n + 4; n6 < n + 64; n6 += 4) {
                    this.buffer.putInt(n6, 0);
                }
                this.buffer.put(n + 15, (byte)byArray.length);
                int n7 = n + 16;
                if (this.dir != null) {
                    for (n6 = 0; n6 < this.name.length; ++n6) {
                        this.buffer.put(n7 + n6, this.name[n6]);
                    }
                }
                while (n6 < byArray.length) {
                    this.buffer.put(n7 + n6, byArray[n6]);
                    ++n6;
                }
                this.buffer.putShort(n + 58, (short)(arrayList.get(0) & 0xFFFF));
                WinFile winFile = new WinFile(this.drive, this, n, false, byteBuffer, arrayList);
                winFile.setDirAndFatChanged();
                return winFile;
            }
        }
        return null;
    }

    public void closeFile(int n, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                int n2 = (int)(System.currentTimeMillis() / 1000L + (long)Monitor.TIME_OFFSET);
                this.buffer.putInt(n + 52, n2);
            }
            try {
                this.drive.writeFile(this.buffer, this.clusterchain);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n3 = n /= 64;
        this.openChannels[n3] = this.openChannels[n3] - 1;
        if (this.openChannels[n] < 1) {
            this.openChannels[n] = 0;
            this.fileAccess.set(n, false);
        }
    }

    public int deleteFile(int n) {
        int n2;
        boolean bl;
        if (n == 0) {
            if (this.dir == null) {
                return -9;
            }
            return this.dir.deleteFile(this.index);
        }
        if (this.openChannels[n / 64] > 0) {
            return -9;
        }
        if (this.openChannels[n / 64] != 0) {
            Helper.reportError(Localization.Texts[45], Localization.Texts[57] + this.openChannels[n / 64] + Localization.Texts[58] + "\n" + Localization.Texts[59], null);
            return -9;
        }
        int n3 = this.buffer.getShort(n + 58) & 0xFFFF;
        boolean bl2 = bl = this.buffer.get(n + 5) == -1;
        if (bl) {
            ArrayList<Integer> arrayList;
            n2 = this.buffer.getInt(n);
            ByteBuffer byteBuffer = this.drive.readFile(n2, n3, arrayList = new ArrayList<Integer>());
            if (byteBuffer == null || byteBuffer.capacity() < n2) {
                Helper.reportError(Localization.Texts[45], Localization.Texts[60] + "\n" + Localization.Texts[59], null);
                return -9;
            }
            for (int i = 64; i < n2; i += 64) {
                if (byteBuffer.getInt(i) == 0 && byteBuffer.getShort(i + 14) == 0) continue;
                return -9;
            }
        }
        for (n2 = n; n2 < n + 64; n2 += 4) {
            this.buffer.putInt(n2, 0);
        }
        if (bl) {
            this.dirList.clear();
            this.makeDirList();
        }
        this.writeFile(n, 64);
        return n3;
    }

    public boolean makeDirectory(int n, ArrayList<Integer> arrayList, ByteBuffer byteBuffer) {
        int n2;
        int n3;
        boolean bl = false;
        int n4 = 64;
        this.buffer.putInt(n + 4, 0xFF0000);
        this.buffer.putInt(n + 8, 0);
        this.buffer.putShort(n + 12, (short)0);
        this.buffer.putInt(n + 52, 0);
        this.buffer.putShort(n + 56, (short)0);
        this.buffer.putInt(n + 60, 0);
        int n5 = this.buffer.get(n + 14 + 1);
        if (n5 == 0) {
            return false;
        }
        while (this.buffer.get(n + 16 + n5 - 1) == Types.UNDERSCORE) {
            if ((n5 = (byte)(n5 - 1)) <= 0) {
                return false;
            }
            this.buffer.put(n + 16 + n5, (byte)0);
        }
        this.buffer.put(n + 14 + 1, (byte)n5);
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = this.buffer.get(n + 16 + n3) & 0xFF;
            byArray[n3] = (byte)n2;
            byArray2[n3] = WinDrive.LOWER_CASE[n2];
        }
        int n6 = n + 16;
        WinDir winDir = new WinDir(this.drive, this, n, byteBuffer, arrayList, byArray, byArray2);
        for (int i = 80; i < this.fileSize; i += 64) {
            int n7;
            int n8;
            if (i == n6 || (n3 = (int)this.buffer.get(i - 1)) <= n5 + 1) continue;
            boolean bl2 = true;
            for (n8 = 0; n8 < n5; ++n8) {
                n2 = this.buffer.get(i + n8) & 0xFF;
                if (WinDrive.LOWER_CASE[n2] == byArray2[n8]) continue;
                bl2 = false;
                break;
            }
            if (!bl2 || this.buffer.get(i + byArray.length) != Types.UNDERSCORE) continue;
            if (n4 + 64 > byteBuffer.capacity()) {
                ByteBuffer byteBuffer2 = this.drive.increaseCapacity(byteBuffer, 64, arrayList);
                if (byteBuffer2 == null) {
                    return false;
                }
                byteBuffer = byteBuffer2;
                winDir.setDirBuffer(byteBuffer);
            }
            n8 = i - 16;
            for (n7 = 0; n7 < 64; n7 += 4) {
                byteBuffer.putInt(n4 + n7, this.buffer.getInt(n8 + n7));
                this.buffer.putInt(n8 + n7, 0);
            }
            n7 = 0;
            int n9 = n4 + 16;
            while (n7 < byArray.length - 1) {
                byteBuffer.put(n9, byArray[n7]);
                ++n7;
                ++n9;
            }
            bl = true;
            this.drive.changeParentDir(this, n8, winDir, n4);
            if (byteBuffer.get(n4 + 5) == -1) {
                this.changeParentDir(n8, winDir, n4);
            }
            n4 += 64;
        }
        this.buffer.putInt(n, n4);
        this.dirList.add(winDir);
        winDir.fileSize = n4;
        winDir.writeFile(0, 0);
        if (bl) {
            this.writeFile(0, 0);
        } else {
            this.writeFile(n, 64);
        }
        this.drive.flush();
        return true;
    }

    public void renameFile(WinDir winDir, WinFile winFile, byte[] byArray) {
        int n;
        int n2;
        int n3 = winFile.getIndex();
        int n4 = this.name.length;
        if (winDir != this) {
            int n5;
            n2 = this.findFreeEntryInDir();
            ByteBuffer byteBuffer = winDir.getDirBuffer();
            for (n5 = 0; n5 < 64; ++n5) {
                this.buffer.put(n2 + n5, byteBuffer.get(n3 + n5));
                byteBuffer.put(n3 + n5, (byte)0);
            }
            winDir.writeFile(n3, 64);
            winFile.setDir(this);
            winFile.setIndex(n2);
            n3 = n2;
            for (n5 = 0; n5 < n4; ++n5) {
                this.buffer.put(n3 + 16 + n5, this.name[n5]);
            }
        }
        n2 = byArray.length;
        this.buffer.putShort(n3 + 14, (short)n2);
        this.buffer.position(n3 + 16 + n4);
        for (n = n4; n < n2; ++n) {
            this.buffer.put(byArray[n]);
        }
        for (n = n2; n < 36; ++n) {
            this.buffer.put((byte)0);
        }
        this.writeFile(n3, 64);
    }

    public void setFileHeader(int n, MC68000Cpu mC68000Cpu, int n2) {
        int n3 = mC68000Cpu.addr_regs[1] + 4;
        this.buffer.putInt(n, n2);
        int n4 = n + 4;
        while (n4 < 14 + n) {
            this.buffer.putShort(n4, mC68000Cpu.readMemoryShort(n3));
            n4 += 2;
            n3 += 2;
        }
        mC68000Cpu.addr_regs[1] = n3;
        mC68000Cpu.data_regs[1] = 14;
        mC68000Cpu.data_regs[0] = 0;
    }

    public void setInHeader(int n, int n2) {
        this.buffer.putInt(n, n2);
    }

    public boolean fileIsDir(int n) {
        if (n + 5 < this.fileSize) {
            return this.buffer.get(n + 5) == -1;
        }
        return false;
    }

    public int getFileLength(int n) {
        if (n < this.fileSize) {
            return this.buffer.getInt(n);
        }
        return 0;
    }

    public int getFileVersion(int n) {
        return this.buffer.getShort(n + 56) & 0xFFFF;
    }

    public void setFileVersion(int n, int n2) {
        this.buffer.putShort(n + 56, (short)(n2 & 0xFFFF));
    }

    public int getFileDate(int n) {
        return this.buffer.getInt(n);
    }

    public void setFileDate(int n, int n2) {
        this.buffer.putInt(n, n2);
    }

    private void makeDirList() {
        for (int i = 64; i < this.fileSize; i += 64) {
            if (this.buffer.get(i + 5) != -1) continue;
            int n = this.buffer.getInt(i);
            int n2 = this.buffer.getShort(i + 58) & 0xFFFF;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ByteBuffer byteBuffer = this.drive.readFile(n, n2, arrayList);
            int n3 = this.buffer.get(i + 15) & 0xFF;
            if (this.buffer.get(i + n3 - 1 + 16) == Types.UNDERSCORE) {
                --n3;
            }
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n3];
            int n4 = i + 16;
            for (int j = 0; j < n3; ++j) {
                byArray[j] = this.buffer.get(j + n4);
                int n5 = byArray[j] & 0xFF;
                byArray2[j] = WinDrive.LOWER_CASE[n5];
            }
            if (byteBuffer == null) continue;
            WinDir winDir = new WinDir(this.drive, this, i, byteBuffer, arrayList, byArray, byArray2);
            this.dirList.add(winDir);
        }
        this.listDone = true;
    }

    public WinDir findInDirs(byte[] byArray) {
        if (!this.listDone) {
            this.makeDirList();
        }
        int n = this.name.length;
        if (this.dir != null && n != 0) {
            int n2;
            if (n >= byArray.length) {
                return null;
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (this.normalizedName[n2] == byArray[n2]) continue;
                return null;
            }
            if (byArray[n2] != Types.UNDERSCORE) {
                return null;
            }
        }
        for (WinDir winDir : this.dirList) {
            WinDir winDir2 = winDir.findInDirs(byArray);
            if (winDir2 == null) continue;
            return winDir2;
        }
        return this;
    }

    public int checkFile(boolean[] blArray, byte[] byArray) {
        int n;
        int n2 = byArray.length;
        block0: for (n = 64; n < this.fileSize; n += 64) {
            if ((this.buffer.get(n + 15) & 0xFF) != n2) continue;
            int n3 = 0;
            int n4 = n + 16;
            while (n3 < n2) {
                int n5 = this.buffer.get(n4) & 0xFF;
                if (WinDrive.LOWER_CASE[n5] != byArray[n3]) continue block0;
                ++n3;
                ++n4;
            }
            blArray[0] = true;
            blArray[1] = this.buffer.get(n + 5) == -1;
            blArray[2] = this.fileAccess.get(n / 64);
            blArray[3] = this.openChannels[n / 64] != 0;
            return n;
        }
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        return 0;
    }

    public int findFreeEntryInDir() {
        for (int i = 64; i < this.fileSize; i += 64) {
            try {
                if (this.buffer.getInt(i) != 0 || this.buffer.getShort(i + 14) != 0) continue;
                return i;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        if (this.fileSize == this.buffer.capacity()) {
            ByteBuffer byteBuffer = this.drive.increaseCapacity(this.buffer, 64, this.clusterchain);
            if (byteBuffer == null) {
                return -1;
            }
            this.buffer = byteBuffer;
            this.openChannels = Arrays.copyOf(this.openChannels, this.buffer.capacity() / 64);
        }
        this.fileSize += 64;
        if (this.dir == null) {
            this.drive.setRootDirLength(this.fileSize);
        } else {
            this.dir.setInHeader(this.index, this.fileSize);
            this.dir.writeFile(this.index, 64);
        }
        return this.fileSize - 64;
    }

    private int calcDirSize(ByteBuffer byteBuffer) {
        for (int i = byteBuffer.capacity() - 64; i > 0; i -= 64) {
            if (byteBuffer.getInt(i) == 0 && byteBuffer.get(i) == 0) continue;
            return i - 64;
        }
        return 0;
    }

    private void makeNewEntry(int n, byte[] byArray) {
        int n2;
        this.buffer.putInt(n, 64);
        for (n2 = n + 4; n2 < n + 64; n2 += 4) {
            this.buffer.putInt(n2, 0);
        }
        this.buffer.put(n + 15, (byte)byArray.length);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.buffer.put(n + n2 + 16, byArray[n2]);
        }
        if (this.dir != null) {
            for (n2 = 0; n2 < this.name.length; ++n2) {
                this.buffer.put(n + n2 + 16, this.name[n2]);
            }
        }
    }

    public void addToList(WinDir winDir) {
        this.dirList.add(winDir);
    }

    public void removeFromList(WinDir winDir) {
        this.dirList.remove(winDir);
    }

    private void changeParentDir(int n, WinDir winDir, int n2) {
        ArrayList<WinDir> arrayList = new ArrayList<WinDir>();
        for (WinDir winDir2 : this.dirList) {
            if (winDir2.getIndex() != n) continue;
            arrayList.add(winDir2);
            winDir.addToList(winDir2);
            winDir2.setDir(winDir);
            winDir2.setIndex(n2);
        }
        for (WinDir winDir2 : arrayList) {
            this.dirList.remove(winDir2);
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public byte[] getUncasedName() {
        return this.normalizedName;
    }

    public ByteBuffer getDirBuffer() {
        return this.buffer;
    }

    private void setDirBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }
}

