/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class JavaComm
implements InstructionSet {
    private final int base = 40960;

    @Override
    public final void register(final MC68000Cpu mC68000Cpu) {
        int n;
        for (n = 0; n < 14; ++n) {
            mC68000Cpu.addInstruction(this.base + n, new Instruction(){
                private MC68000Cpu cpu;
                {
                    this.cpu = mC68000Cpu;
                }

                @Override
                public void execute(int n, MC68000Cpu mC68000Cpu2) {
                    if (n == 40960) {
                        this.cpu.stopNow = -10;
                        return;
                    }
                    if (this.cpu.trapDispatcher != null) {
                        this.cpu.trapDispatcher.dispatchTrap(-n, mC68000Cpu2);
                    }
                }

                @Override
                public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu2) {
                    return new DisassembledInstruction(n, n2, "JavaCom  TRAP #" + (n2 - 40960));
                }
            });
        }
        for (n = 2816; n < 2848; ++n) {
            mC68000Cpu.addInstruction(this.base + n, new Instruction(){
                private MC68000Cpu cpu;
                {
                    this.cpu = mC68000Cpu;
                }

                @Override
                public void execute(int n, MC68000Cpu mC68000Cpu2) {
                    if (this.cpu.trapDispatcher != null) {
                        this.cpu.trapDispatcher.dispatchTrap(-n, mC68000Cpu2);
                    }
                }

                @Override
                public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu2) {
                    return new DisassembledInstruction(n, n2, "JavaCom  ARIOP " + (43776 - n2));
                }
            });
        }
    }
}

