/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;

public class BSR
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        int n = 24832;
        Instruction instruction = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                int n2 = n & 0xFF;
                if ((n2 & 0x80) != 0) {
                    n2 |= 0xFFFFFF00;
                }
                if ((n2 & 1) != 0) {
                    mC68000Cpu.raiseException(3);
                } else {
                    mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
                    mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], mC68000Cpu.pc_reg * 2);
                    mC68000Cpu.pc_reg += n2 / 2;
                }
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                return BSR.this.disassembleOp(n, n2, mC68000Cpu);
            }
        };
        Instruction instruction2 = new Instruction(){

            @Override
            public final void execute(int n, MC68000Cpu mC68000Cpu) {
                mC68000Cpu.addr_regs[7] = mC68000Cpu.addr_regs[7] - 4;
                mC68000Cpu.writeMemoryLong(mC68000Cpu.addr_regs[7], (mC68000Cpu.pc_reg + 1) * 2);
                mC68000Cpu.pc_reg += mC68000Cpu.readMemoryWordPCSignedInc() / 2;
            }

            @Override
            public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                return BSR.this.disassembleOp(n, n2, mC68000Cpu);
            }
        };
        mC68000Cpu.addInstruction(n, instruction2);
        for (int i = 1; i < 256; ++i) {
            mC68000Cpu.addInstruction(n + i, instruction);
        }
    }

    public DisassembledInstruction disassembleOp(int n, int n2, MC68000Cpu mC68000Cpu) {
        String string;
        DisassembledOperand disassembledOperand;
        int n3 = n2 >> 8 & 0xF;
        int n4 = n2 & 0xFF;
        if ((n4 & 0x80) != 0) {
            n4 |= 0xFFFFFF00;
        }
        if (n4 != 0) {
            disassembledOperand = new DisassembledOperand(String.format("$%08x", n4 + n + 2));
            string = "bsr.s";
        } else {
            n4 = mC68000Cpu.readMemoryWordSigned(n + 2);
            disassembledOperand = new DisassembledOperand(String.format("$%08x", n4 + n + 2), 2, n4);
            string = "bsr.w";
        }
        return new DisassembledInstruction(n, n2, string, disassembledOperand);
    }
}

