/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions;

import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class EORI
implements InstructionSet {
    @Override
    public final void register(final MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 3; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 2560;
                instruction = new Instruction(){
                    private MC68000Cpu cpu;
                    {
                        this.cpu = mC68000Cpu;
                    }

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu2) {
                        int n2 = mC68000Cpu2.readMemoryWordPCInc() & 0xFF;
                        int n3 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n4 = mC68000Cpu2.data_regs[n & 7] & 0xFF;
                                int n5 = n & 7;
                                mC68000Cpu2.data_regs[n5] = mC68000Cpu2.data_regs[n5] & 0xFFFFFF00;
                                int n6 = n & 7;
                                mC68000Cpu2.data_regs[n6] = mC68000Cpu2.data_regs[n6] | (n4 ^= n2);
                                mC68000Cpu2.reg_sr &= 0xFFF0;
                                if (n4 == 0) {
                                    mC68000Cpu2.reg_sr |= 4;
                                } else if ((n4 & 0x80) != 0) {
                                    mC68000Cpu2.reg_sr |= 8;
                                }
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu2.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                int n7 = n & 7;
                                n3 = mC68000Cpu2.addr_regs[n7];
                                if (n7 == 7) {
                                    int n8 = n7;
                                    mC68000Cpu2.addr_regs[n8] = mC68000Cpu2.addr_regs[n8] + 2;
                                    break;
                                }
                                int n9 = n7;
                                mC68000Cpu2.addr_regs[n9] = mC68000Cpu2.addr_regs[n9] + 1;
                                break;
                            }
                            case 4: {
                                int n10 = n & 7;
                                if (n10 == 7) {
                                    int n11 = n10;
                                    mC68000Cpu2.addr_regs[n11] = mC68000Cpu2.addr_regs[n11] - 2;
                                } else {
                                    int n12 = n10;
                                    mC68000Cpu2.addr_regs[n12] = mC68000Cpu2.addr_regs[n12] - 1;
                                }
                                n3 = mC68000Cpu2.addr_regs[n10];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu2.addr_regs[n & 7] + mC68000Cpu2.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = EORI.this.getDisplacement(mC68000Cpu2) + mC68000Cpu2.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu2.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu2.readMemoryLongPC();
                                        mC68000Cpu2.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n13 = mC68000Cpu2.readMemoryByte(n3);
                        mC68000Cpu2.writeMemoryByte(n3, n13 ^= n2);
                        mC68000Cpu2.reg_sr &= 0xFFF0;
                        if (n13 == 0) {
                            mC68000Cpu2.reg_sr |= 4;
                        } else if ((n13 & 0x80) != 0) {
                            mC68000Cpu2.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu2) {
                        return EORI.this.disassembleOp(n, n2, Size.Byte, mC68000Cpu2);
                    }
                };
            } else if (i == 1) {
                n = 2624;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.readMemoryWordPCInc();
                        int n3 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n4 = mC68000Cpu.data_regs[n & 7] & 0xFFFF;
                                int n5 = n & 7;
                                mC68000Cpu.data_regs[n5] = mC68000Cpu.data_regs[n5] & 0xFFFF0000;
                                int n6 = n & 7;
                                mC68000Cpu.data_regs[n6] = mC68000Cpu.data_regs[n6] | (n4 ^= n2);
                                mC68000Cpu.reg_sr &= 0xFFF0;
                                if (n4 == 0) {
                                    mC68000Cpu.reg_sr |= 4;
                                } else if ((n4 & 0x8000) != 0) {
                                    mC68000Cpu.reg_sr |= 8;
                                }
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                int n7 = n & 7;
                                mC68000Cpu.addr_regs[n7] = mC68000Cpu.addr_regs[n7] + 2;
                                break;
                            }
                            case 4: {
                                int n8 = n & 7;
                                mC68000Cpu.addr_regs[n8] = mC68000Cpu.addr_regs[n8] - 2;
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = EORI.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n9 = mC68000Cpu.readMemoryWord(n3);
                        mC68000Cpu.writeMemoryWord(n3, n9 ^= n2);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n9 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if ((n9 & 0x8000) != 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return EORI.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }
                };
            } else {
                n = 2688;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2 = mC68000Cpu.readMemoryLongPC();
                        mC68000Cpu.pc_reg += 2;
                        int n3 = 0;
                        block0 : switch (n >> 3 & 7) {
                            case 0: {
                                int n4 = mC68000Cpu.data_regs[n & 7];
                                mC68000Cpu.data_regs[n & 7] = n4 ^= n2;
                                mC68000Cpu.reg_sr &= 0xFFF0;
                                if (n4 == 0) {
                                    mC68000Cpu.reg_sr |= 4;
                                } else if (n4 < 0) {
                                    mC68000Cpu.reg_sr |= 8;
                                }
                                return;
                            }
                            case 2: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 3: {
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                int n5 = n & 7;
                                mC68000Cpu.addr_regs[n5] = mC68000Cpu.addr_regs[n5] + 4;
                                break;
                            }
                            case 4: {
                                int n6 = n & 7;
                                mC68000Cpu.addr_regs[n6] = mC68000Cpu.addr_regs[n6] - 4;
                                n3 = mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 5: {
                                n3 = mC68000Cpu.addr_regs[n & 7] + mC68000Cpu.readMemoryWordPCSignedInc();
                                break;
                            }
                            case 6: {
                                n3 = EORI.this.getDisplacement(mC68000Cpu) + mC68000Cpu.addr_regs[n & 7];
                                break;
                            }
                            case 7: {
                                switch (n & 7) {
                                    case 0: {
                                        n3 = mC68000Cpu.readMemoryWordPCSignedInc();
                                        break block0;
                                    }
                                    case 1: {
                                        n3 = mC68000Cpu.readMemoryLongPC();
                                        mC68000Cpu.pc_reg += 2;
                                    }
                                }
                            }
                        }
                        int n7 = mC68000Cpu.readMemoryLong(n3);
                        mC68000Cpu.writeMemoryLong(n3, n7 ^= n2);
                        mC68000Cpu.reg_sr &= 0xFFF0;
                        if (n7 == 0) {
                            mC68000Cpu.reg_sr |= 4;
                        } else if (n7 < 0) {
                            mC68000Cpu.reg_sr |= 8;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return EORI.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }
                };
            }
            for (int j = 0; j < 8; ++j) {
                if (j == 1) continue;
                int n2 = j << 3;
                for (int k = 0; k < 8 && !(j == 7 & k > 1); ++k) {
                    mC68000Cpu.addInstruction(n + n2 + k, instruction);
                }
            }
        }
    }

    protected int getDisplacement(MC68000Cpu mC68000Cpu) {
        int n;
        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
        n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
        return n;
    }

    protected final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        int n3;
        String string;
        int n4;
        switch (size) {
            case Byte: {
                n4 = mC68000Cpu.readMemoryWord(n + 2);
                string = String.format("#$%02x", n4 & 0xFF);
                n3 = 2;
                break;
            }
            case Word: {
                n4 = mC68000Cpu.readMemoryWord(n + 2);
                string = String.format("#$%04x", n4);
                n3 = 2;
                break;
            }
            case Long: {
                n4 = mC68000Cpu.readMemoryLong(n + 2);
                string = String.format("#$%08x", n4);
                n3 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Size unsized for ORI");
            }
        }
        DisassembledOperand disassembledOperand = new DisassembledOperand(string, n3, n4);
        DisassembledOperand disassembledOperand2 = mC68000Cpu.disassembleDstEA(n + 2 + n3, n2 >> 3 & 7, n2 & 7, size);
        return new DisassembledInstruction(n, n2, "eori" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

