/*
 * Decompiled with CFR 0.152.
 */
package smsqmulator.cpu.instructions.MOVEM;

import smsqmulator.Helper;
import smsqmulator.cpu.DisassembledInstruction;
import smsqmulator.cpu.DisassembledOperand;
import smsqmulator.cpu.Instruction;
import smsqmulator.cpu.InstructionSet;
import smsqmulator.cpu.MC68000Cpu;
import smsqmulator.cpu.Size;

public class MOVEM2Reg8
implements InstructionSet {
    @Override
    public final void register(MC68000Cpu mC68000Cpu) {
        for (int i = 0; i < 2; ++i) {
            Instruction instruction;
            int n;
            if (i == 0) {
                n = 19643;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = mC68000Cpu.readMemoryWordPCInc();
                        int n4 = mC68000Cpu.pc_reg * 2 + this.getDisplacement(mC68000Cpu);
                        int n5 = 1;
                        for (n2 = 0; n2 < 8; ++n2) {
                            if ((n3 & n5) != 0) {
                                mC68000Cpu.data_regs[n2] = mC68000Cpu.readMemoryWordSigned(n4);
                                n4 += 2;
                            }
                            n5 <<= 1;
                        }
                        for (n2 = 0; n2 < 8; ++n2) {
                            if ((n3 & n5) != 0) {
                                mC68000Cpu.addr_regs[n2] = mC68000Cpu.readMemoryWordSigned(n4);
                                n4 += 2;
                            }
                            n5 <<= 1;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEM2Reg8.this.disassembleOp(n, n2, Size.Word, mC68000Cpu);
                    }

                    protected int getDisplacement(MC68000Cpu mC68000Cpu) {
                        int n;
                        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                        n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                        return n;
                    }
                };
            } else {
                n = 19707;
                instruction = new Instruction(){

                    @Override
                    public final void execute(int n, MC68000Cpu mC68000Cpu) {
                        int n2;
                        int n3 = mC68000Cpu.readMemoryWordPCInc();
                        int n4 = mC68000Cpu.pc_reg * 2 + this.getDisplacement(mC68000Cpu);
                        int n5 = 1;
                        for (n2 = 0; n2 < 8; ++n2) {
                            if ((n3 & n5) != 0) {
                                mC68000Cpu.data_regs[n2] = mC68000Cpu.readMemoryLong(n4);
                                n4 += 4;
                            }
                            n5 <<= 1;
                        }
                        for (n2 = 0; n2 < 8; ++n2) {
                            if ((n3 & n5) != 0) {
                                mC68000Cpu.addr_regs[n2] = mC68000Cpu.readMemoryLong(n4);
                                n4 += 4;
                            }
                            n5 <<= 1;
                        }
                    }

                    @Override
                    public DisassembledInstruction disassemble(int n, int n2, MC68000Cpu mC68000Cpu) {
                        return MOVEM2Reg8.this.disassembleOp(n, n2, Size.Long, mC68000Cpu);
                    }

                    protected int getDisplacement(MC68000Cpu mC68000Cpu) {
                        int n;
                        int n2 = mC68000Cpu.readMemoryWordPCSignedInc();
                        int n3 = n = (n2 & 0x80) != 0 ? n2 | 0xFFFFFF00 : n2 & 0xFF;
                        n = (n2 & 0x8000) != 0 ? ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.addr_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.addr_regs[n2 >> 12 & 7])) : ((n2 & 0x800) == 0 ? (n += MC68000Cpu.signExtendWord(mC68000Cpu.data_regs[n2 >> 12 & 7])) : (n += mC68000Cpu.data_regs[n2 >> 12 & 7]));
                        return n;
                    }
                };
            }
            mC68000Cpu.addInstruction(n, instruction);
        }
    }

    public final DisassembledInstruction disassembleOp(int n, int n2, Size size, MC68000Cpu mC68000Cpu) {
        int n3 = n2 >> 3 & 7;
        int n4 = n2 & 7;
        int n5 = mC68000Cpu.readMemoryWord(n + 2);
        boolean bl = n3 == 4;
        DisassembledOperand disassembledOperand = mC68000Cpu.disassembleSrcEA(n + 4, n3, n4, size);
        DisassembledOperand disassembledOperand2 = new DisassembledOperand(Helper.regListToString(n5, bl), 2, n5);
        return new DisassembledInstruction(n, n2, "movem" + size.ext(), disassembledOperand, disassembledOperand2);
    }
}

